/*
 * Decompiled with CFR 0.152.
 */
package org.spin.util.support.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.SardineFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.model.MADAppRegistration;
import org.spin.util.support.webdav.IWebDav;
import org.spin.util.support.webdav.IWebDavResource;
import org.spin.util.support.webdav.SardineResource;

public class SardineAPI
implements IWebDav {
    private int registrationId = 0;
    private Sardine connection = null;
    private String baseURL = null;

    private String getPath(String relativePath) {
        String path = this.baseURL;
        if (Util.isEmpty(relativePath)) {
            return path;
        }
        if (this.baseURL.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        return path + "/" + relativePath;
    }

    private void loadConnection() {
        if (this.connection != null) {
            return;
        }
        if (this.getAppRegistrationId() <= 0) {
            throw new AdempiereException("@AD_AppRegistration_ID@ @NotFound@");
        }
        MADAppRegistration registration = MADAppRegistration.getById(Env.getCtx(), this.getAppRegistrationId(), null);
        String userName = registration.getParameterValue("UserName");
        String password = registration.getParameterValue("Password");
        this.baseURL = registration.getParameterValue("BaseURL");
        if (Util.isEmpty(userName)) {
            throw new AdempiereException("@AD_User_ID@ @NotFound@");
        }
        if (Util.isEmpty(password)) {
            throw new AdempiereException("@Password@ @NotFound@");
        }
        if (Util.isEmpty(this.baseURL)) {
            throw new AdempiereException("@URL@ @NotFound@");
        }
        this.connection = SardineFactory.begin((String)userName, (String)password);
    }

    @Override
    public void setAppRegistrationId(int registrationId) {
        this.registrationId = registrationId;
    }

    @Override
    public int getAppRegistrationId() {
        return this.registrationId;
    }

    @Override
    public InputStream getResource(String relativePath) throws Exception {
        if (Util.isEmpty(relativePath)) {
            return null;
        }
        this.loadConnection();
        return this.connection.get(this.getPath(relativePath));
    }

    @Override
    public void putResource(String relativePath, InputStream resource) throws Exception {
        if (Util.isEmpty(relativePath) || resource == null) {
            return;
        }
        this.loadConnection();
        this.connection.put(this.getPath(relativePath), resource);
    }

    @Override
    public void deleteResource(String relativePath) throws Exception {
        if (Util.isEmpty(relativePath)) {
            return;
        }
        this.loadConnection();
        this.connection.delete(this.getPath(relativePath));
    }

    @Override
    public void createDirectory(String relativePathName) throws Exception {
        if (Util.isEmpty(relativePathName)) {
            return;
        }
        this.loadConnection();
        this.connection.createDirectory(this.getPath(relativePathName));
    }

    @Override
    public void moveResource(String relativeSourcePath, String relativeTargetPath) throws Exception {
        if (Util.isEmpty(relativeSourcePath) || Util.isEmpty(relativeTargetPath)) {
            return;
        }
        this.loadConnection();
        this.connection.move(this.getPath(relativeSourcePath), this.getPath(relativeTargetPath));
    }

    @Override
    public void copyResource(String relativeSourcePath, String relativeTargetPath) throws Exception {
        if (Util.isEmpty(relativeSourcePath) || Util.isEmpty(relativeTargetPath)) {
            return;
        }
        this.loadConnection();
        this.connection.copy(this.getPath(relativeSourcePath), this.getPath(relativeTargetPath));
    }

    @Override
    public boolean exists(String relativePath) throws Exception {
        if (Util.isEmpty(relativePath)) {
            return false;
        }
        this.loadConnection();
        return this.connection.exists(this.getPath(relativePath));
    }

    @Override
    public List<IWebDavResource> getResourceList(String relativePath) throws Exception {
        this.loadConnection();
        ArrayList<IWebDavResource> resources = new ArrayList<IWebDavResource>();
        List davResources = this.connection.list(this.getPath(relativePath));
        for (DavResource resource : davResources) {
            resources.add(new SardineResource(resource));
        }
        return resources;
    }

    @Override
    public void putResource(String relativePath, byte[] resource) throws Exception {
        if (Util.isEmpty(relativePath) || resource == null) {
            return;
        }
        this.loadConnection();
        this.connection.put(this.getPath(relativePath), resource);
    }

    @Override
    public String testConnection() {
        StringBuffer message = new StringBuffer();
        try {
            List<IWebDavResource> resources = this.getResourceList(null);
            for (IWebDavResource resource : resources) {
                if (message.length() > 0) {
                    message.append(Env.NL);
                }
                message.append(resource);
            }
        }
        catch (Exception e) {
            message.append(e.getLocalizedMessage());
        }
        return message.toString();
    }
}

