/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.discord.util;

import java.util.Arrays;
import java.util.Optional;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.requests.restaction.MessageAction;
import net.dv8tion.jda.api.utils.AttachmentOption;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAttachment;
import org.compiere.util.Util;
import org.spin.queue.notification.discord.util.IDiscordMessage;
import org.spin.queue.notification.model.MADNotificationQueue;
import org.spin.queue.notification.model.MADNotificationRecipient;

public class BaseMessage
implements IDiscordMessage {
    public static MessageAction createBaseMessage(JDA connector, String message, String channelName) {
        if (connector == null) {
            throw new AdempiereException("@Connection@ @IsMandatory@");
        }
        if (Util.isEmpty((String)message)) {
            throw new AdempiereException("@Message@ @IsMandatory@");
        }
        if (Util.isEmpty((String)channelName)) {
            throw new AdempiereException("@Channel@ @IsMandatory@");
        }
        TextChannel channel = BaseMessage.getChannel(connector, channelName);
        return channel.sendMessage((CharSequence)message);
    }

    private static TextChannel getChannel(JDA connector, String channelName) {
        if (channelName.matches("[+-]?\\d*(\\.\\d+)?")) {
            return connector.getTextChannelById(channelName);
        }
        Optional channel = connector.getTextChannelsByName(channelName, true).stream().findFirst();
        if (channel.isPresent()) {
            return (TextChannel)channel.get();
        }
        throw new AdempiereException("@Channel@ @IsMandatory@");
    }

    @Override
    public MessageAction createAndGetMessage(JDA connector, MADNotificationQueue notification, MADNotificationRecipient recipient) {
        StringBuilder messageInfo = new StringBuilder();
        if (!Util.isEmpty((String)notification.getDescription())) {
            messageInfo.append("**").append(notification.getDescription().trim()).append("**").append("\n");
        }
        if (!Util.isEmpty((String)notification.getText())) {
            messageInfo.append(notification.getText());
        }
        MessageAction message = BaseMessage.createBaseMessage(connector, messageInfo.toString(), recipient.getAccountName());
        MAttachment attachment = notification.getAttachment();
        if (attachment != null && attachment.getAD_Attachment_ID() > 0) {
            Arrays.asList(attachment.getEntries()).forEach(entry -> message.addFile(entry.getFile(), new AttachmentOption[0]));
        }
        return message;
    }
}

