/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.notification.discord.util;

import java.util.HashMap;
import java.util.Map;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;
import org.spin.queue.notification.discord.util.BaseMessage;
import org.spin.queue.notification.discord.util.IDiscordMessage;

public class MessageFactory {
    private Map<String, IDiscordMessage> messagesHandler = new HashMap<String, IDiscordMessage>();
    private static MessageFactory instance = new MessageFactory();

    public static MessageFactory getInstance() {
        return instance;
    }

    public IDiscordMessage getHandler(String messageType) {
        if (Util.isEmpty((String)messageType)) {
            throw new AdempiereException("@MessageType@ @IsMandatory@");
        }
        IDiscordMessage messageHandler = this.messagesHandler.get(messageType);
        if (messageHandler == null) {
            messageHandler = this.getStaticHandler(messageType);
            this.messagesHandler.put(messageType, messageHandler);
        }
        return messageHandler;
    }

    private IDiscordMessage getStaticHandler(String messageType) {
        BaseMessage handler = null;
        switch (messageType) {
            case "PRM": {
                handler = new BaseMessage();
                break;
            }
            case "SRV": {
                handler = new BaseMessage();
                break;
            }
            default: {
                handler = new BaseMessage();
            }
        }
        return handler;
    }
}

