/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_DD_Freight;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.eevolution.distribution.model.MDDFreightLine;

public class MDDFreight
extends X_DD_Freight
implements DocAction,
DocOptions {
    private static final long serialVersionUID = -3012349387181755416L;
    private List<MDDFreightLine> freightLines = null;
    private String processMsg = null;
    private boolean justPrepared = false;

    public MDDFreight(Properties ctx, int freightId, String trxName) {
        super(ctx, freightId, trxName);
    }

    public MDDFreight(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public List<MDDFreightLine> getLines() {
        if (this.freightLines != null) {
            return this.freightLines;
        }
        String whereClause = "DD_Freight_ID=?";
        this.freightLines = new Query(this.getCtx(), "DD_FreightLine", "DD_Freight_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("Line").list();
        return this.freightLines;
    }

    protected boolean beforeDelete() {
        for (MDDFreightLine line : this.getLines()) {
            line.deleteEx(true);
        }
        return true;
    }

    public boolean processIt(String action) throws Exception {
        this.processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(action, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        if (this.getLines().size() == 0) {
            throw new AdempiereException("@NoLines@");
        }
        MPeriod.testPeriodOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)"FRO", (int)this.getAD_Org_ID());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.processMsg != null) {
            return false;
        }
        this.voidIt();
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.processMsg != null) {
            return false;
        }
        this.voidIt();
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(" - ").append(this.getDocumentInfo());
        sb.append(": ").append(" (#").append(this.getLines().size()).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getDocumentInfo() {
        return Msg.getElement((Properties)this.getCtx(), (String)"DD_Freight_ID") + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public String getProcessMsg() {
        return null;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }
}

