/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.util.Arrays;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MMovement;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.distribution.model.MDDOrder;
import org.eevolution.distribution.process.GenerateMovementAbstract;
import org.eevolution.distribution.process.MovementGenerate;
import org.eevolution.services.dsl.ProcessBuilder;

public class GenerateMovement
extends GenerateMovementAbstract {
    private String result;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        ProcessInfo processInfo = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(MovementGenerate.getProcessId())).withTitle(GenerateMovement.getProcessName()).withRecordId(Integer.valueOf(MDDOrder.Table_ID), Integer.valueOf(0)).withSelectedRecordsIds(MDDOrder.Table_ID, this.getSelectionKeys()).withParameter("MovementDate", (Object)this.getMovementDate()).withParameter("DocAction", (Object)"CO").execute();
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getSummary());
        }
        this.result = processInfo.getSummary();
        int[] movementProcessedIds = processInfo.getIDs();
        if (movementProcessedIds != null && movementProcessedIds.length > 0) {
            Arrays.stream(movementProcessedIds).filter(movementId -> movementId > 0).forEach(movementId -> {
                MMovement movement = new MMovement(this.getCtx(), movementId, null);
                StringBuffer resultText = new StringBuffer(Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo") + " : " + movement.getDocumentNo());
                this.result = this.result == null ? " " + resultText.toString() : this.result + " " + resultText.toString();
                this.printDocument((PO)movement, "Inventory Move Hdr (Example)");
            });
        }
        return this.result;
    }
}

