/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.util.List;
import java.util.Optional;
import org.compiere.model.PO;
import org.eevolution.distribution.model.MDDDriver;
import org.eevolution.distribution.model.MDDLicenseAssignment;
import org.eevolution.distribution.model.MDDRequirementAssignment;
import org.eevolution.distribution.process.ProcessingDriverSelectionAbstract;

public class ProcessingDriverSelection
extends ProcessingDriverSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        List drivers = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MDDDriver.Table_ID) {
            if (this.getProcessInfo().getTable_ID() == MDDDriver.Table_ID) {
                MDDDriver driverFrom = (MDDDriver)((Object)drivers.stream().findFirst().get());
                MDDDriver driverTo = (MDDDriver)this.getInstance(this.get_TrxName());
                if (driverFrom != null && driverTo != null && driverFrom.get_ID() != driverTo.get_ID()) {
                    this.CopyDriver(driverFrom, driverTo);
                }
            }
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingDriver(drivers);
        }
        return "@Ok@";
    }

    private void UpdatingDriver(List<MDDDriver> drivers) {
        drivers.stream().filter(driver -> driver != null).forEach(driver -> {
            int columns = driver.get_ColumnCount();
            for (int index = 0; index < columns; ++index) {
                String columnName = driver.get_ColumnName(index);
                Optional.ofNullable(this.getSelection(driver.get_ID(), this.getPrefixAliasForTableSelection() + columnName)).ifPresent(value -> driver.set_ValueOfColumn(columnName, value));
            }
            driver.saveEx();
        });
    }

    protected void CopyDriver(MDDDriver driverFrom, MDDDriver driverTo) {
        PO.copyValues((PO)driverFrom, (PO)driverTo);
        driverFrom.getLicenseAssignments().forEach(licenseAssignment -> {
            MDDLicenseAssignment licenseAssignmentTo = new MDDLicenseAssignment(driverTo, licenseAssignment.getDD_License_ID());
            licenseAssignmentTo.saveEx();
        });
        driverFrom.getRequirementAssignments().forEach(requirementAssignment -> {
            MDDRequirementAssignment requirementAssignmentTo = new MDDRequirementAssignment(driverTo, requirementAssignment.getDD_Requirement_ID());
            requirementAssignmentTo.saveEx();
        });
        driverTo.saveEx();
    }
}

