/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eevolution.distribution.model.MDDDriver;
import org.eevolution.distribution.model.MDDLicense;
import org.eevolution.distribution.model.MDDLicenseAssignment;
import org.eevolution.distribution.model.MDDVehicle;
import org.eevolution.distribution.process.ProcessingLicenseSelectionAbstract;

public class ProcessingLicenseSelection
extends ProcessingLicenseSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        List licenses = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MDDLicense.Table_ID) {
            if (this.getProcessInfo().getTable_ID() == MDDDriver.Table_ID) {
                MDDDriver driver = (MDDDriver)this.getInstance(this.get_TrxName());
                this.createDriverLicense(driver, licenses);
            }
            if (this.getProcessInfo().getTable_ID() == MDDVehicle.Table_ID) {
                MDDVehicle vehicle = (MDDVehicle)this.getInstance(this.get_TrxName());
                this.createVehicleLicense(vehicle, licenses);
            }
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingLicense(licenses);
        }
        return "";
    }

    private void createDriverLicense(MDDDriver driver, List<MDDLicense> licenses) {
        AtomicInteger lineNo = new AtomicInteger(0);
        licenses.stream().filter(license -> license != null).forEach(license -> {
            MDDLicenseAssignment assignment = new MDDLicenseAssignment(driver, license.get_ID());
            assignment.setSeqNo(lineNo.updateAndGet(no -> no + 10));
            assignment.saveEx();
        });
    }

    private void createVehicleLicense(MDDVehicle vehicle, List<MDDLicense> licenses) {
        AtomicInteger lineNo = new AtomicInteger(0);
        licenses.stream().filter(license -> license != null).forEach(license -> {
            MDDLicenseAssignment assignment = new MDDLicenseAssignment(vehicle, license.get_ID());
            assignment.setSeqNo(lineNo.updateAndGet(no -> no + 10));
            assignment.saveEx();
        });
    }

    private void UpdatingLicense(List<MDDLicense> licenses) {
        licenses.stream().filter(license -> license != null).forEach(license -> {
            int columns = license.get_ColumnCount();
            for (int index = 0; index < columns; ++index) {
                String columnName = license.get_ColumnName(index);
                Optional.ofNullable(this.getSelection(license.get_ID(), this.getPrefixAliasForTableSelection() + columnName)).ifPresent(value -> license.set_ValueOfColumn(columnName, value));
            }
            license.saveEx();
        });
    }
}

