/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.eevolution.distribution.model.MDDDriver;
import org.eevolution.distribution.model.MDDRequirement;
import org.eevolution.distribution.model.MDDRequirementAssignment;
import org.eevolution.distribution.model.MDDVehicle;
import org.eevolution.distribution.process.ProcessingRequirementSelectionAbstract;

public class ProcessingRequirementSelection
extends ProcessingRequirementSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        List requirements = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MDDRequirement.Table_ID) {
            if (this.getProcessInfo().getTable_ID() == MDDDriver.Table_ID) {
                MDDDriver driver = (MDDDriver)this.getInstance(this.get_TrxName());
                this.createDriverRequirement(driver, requirements);
            }
            if (this.getProcessInfo().getTable_ID() == MDDVehicle.Table_ID) {
                MDDVehicle vehicle = (MDDVehicle)this.getInstance(this.get_TrxName());
                this.createVehicleRequirement(vehicle, requirements);
            }
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingRequirement(requirements);
        }
        return "";
    }

    private void createDriverRequirement(MDDDriver driver, List<MDDRequirement> requirements) {
        AtomicInteger lineNo = new AtomicInteger(0);
        requirements.stream().filter(requirement -> requirement != null).forEach(requirement -> {
            MDDRequirementAssignment assignment = new MDDRequirementAssignment(driver, requirement.get_ID());
            assignment.setSeqNo(lineNo.updateAndGet(no -> no + 10));
            assignment.saveEx();
        });
    }

    private void createVehicleRequirement(MDDVehicle vehicle, List<MDDRequirement> requirements) {
        AtomicInteger lineNo = new AtomicInteger(0);
        requirements.stream().filter(requirement -> requirement != null).forEach(requirement -> {
            MDDRequirementAssignment assignment = new MDDRequirementAssignment(vehicle, requirement.get_ID());
            assignment.setSeqNo(lineNo.updateAndGet(no -> no + 10));
            assignment.saveEx();
        });
    }

    private void UpdatingRequirement(List<MDDRequirement> requirements) {
        requirements.stream().filter(requirement -> requirement != null).forEach(requirement -> {
            int columns = requirement.get_ColumnCount();
            for (int index = 0; index < columns; ++index) {
                String columnName = requirement.get_ColumnName(index);
                Optional.ofNullable(this.getSelection(requirement.get_ID(), this.getPrefixAliasForTableSelection() + columnName)).ifPresent(value -> requirement.set_ValueOfColumn(columnName, value));
            }
            requirement.saveEx();
        });
    }
}

