/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.distribution.process;

import java.util.List;
import java.util.Optional;
import org.compiere.model.PO;
import org.eevolution.distribution.model.MDDLicenseAssignment;
import org.eevolution.distribution.model.MDDRequirementAssignment;
import org.eevolution.distribution.model.MDDVehicle;
import org.eevolution.distribution.process.ProcessingVehicleSelectionAbstract;

public class ProcessingVehicleSelection
extends ProcessingVehicleSelectionAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        List vehicles = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MDDVehicle.Table_ID) {
            if (this.getProcessInfo().getTable_ID() == MDDVehicle.Table_ID) {
                MDDVehicle vehicleFrom = (MDDVehicle)((Object)vehicles.stream().findFirst().get());
                MDDVehicle vehicleTo = (MDDVehicle)this.getInstance(this.get_TrxName());
                if (vehicleFrom != null && vehicleTo != null && vehicleFrom.get_ID() != vehicleTo.get_ID()) {
                    this.CopyVehicle(vehicleFrom, vehicleTo);
                }
            }
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            this.UpdatingVehicle(vehicles);
        }
        return "@Ok@";
    }

    private void UpdatingVehicle(List<MDDVehicle> vehicles) {
        vehicles.stream().filter(vehicle -> vehicle != null).forEach(vehicle -> {
            int columns = vehicle.get_ColumnCount();
            for (int index = 0; index < columns; ++index) {
                String columnName = vehicle.get_ColumnName(index);
                Optional.ofNullable(this.getSelection(vehicle.get_ID(), this.getPrefixAliasForTableSelection() + columnName)).ifPresent(value -> vehicle.set_ValueOfColumn(columnName, value));
            }
            vehicle.saveEx();
        });
    }

    private void CopyVehicle(MDDVehicle vehicleFrom, MDDVehicle vehicleTo) {
        PO.copyValues((PO)vehicleFrom, (PO)vehicleTo);
        vehicleFrom.getLicenseAssignments().forEach(licenseAssignment -> {
            MDDLicenseAssignment licenseAssignmentTo = new MDDLicenseAssignment(vehicleFrom, licenseAssignment.getDD_License_ID());
            licenseAssignmentTo.saveEx();
        });
        vehicleFrom.getRequirementAssignments().forEach(requirementAssignment -> {
            MDDRequirementAssignment requirementAssignmentTo = new MDDRequirementAssignment(vehicleFrom, requirementAssignment.getDD_Requirement_ID());
            requirementAssignmentTo.saveEx();
        });
        vehicleTo.saveEx();
    }
}

