/*
 * Decompiled with CFR 0.152.
 */
package compiere.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRole;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MyValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(MyValidator.class);
    private int m_AD_Client_ID = -1;
    private int m_AD_User_ID = -1;
    private int m_AD_Role_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po.get_TableName().equals("C_Order") && type == 2) {
            MOrder order = (MOrder)po;
            log.info(po.toString());
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(po.get_TableName() + " Timing: " + timing);
        if (timing == 9) {
            return null;
        }
        if (timing == 1 && po.get_TableName().equals("C_Order")) {
            log.info(po.toString());
        }
        return null;
    }

    private String orderDiscount(MOrder order) {
        String DISCOUNT = "Discount";
        int C_Tax_ID = 0;
        BigDecimal totalLines = Env.ZERO;
        MOrderLine discountLine = null;
        MOrderLine[] lines = order.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine oLine = lines[i];
            String description = oLine.getDescription();
            if (description != null && description.equals(DISCOUNT)) {
                discountLine = oLine;
                continue;
            }
            totalLines = totalLines.add(oLine.getLineNetAmt());
            if (C_Tax_ID == 0) {
                C_Tax_ID = oLine.getC_Tax_ID();
                continue;
            }
            if (C_Tax_ID == oLine.getC_Tax_ID()) continue;
            return "Order has more then one Tax, cannot add discount";
        }
        if (discountLine == null) {
            discountLine = new MOrderLine(order);
            discountLine.setDescription(DISCOUNT);
            discountLine.setQty(Env.ONE);
            discountLine.setC_Tax_ID(C_Tax_ID);
            discountLine.setLine(9999);
        }
        BigDecimal discountPercent = new BigDecimal(3);
        BigDecimal discountAmt = totalLines.multiply(discountPercent);
        discountAmt = discountAmt.divide(Env.ONEHUNDRED, order.getPrecision(), RoundingMode.HALF_UP);
        discountLine.setPrice(discountAmt.negate());
        if (!discountLine.save()) {
            return "Could not save discount line";
        }
        log.info(discountLine.toString());
        order.getLines(true, null);
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        this.m_AD_User_ID = AD_User_ID;
        this.m_AD_Role_ID = AD_Role_ID;
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MyValidator[Order@Gardenworld");
        sb.append("]");
        return sb.toString();
    }

    public void beforeSaveProperties() {
        if (this.m_AD_User_ID == 0 || this.m_AD_User_ID == 100 || this.m_AD_Role_ID == 0 || this.m_AD_Role_ID == 1000000) {
            return;
        }
        log.info("Setting default Properties");
        MRole role = MRole.get((Properties)Env.getCtx(), (int)this.m_AD_Role_ID);
    }
}

