/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_Concept_Acct;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.eevolution.hr.acct.DocLine_Payroll;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRProcess;

public class Doc_HRProcess
extends Doc {
    public MHRProcess process = null;
    public static final String DOCTYPE_Payroll = "HRP";

    public Doc_HRProcess(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MHRProcess.class, rs, DOCTYPE_Payroll, trxName);
    }

    protected String loadDocumentDetails() {
        this.process = (MHRProcess)this.getPO();
        this.setDateDoc(this.getDateAcct());
        this.p_lines = this.loadLines(this.process);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MHRProcess process) {
        ArrayList<DocLine_Payroll> list = new ArrayList<DocLine_Payroll>();
        List movements = new Query(this.getCtx(), "HR_Movement", "HR_Movement.HR_Process_ID = ? AND HR_Movement.Amount <> 0 AND EXISTS(SELECT 1 FROM HR_Concept c \t\t\t\t\tWHERE c.HR_Concept_ID = HR_Movement.HR_Concept_ID \t\t\t\t\tAND c.AccountSign != 'N')", this.getTrxName()).setParameters(new Object[]{process.getHR_Process_ID()}).setOrderBy("C_BPartner_ID").list();
        for (MHRMovement line : movements) {
            DocLine_Payroll docLine = new DocLine_Payroll(line, this);
            this.log.fine(docLine.toString());
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        int C_Charge_ID;
        int C_BPartner_ID = 0;
        Fact fact = new Fact((Doc)this, as, "A");
        BigDecimal totalDebit = Env.ZERO;
        BigDecimal totalCredit = Env.ZERO;
        MHRPayroll payroll = MHRPayroll.getById(this.getCtx(), this.process.getHR_Payroll_ID(), this.getTrxName());
        for (DocLine line : this.p_lines) {
            FactLine debitLine;
            MAccount accountBPD;
            if (C_BPartner_ID == 0) {
                C_BPartner_ID = line.getC_BPartner_ID();
            }
            if (line.getC_BPartner_ID() != 0 && line.getC_BPartner_ID() != C_BPartner_ID && payroll.isPostPerEmployee()) {
                this.closeBPartner(totalDebit, totalCredit, fact, as, C_BPartner_ID);
                C_BPartner_ID = line.getC_BPartner_ID();
                totalDebit = Env.ZERO;
                totalCredit = Env.ZERO;
            }
            DocLine_Payroll payrollDocLine = (DocLine_Payroll)line;
            BigDecimal sumAmount = line.getAmtSource();
            sumAmount = sumAmount.setScale(as.getStdPrecision(), RoundingMode.HALF_UP);
            MHRConcept concept = MHRConcept.getById(as.getCtx(), payrollDocLine.getHR_Concept_ID(), this.getTrxName());
            X_HR_Concept_Acct conceptAcct = concept.getConceptAcct(Optional.ofNullable(as.getC_AcctSchema_ID()), Optional.ofNullable(this.process.getHR_Payroll_ID()), Optional.ofNullable(payrollDocLine.getC_BP_Group_ID()));
            if (conceptAcct == null || payrollDocLine.getAccountSign() == null || payrollDocLine.getAccountSign().length() <= 0 || !"D".equals(payrollDocLine.getAccountSign()) && !"C".equals(payrollDocLine.getAccountSign())) continue;
            if (conceptAcct.isBalancing()) {
                accountBPD = MAccount.getValidCombination((Properties)this.getCtx(), (int)conceptAcct.getHR_Expense_Acct(), (String)this.getTrxName());
                debitLine = fact.createLine(line, accountBPD, this.getC_Currency_ID(), sumAmount, null);
                debitLine.setDescription(this.process.getDocumentNo() + " " + this.process.getName() + " " + concept.getValue() + " " + concept.getName());
                debitLine.saveEx();
                MAccount accountBPC = MAccount.getValidCombination((Properties)this.getCtx(), (int)conceptAcct.getHR_Revenue_Acct(), (String)this.getTrxName());
                FactLine creditLine = fact.createLine(line, accountBPC, this.getC_Currency_ID(), null, sumAmount);
                creditLine.setDescription(this.process.getDocumentNo() + " " + this.process.getName() + " " + concept.getValue() + " " + concept.getName());
                creditLine.saveEx();
                continue;
            }
            if ("D".equals(payrollDocLine.getAccountSign())) {
                accountBPD = MAccount.getValidCombination((Properties)this.getCtx(), (int)conceptAcct.getHR_Expense_Acct(), (String)this.getTrxName());
                debitLine = fact.createLine(line, accountBPD, this.getC_Currency_ID(), sumAmount, null);
                debitLine.setDescription(this.process.getDocumentNo() + " " + this.process.getName() + " " + concept.getValue() + " " + concept.getName());
                debitLine.saveEx();
                totalDebit = totalDebit.add(sumAmount);
                continue;
            }
            if (!"C".equals(payrollDocLine.getAccountSign())) continue;
            MAccount accountBPC = MAccount.getValidCombination((Properties)this.getCtx(), (int)conceptAcct.getHR_Revenue_Acct(), (String)this.getTrxName());
            FactLine creditLine = fact.createLine(line, accountBPC, this.getC_Currency_ID(), null, sumAmount);
            creditLine.setDescription(this.process.getDocumentNo() + " " + this.process.getName() + " " + concept.getValue() + " " + concept.getName());
            creditLine.saveEx();
            totalCredit = totalCredit.add(sumAmount);
        }
        if (payroll.isPostPerEmployee()) {
            this.closeBPartner(totalDebit, totalCredit, fact, as, C_BPartner_ID);
        } else if ((totalDebit.signum() != 0 || totalCredit.signum() != 0) && (C_Charge_ID = payroll.getC_Charge_ID()) > 0) {
            MAccount acct = MCharge.getAccount((int)C_Charge_ID, (MAcctSchema)as, (BigDecimal)totalDebit.subtract(totalCredit));
            FactLine regTotal = null;
            regTotal = totalDebit.abs().compareTo(totalCredit.abs()) > 0 ? fact.createLine(null, acct, this.getC_Currency_ID(), null, totalDebit.subtract(totalCredit)) : fact.createLine(null, acct, this.getC_Currency_ID(), totalCredit.abs().subtract(totalDebit.abs()), null);
            regTotal.setAD_Org_ID(this.getAD_Org_ID());
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private void closeBPartner(BigDecimal totalDebit, BigDecimal totalCredit, Fact fact, MAcctSchema as, int c_bpartner_id) {
        MHRPayroll payroll;
        int C_Charge_ID;
        if ((totalDebit.signum() != 0 || totalCredit.signum() != 0) && (C_Charge_ID = (payroll = MHRPayroll.getById(this.getCtx(), this.process.getHR_Payroll_ID(), this.getTrxName())).getC_Charge_ID()) > 0) {
            MAccount acct = MCharge.getAccount((int)C_Charge_ID, (MAcctSchema)as, (BigDecimal)totalDebit.subtract(totalCredit));
            FactLine regTotal = null;
            regTotal = totalDebit.abs().compareTo(totalCredit.abs()) > 0 ? fact.createLine(null, acct, this.getC_Currency_ID(), null, totalDebit.subtract(totalCredit)) : fact.createLine(null, acct, this.getC_Currency_ID(), totalCredit.abs().subtract(totalDebit.abs()), null);
            if (regTotal != null) {
                regTotal.setAD_Org_ID(this.getAD_Org_ID());
                regTotal.setC_BPartner_ID(c_bpartner_id);
                regTotal.saveEx();
            }
        }
    }
}

