/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.controller;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.I_HR_EmployeeInsurance;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBPartner;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class CalloutEmployee
extends CalloutEngine {
    public void calculateInsuranceBalance(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || this.isCalloutActive()) {
            return;
        }
        I_HR_EmployeeInsurance employeeInsurance = (I_HR_EmployeeInsurance)GridTabWrapper.create((Object)mTab, I_HR_EmployeeInsurance.class);
        BigDecimal balanceAmount = employeeInsurance.getCoverageAmount().subtract(employeeInsurance.getClaimedAmount());
        employeeInsurance.setBalanceAmount(balanceAmount);
    }

    public String validateLastPaidDate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        I_HR_EmployeeInsurance employeeInsurance = (I_HR_EmployeeInsurance)GridTabWrapper.create((Object)mTab, I_HR_EmployeeInsurance.class);
        Timestamp payDate = employeeInsurance.getPayDate();
        Timestamp lastPaidDate = (Timestamp)value;
        if (payDate == null) {
            return "";
        }
        if (lastPaidDate.before(payDate)) {
            return "";
        }
        String message = Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + "  " + Msg.parseTranslation((Properties)ctx, (String)"@PayDate@");
        employeeInsurance.setDateLastPaid((Timestamp)mField.getOldValue());
        mTab.fireDataStatusEEvent(message, null, false);
        return "";
    }

    public String validateLastPremiumDate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        I_HR_EmployeeInsurance employeeInsurance = (I_HR_EmployeeInsurance)GridTabWrapper.create((Object)mTab, I_HR_EmployeeInsurance.class);
        Timestamp payDate = employeeInsurance.getPayDate();
        Timestamp lastPremiumDate = (Timestamp)value;
        if (payDate == null) {
            return "";
        }
        if (lastPremiumDate.after(payDate)) {
            return "";
        }
        String message = Msg.getMsg((Properties)Env.getCtx(), (String)"Invalid") + " " + Msg.parseTranslation((Properties)ctx, (String)"@HR_EmployeeInsurance_ID@");
        employeeInsurance.setDateLastPremium((Timestamp)mField.getOldValue());
        mTab.fireDataStatusEEvent(message, null, false);
        return "";
    }

    public void bpartnerRelation(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || this.isCalloutActive()) {
            return;
        }
        Integer bPartnerId = (Integer)value;
        if (bPartnerId <= 0) {
            return;
        }
        MBPartner bPartner = MBPartner.get((Properties)ctx, (int)bPartnerId);
        Object name = bPartner.getName();
        if (bPartner.getName2() != null && bPartner.getName2().trim().length() > 0) {
            name = (String)name + " " + bPartner.getName2();
        }
        mTab.setValue("Name", name);
    }
}

