/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.controller;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.I_HR_WorkShift;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CalloutWorkShift
extends CalloutEngine {
    public String calculateHours(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null) {
            return "";
        }
        I_HR_WorkShift workShift = (I_HR_WorkShift)GridTabWrapper.create((Object)mTab, I_HR_WorkShift.class);
        Timestamp fromTime = workShift.getShiftFromTime();
        Timestamp toTime = workShift.getShiftToTime();
        Timestamp breakStartTime = workShift.getBreakStartTime();
        Timestamp breakEndTime = workShift.getBreakEndTime();
        BigDecimal breakHourNo = workShift.getBreakHoursNo();
        if (fromTime == null || toTime == null) {
            return "";
        }
        if (fromTime.after(toTime)) {
            toTime = TimeUtil.getDayTime((Timestamp)TimeUtil.addDays((Timestamp)toTime, (int)1), (Timestamp)toTime);
        }
        if (breakStartTime != null && breakEndTime != null) {
            if (breakStartTime.after(breakEndTime)) {
                breakEndTime = TimeUtil.getDayTime((Timestamp)TimeUtil.addDays((Timestamp)breakEndTime, (int)1), (Timestamp)breakEndTime);
            }
            long breakDifference = breakEndTime.getTime() - breakStartTime.getTime();
            breakHourNo = new BigDecimal((double)breakDifference / 3600000.0);
        }
        if (breakHourNo == null) {
            breakHourNo = Env.ZERO;
        }
        long workDifference = toTime.getTime() - fromTime.getTime();
        BigDecimal workHourNo = new BigDecimal((double)workDifference / 3600000.0);
        workShift.setBreakHoursNo(breakHourNo);
        workShift.setNoOfHours(workHourNo.subtract(breakHourNo));
        return "";
    }
}

