/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_CareerLevel;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRCareerLevel
extends X_HR_CareerLevel {
    private static final long serialVersionUID = 5882296459857371182L;
    private static CCache<Integer, MHRCareerLevel> careerLevelCacheIds = new CCache("HR_CareerLevel", 50, 0);
    private static CCache<String, MHRCareerLevel> careerLavelCacheValues = new CCache("HR_CareerLevel", 50, 0);

    public static MHRCareerLevel getById(Properties ctx, int careerLevelId, String trxName) {
        MHRCareerLevel careerLevel;
        if (careerLevelId <= 0) {
            return null;
        }
        if (careerLevelCacheIds.size() == 0) {
            MHRCareerLevel.getAll(ctx, true, trxName);
        }
        if ((careerLevel = (MHRCareerLevel)((Object)careerLevelCacheIds.get((Object)careerLevelId))) != null && careerLevel.get_ID() > 0) {
            return careerLevel;
        }
        careerLevel = (MHRCareerLevel)new Query(ctx, "HR_CareerLevel", "HR_CareerLevel_ID=?", trxName).setClient_ID().setParameters(new Object[]{careerLevelId}).first();
        if (careerLevel != null && careerLevel.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + careerLevel.getValue();
            careerLevelCacheIds.put((Object)careerLevel.get_ID(), (Object)careerLevel);
            careerLavelCacheValues.put((Object)key, (Object)careerLevel);
        }
        return careerLevel;
    }

    public static MHRCareerLevel getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRCareerLevel careerLevel;
        if (value == null) {
            return null;
        }
        if (careerLavelCacheValues.size() == 0) {
            MHRCareerLevel.getAll(ctx, true, trxName);
        }
        if ((careerLevel = (MHRCareerLevel)((Object)careerLavelCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && careerLevel.get_ID() > 0) {
            return careerLevel;
        }
        careerLevel = (MHRCareerLevel)new Query(ctx, "HR_CareerLevel", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (careerLevel != null && careerLevel.get_ID() > 0) {
            careerLavelCacheValues.put((Object)key, (Object)careerLevel);
            careerLevelCacheIds.put((Object)careerLevel.get_ID(), (Object)careerLevel);
        }
        return careerLevel;
    }

    public static List<MHRCareerLevel> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || careerLevelCacheIds.size() > 0) {
            List careerLevelList = new Query(Env.getCtx(), "HR_CareerLevel", null, trxName).setClient_ID().setOrderBy("Name").list();
            careerLevelList.stream().forEach(careerLevel -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + careerLevel.getValue();
                careerLevelCacheIds.put((Object)careerLevel.getHR_CareerLevel_ID(), (Object)careerLevel);
                careerLavelCacheValues.put((Object)key, (Object)careerLevel);
            });
            return careerLevelList;
        }
        List<MHRCareerLevel> careerLevelList = careerLevelCacheIds.entrySet().stream().map(careerLevel -> (MHRCareerLevel)((Object)((Object)careerLevel.getValue()))).collect(Collectors.toList());
        return careerLevelList;
    }

    public MHRCareerLevel(Properties ctx, String careerLevelValue, String careerLevelName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(careerLevelValue);
        this.setName(careerLevelName);
    }

    public MHRCareerLevel(Properties ctx, int careerLevelId, String trxName) {
        super(ctx, careerLevelId, trxName);
    }

    public MHRCareerLevel(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

