/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.X_HR_Concept;
import org.adempiere.core.domains.models.X_HR_Concept_Acct;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MRule;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MHRConcept
extends X_HR_Concept {
    private static final long serialVersionUID = 7859469065116713767L;
    private static CCache<Integer, MHRConcept> cache = new CCache("HR_Concept", 100);
    private static CCache<String, MHRConcept> cacheValue = new CCache("HR_Concept_Value", 100);

    public MHRConcept(Properties ctx, int HR_Concept_ID, String trxName) {
        super(ctx, HR_Concept_ID, trxName);
        if (HR_Concept_ID == 0) {
            this.setValue("");
            this.setName("");
            this.setDescription("");
            this.setIsEmployee(false);
            this.setIsPrinted(false);
            this.setHR_Payroll_ID(0);
            this.setHR_Job_ID(0);
            this.setHR_Department_ID(0);
        }
    }

    public MHRConcept(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Deprecated
    public static MHRConcept get(Properties ctx, int conceptId) {
        return MHRConcept.getById(ctx, conceptId, null);
    }

    public static MHRConcept getById(Properties ctx, int conceptId, String trxName) {
        if (conceptId <= 0) {
            return null;
        }
        MHRConcept concept = (MHRConcept)((Object)cache.get((Object)conceptId));
        if (concept != null) {
            return concept;
        }
        concept = new MHRConcept(ctx, conceptId, trxName);
        if (concept.get_ID() == conceptId) {
            cache.put((Object)conceptId, (Object)concept);
        } else {
            concept = null;
        }
        return concept;
    }

    @Deprecated
    public static MHRConcept forValue(Properties ctx, String conceptValue) {
        return MHRConcept.getByValue(ctx, conceptValue, null);
    }

    public static MHRConcept getByValue(Properties ctx, String conceptValue, String trxName) {
        if (Util.isEmpty((String)conceptValue, (boolean)true)) {
            return null;
        }
        int AD_Client_ID = Env.getAD_Client_ID((Properties)ctx);
        String key = AD_Client_ID + "#" + conceptValue;
        MHRConcept concept = (MHRConcept)((Object)cacheValue.get((Object)key));
        if (concept != null) {
            return concept;
        }
        String whereClause = "Value=? AND AD_Client_ID IN (?,?)";
        concept = (MHRConcept)new Query(ctx, "HR_Concept", "Value=? AND AD_Client_ID IN (?,?)", trxName).setParameters(new Object[]{conceptValue, 0, AD_Client_ID}).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (concept != null) {
            cacheValue.put((Object)key, (Object)concept);
            cache.put((Object)concept.get_ID(), (Object)concept);
        }
        return concept;
    }

    @Deprecated
    public static MHRConcept[] getConcepts(int payrollId, int departmentId, String sqlWhere) {
        return MHRConcept.getConcepts(payrollId, departmentId, sqlWhere, null).toArray(new MHRConcept[0]);
    }

    public static List<MHRConcept> getConcepts(int payrollId, int departmentId, String sqlWhere, String trxName) {
        Properties ctx = Env.getCtx();
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID in (?,?)");
        params.add(0);
        params.add(Env.getAD_Client_ID((Properties)Env.getCtx()));
        whereClause.append(" AND (HR_Payroll_ID =? OR HR_Payroll_ID IS NULL)");
        params.add(payrollId);
        if (departmentId != 0) {
            whereClause.append(" AND HR_Concept.HR_Department_ID=?");
            params.add(departmentId);
        }
        if (!Util.isEmpty((String)sqlWhere)) {
            whereClause.append(sqlWhere);
        }
        return new Query(ctx, "HR_Concept", whereClause.toString(), trxName).setParameters(params).setOnlyActiveRecords(true).setOrderBy("COALESCE(SeqNo,999999999999) DESC, Value").list();
    }

    public int getConceptAccountCR() {
        String sql = " HR_Expense_Acct FROM HR_Concept c  INNER JOIN HR_Concept_Acct ca ON (c.HR_Concept_ID=ca.HR_Concept_ID) WHERE c.HR_Concept_ID " + this.getHR_Concept_ID();
        int result = DB.getSQLValue((String)"ConceptCR", (String)sql);
        if (result > 0) {
            return result;
        }
        return 0;
    }

    public int getConceptAccountDR() {
        String sql = " HR_Revenue_Acct FROM HR_Concept c  INNER JOIN HR_Concept_Acct ca ON (c.HR_Concept_ID=ca.HR_Concept_ID) WHERE c.HR_Concept_ID " + this.getHR_Concept_ID();
        int result = DB.getSQLValue((String)"ConceptDR", (String)sql);
        if (result > 0) {
            return result;
        }
        return 0;
    }

    public X_HR_Concept_Acct getConceptAcct(int acctSchemaId) {
        return (X_HR_Concept_Acct)new Query(this.getCtx(), "HR_Concept_Acct", "HR_Concept_ID = ? AND C_AcctSchema_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getHR_Concept_ID(), acctSchemaId}).first();
    }

    public X_HR_Concept_Acct getConceptAcct(Optional<Integer> optionalAcctSchemaId, Optional<Integer> optionalPayrollId, Optional<Integer> optionalPartnerGroupId) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList<Integer> paramenters = new ArrayList<Integer>();
        whereClause.append("HR_Concept_ID").append("=?");
        paramenters.add(this.getHR_Concept_ID());
        optionalAcctSchemaId.ifPresent(accountSchemaId -> {
            whereClause.append(" AND ").append("C_AcctSchema_ID").append("=? ");
            paramenters.add((Integer)accountSchemaId);
        });
        optionalPayrollId.ifPresent(payrollId -> {
            whereClause.append("AND (").append("HR_Payroll_ID").append("=? OR  ").append("HR_Payroll_ID").append(" IS NULL)");
            paramenters.add((Integer)payrollId);
        });
        optionalPartnerGroupId.ifPresent(partnerGroupId -> {
            whereClause.append(" AND (").append("C_BP_Group_ID").append("=? OR  ").append("C_BP_Group_ID").append(" IS NULL)");
            paramenters.add((Integer)partnerGroupId);
        });
        return (X_HR_Concept_Acct)new Query(this.getCtx(), "HR_Concept_Acct", whereClause.toString(), this.get_TrxName()).setParameters(paramenters).setOrderBy("C_AcctSchema_ID DESC , HR_Payroll_ID DESC , C_BP_Group_ID DESC ").first();
    }

    public String toString() {
        return this.getValue() + " - " + this.getName();
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.is_Changed() && this.is_ValueChanged("Value")) {
            String oldValue = (String)this.get_ValueOld("Value");
            String newValue = this.getValue();
            String errorMessage = this.validateRules(oldValue);
            if (errorMessage.length() > 0) {
                throw new AdempiereException("@RecordFound@ @HR_Concept_ID@: " + this.getName() + " [@OldValue@: " + oldValue + " @NewValue@: " + newValue + " ]" + errorMessage);
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        String errorMessage = this.validateRules(this.getValue());
        if (errorMessage.length() > 0) {
            throw new AdempiereException("@HR_Concept_ID@ @CannotDeleteUsed@ " + errorMessage);
        }
        return true;
    }

    private String validateRules(String conceptValue) {
        AtomicReference<String> errorMessage = new AtomicReference<String>("");
        List<MRule> rules = this.getRulesDependences(conceptValue);
        rules.forEach(rule -> {
            String error = Msg.parseTranslation((Properties)this.getCtx(), (String)" @AD_Rule_ID@: ") + rule.getValue() + Msg.parseTranslation((Properties)this.getCtx(), (String)" -> ") + rule.getName() + " , ";
            errorMessage.getAndUpdate(msg -> msg + error);
        });
        return errorMessage.get();
    }

    private List<MRule> getRulesDependences(String conceptValue) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EventType").append("=? AND ").append("Script").append(" LIKE '%\"" + conceptValue + "\"%'");
        return new Query(this.getCtx(), "AD_Rule", whereClause.toString(), this.get_TrxName()).setParameters(new Object[]{"H"}).list();
    }
}

