/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_EmployeeDependent;
import org.compiere.model.Query;
import org.eevolution.hr.model.MHRCareerLevel;
import org.eevolution.hr.model.MHRDegree;
import org.eevolution.hr.model.MHRGrade;
import org.eevolution.hr.model.MHRRace;
import org.eevolution.hr.model.MHRRelationship;

public class MHREmployeeDependent
extends X_HR_EmployeeDependent {
    private static final long serialVersionUID = 113089938678164180L;
    private List<MHREmployeeDependent> dependentList;

    public MHREmployeeDependent(Properties ctx, int HR_EmployeeDependent_ID, String trxName) {
        super(ctx, HR_EmployeeDependent_ID, trxName);
    }

    public MHREmployeeDependent(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Deprecated
    public static MHREmployeeDependent[] getEmployeeDependents(Properties ctx, int bpartnerId, String relationshipValue, String gradeValue, boolean onlyDepending, boolean onlyScholarship, boolean onlyActiveStudent) {
        return MHREmployeeDependent.getEmployeeDependents(ctx, bpartnerId, relationshipValue, gradeValue, onlyDepending, onlyDepending, onlyActiveStudent, null).toArray(new MHREmployeeDependent[0]);
    }

    public static List<MHREmployeeDependent> getEmployeeDependents(Properties ctx, int bpartnerId, String relationshipValue, String gradeValue, boolean onlyDepending, boolean onlyScholarship, boolean onlyActiveStudent, String trxName) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        whereClause.append("C_BPartner_ID").append("= ?");
        params.add(bpartnerId);
        if (relationshipValue != null && relationshipValue.length() > 0) {
            whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Relationship r \t\t\t\t\t\t\t\tWHERE r.HR_Relationship_ID = HR_EmployeeDependent.HR_Relationship_ID \t\t\t\t\t\t\t\tAND r.Value = ?)");
            params.add(relationshipValue);
        }
        if (gradeValue != null && gradeValue.length() > 0) {
            whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Grade g \t\t\t\t\t\t\t\tWHERE g.HR_Grade_ID = HR_EmployeeDependent.HR_Grade_ID \t\t\t\t\t\t\t\tAND g.Value = ?)");
            params.add(gradeValue);
        }
        if (onlyDepending) {
            whereClause.append(" AND IsDepending = ?");
            params.add(true);
        }
        if (onlyScholarship) {
            whereClause.append(" AND IsScholarship = ?");
            params.add(true);
        }
        if (onlyActiveStudent) {
            whereClause.append(" AND IsActiveStudent = ?");
            params.add(true);
        }
        return new Query(ctx, "HR_EmployeeDependent", whereClause.toString(), trxName).setParameters(params).setOnlyActiveRecords(true).list();
    }

    public static MHREmployeeDependent loadDependent(Properties ctx, int bpartnerId, String trxName) {
        return new MHREmployeeDependent(ctx, 0, trxName).loadDependent(bpartnerId);
    }

    public MHREmployeeDependent loadDependent(int bpartnerId) {
        this.dependentList = new Query(this.getCtx(), "HR_EmployeeDependent", "C_BPartner_ID = ?", this.get_TrxName()).setParameters(new Object[]{bpartnerId}).setOnlyActiveRecords(true).list();
        return this;
    }

    public MHREmployeeDependent filterDepending(boolean isDepending) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.isDepending() == isDepending).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterActiveStudent(boolean isActiveStudent) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.isActiveStudent() == isActiveStudent).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterScholarship(boolean isScholarship) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.isScholarship() == isScholarship).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterDegreeValue(String degreeValue) {
        MHRDegree degree;
        if (degreeValue == null || degreeValue.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (degree = MHRDegree.getByValue(this.getCtx(), degreeValue, this.get_TrxName())) != null && degree.getHR_Degree_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.getHR_Degree_ID() == degree.getHR_Degree_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterGradeValue(String gradeValue) {
        MHRGrade grade;
        if (gradeValue == null || gradeValue.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (grade = MHRGrade.getByValue(this.getCtx(), gradeValue, this.get_TrxName())) != null && grade.getHR_Grade_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.getHR_Grade_ID() == grade.getHR_Grade_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterCareerLevelValue(String careerLevelValue) {
        MHRCareerLevel careerLevel;
        if (careerLevelValue == null || careerLevelValue.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (careerLevel = MHRCareerLevel.getByValue(this.getCtx(), careerLevelValue, this.get_TrxName())) != null && careerLevel.getHR_CareerLevel_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.getHR_CareerLevel_ID() == careerLevel.getHR_CareerLevel_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterRaceValue(String raceValue) {
        MHRRace race;
        if (raceValue == null || raceValue.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (race = MHRRace.getByValue(this.getCtx(), raceValue, this.get_TrxName())) != null && race.getHR_Race_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.getHR_Race_ID() == race.getHR_Race_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterRelationshipValue(String relationshipValue) {
        MHRRelationship race;
        if (relationshipValue == null || relationshipValue.length() == 0) {
            return this;
        }
        if (this.dependentList != null && this.dependentList.size() > 0 && (race = MHRRelationship.getByValue(this.getCtx(), relationshipValue, this.get_TrxName())) != null && race.getHR_Relationship_ID() != 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.getHR_Relationship_ID() == race.getHR_Relationship_ID()).collect(Collectors.toList());
        }
        return this;
    }

    public MHREmployeeDependent filterIsSpecialCondition(boolean isSpecialCondition) {
        if (this.dependentList != null && this.dependentList.size() > 0) {
            this.dependentList = this.dependentList.stream().filter(entry -> entry.get_ValueAsBoolean("IsSpecialCondition") == isSpecialCondition).collect(Collectors.toList());
        }
        return this;
    }

    public String toString() {
        return "MHREmployeeDependent[getName() " + this.getName() + "]";
    }
}

