/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_InsuranceType;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRInsuranceType
extends X_HR_InsuranceType {
    private static final long serialVersionUID = 5424823825162314194L;
    private static CCache<Integer, MHRInsuranceType> insuranceCacheIds = new CCache("HR_InsuranceType", 30);
    private static CCache<String, MHRInsuranceType> insuranceCacheValues = new CCache("HR_InsuranceType", 30);

    public MHRInsuranceType(Properties ctx, int HR_InsuranceType_ID, String trxName) {
        super(ctx, HR_InsuranceType_ID, trxName);
    }

    public MHRInsuranceType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MHRInsuranceType getById(Properties ctx, int insuranceTypeId, String trxName) {
        if (insuranceTypeId <= 0) {
            return null;
        }
        MHRInsuranceType insuranceType = (MHRInsuranceType)((Object)insuranceCacheIds.get((Object)insuranceTypeId));
        if (insuranceType != null && insuranceType.get_ID() > 0) {
            return insuranceType;
        }
        insuranceType = (MHRInsuranceType)new Query(ctx, "HR_InsuranceType", "HR_InsuranceType_ID=?", trxName).setClient_ID().setParameters(new Object[]{insuranceTypeId}).first();
        if (insuranceType != null && insuranceType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + insuranceType.getValue();
            insuranceCacheValues.put((Object)key, (Object)insuranceType);
            insuranceCacheIds.put((Object)insuranceType.get_ID(), (Object)insuranceType);
        }
        return insuranceType;
    }

    public static MHRInsuranceType getByValue(Properties ctx, String insuranceTypeValue, String trxName) {
        int clientId;
        String key;
        MHRInsuranceType insuranceType;
        if (insuranceTypeValue == null) {
            return null;
        }
        if (insuranceCacheValues.size() == 0) {
            MHRInsuranceType.getAll(ctx, true);
        }
        if ((insuranceType = (MHRInsuranceType)((Object)insuranceCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + insuranceTypeValue)))) != null && insuranceType.get_ID() > 0) {
            return insuranceType;
        }
        insuranceType = (MHRInsuranceType)new Query(ctx, "HR_InsuranceType", "Value=?", trxName).setClient_ID().setParameters(new Object[]{insuranceTypeValue}).first();
        if (insuranceType != null && insuranceType.get_ID() > 0) {
            insuranceCacheValues.put((Object)key, (Object)insuranceType);
            insuranceCacheIds.put((Object)insuranceType.get_ID(), (Object)insuranceType);
        }
        return insuranceType;
    }

    public static List<MHRInsuranceType> getAll(Properties ctx, boolean resetCache) {
        if (resetCache || insuranceCacheIds.size() > 0) {
            List insuranceTypeList = new Query(Env.getCtx(), "HR_InsuranceType", null, null).setClient_ID().setOrderBy("Name").list();
            insuranceTypeList.stream().forEach(insuranceType -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + insuranceType.getValue();
                insuranceCacheIds.put((Object)insuranceType.getHR_InsuranceType_ID(), (Object)insuranceType);
                insuranceCacheValues.put((Object)key, (Object)insuranceType);
            });
            return insuranceTypeList;
        }
        List<MHRInsuranceType> insuranceTypeList = insuranceCacheIds.entrySet().stream().map(insuranceType -> (MHRInsuranceType)((Object)((Object)insuranceType.getValue()))).collect(Collectors.toList());
        return insuranceTypeList;
    }

    public String toString() {
        return "MHRInsuranceType [getHR_InsuranceType_ID()=" + this.getHR_InsuranceType_ID() + ", getName()=" + this.getName() + ", getUUID()=" + this.getUUID() + ", getValue()=" + this.getValue() + "]";
    }
}

