/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_JobType;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRJobType
extends X_HR_JobType {
    private static final long serialVersionUID = -8287059323882687281L;
    private static CCache<Integer, MHRJobType> jobTypeCacheIds = new CCache("HR_JobType", 50, 0);
    private static CCache<String, MHRJobType> jobTypeCacheValues = new CCache("HR_JobType", 50, 0);

    public static MHRJobType getById(Properties ctx, int jobTypeId, String trxName) {
        MHRJobType jobType;
        if (jobTypeId <= 0) {
            return null;
        }
        if (jobTypeCacheIds.size() == 0) {
            MHRJobType.getAll(ctx, true, trxName);
        }
        if ((jobType = (MHRJobType)((Object)jobTypeCacheIds.get((Object)jobTypeId))) != null && jobType.get_ID() > 0) {
            return jobType;
        }
        jobType = (MHRJobType)new Query(ctx, "HR_JobType", "HR_JobType_ID=?", trxName).setClient_ID().setParameters(new Object[]{jobTypeId}).first();
        if (jobType != null && jobType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + jobType.getValue();
            jobTypeCacheIds.put((Object)jobType.get_ID(), (Object)jobType);
            jobTypeCacheValues.put((Object)key, (Object)jobType);
        }
        return jobType;
    }

    public static MHRJobType getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRJobType jobType;
        if (value == null) {
            return null;
        }
        if (jobTypeCacheValues.size() == 0) {
            MHRJobType.getAll(ctx, true, trxName);
        }
        if ((jobType = (MHRJobType)((Object)jobTypeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && jobType.get_ID() > 0) {
            return jobType;
        }
        jobType = (MHRJobType)new Query(ctx, "HR_JobType", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (jobType != null && jobType.get_ID() > 0) {
            jobTypeCacheValues.put((Object)key, (Object)jobType);
            jobTypeCacheIds.put((Object)jobType.get_ID(), (Object)jobType);
        }
        return jobType;
    }

    public static List<MHRJobType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || jobTypeCacheIds.size() > 0) {
            List jobTypeList = new Query(Env.getCtx(), "HR_JobType", null, trxName).setClient_ID().setOrderBy("Name").list();
            jobTypeList.stream().forEach(jobType -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + jobType.getValue();
                jobTypeCacheIds.put((Object)jobType.getHR_JobType_ID(), (Object)jobType);
                jobTypeCacheValues.put((Object)key, (Object)jobType);
            });
            return jobTypeList;
        }
        List<MHRJobType> jobTypeList = jobTypeCacheIds.entrySet().stream().map(job -> (MHRJobType)((Object)((Object)job.getValue()))).collect(Collectors.toList());
        return jobTypeList;
    }

    public MHRJobType(Properties ctx, String jobTypeValue, String JobTypeName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(jobTypeValue);
        this.setName(JobTypeName);
    }

    public MHRJobType(Properties ctx, int jobTypeId, String trxName) {
        super(ctx, jobTypeId, trxName);
    }

    public MHRJobType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

