/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_Leave;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHRLeaveAssign;
import org.eevolution.hr.model.MHRLeaveType;
import org.spin.hr.util.TNAUtil;

public class MHRLeave
extends X_HR_Leave
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20180911L;
    public static final String DocBaseType_Standard = "TNL";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MHRLeave(Properties ctx, int HR_Leave_ID, String trxName) {
        super(ctx, HR_Leave_ID, trxName);
    }

    public MHRLeave(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public void setC_DocType_ID() {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID = ? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType = ?  AND IsActive = 'Y' ORDER BY AD_Org_ID, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID(), (String)DocBaseType_Standard);
        if (C_DocType_ID <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseType=TNL");
        } else {
            this.log.fine("(APS) - TNL");
            this.setC_DocType_ID(C_DocType_ID);
        }
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord) {
            if (this.getC_DocType_ID() == 0) {
                this.setC_DocType_ID();
            }
            this.setLeaveTime();
        }
        return super.beforeSave(newRecord);
    }

    private void setLeaveTime() {
        if (this.getNoOfLeavesCredited() <= 0) {
            this.setNoOfLeavesCredited(1);
        }
        if (this.getStartDate() == null) {
            MHRLeaveType leaveType = MHRLeaveType.getById(this.getCtx(), this.getHR_LeaveType_ID(), this.get_TrxName());
            if (leaveType.getTimeFrom() != null && leaveType.getTimeTo() != null) {
                this.setStartDate(TimeUtil.getDayTime((Timestamp)this.getDateDoc(), (Timestamp)leaveType.getTimeFrom()));
                this.setEndDate(TimeUtil.getDayTime((Timestamp)this.getDateDoc(), (Timestamp)leaveType.getTimeTo()));
            } else {
                this.setStartDate(this.getDateDoc());
                BigDecimal leaveDuration = leaveType.getLeaveDurationTime();
                if (leaveDuration == null) {
                    leaveDuration = Env.ONE;
                }
                Timestamp endDate = TimeUtil.addDuration((Timestamp)this.getDateDoc(), (String)TNAUtil.getDurationUnitFromTimeUnit(leaveType.getTimeUnit()), (BigDecimal)leaveDuration);
                this.setEndDate(endDate);
            }
        }
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.validateEmployee();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void validateEmployee() {
        MBPartner businessPartner = (MBPartner)this.getC_BPartner();
        MHREmployee employee = null;
        employee = this.getHR_Employee_ID() > 0 ? MHREmployee.getById(this.getCtx(), this.getHR_Employee_ID()) : MHREmployee.getActiveEmployee(this.getCtx(), businessPartner.getC_BPartner_ID(), this.get_TrxName());
        if (employee == null) {
            throw new AdempiereException("@HR_Employee_ID@ @NotFound@: " + businessPartner.getValue() + " - " + businessPartner.getName());
        }
        this.setHR_Employee_ID(employee.getHR_Employee_ID());
        this.saveEx();
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.addUsedLeave();
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void addUsedLeave() {
        if (this.getHR_LeaveAssign_ID() > 0) {
            MHRLeaveAssign leaveAssign = new MHRLeaveAssign(this.getCtx(), this.getHR_LeaveAssign_ID(), this.get_TrxName());
            leaveAssign.addUsedLeave(1);
            leaveAssign.saveEx();
        }
    }

    private void removeUsedLeave() {
        if (this.getHR_LeaveAssign_ID() > 0) {
            MHRLeaveAssign leaveAssign = new MHRLeaveAssign(this.getCtx(), this.getHR_LeaveAssign_ID(), this.get_TrxName());
            leaveAssign.addUsedLeave(-1);
            leaveAssign.saveEx();
        }
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.removeUsedLeave();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MHRLeave[").append(this.getSummary()).append("]");
        return sb.toString();
    }
}

