/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_HR_PaySelection;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRPaySelectionLine;

public class MHRPaySelection
extends X_HR_PaySelection {
    private static final long serialVersionUID = -6521282913549455131L;
    private MHRPaySelectionLine[] m_lines = null;
    private int m_C_Currency_ID = 0;

    public MHRPaySelection(Properties ctx, int HR_PaySelection_ID, String trxName) {
        super(ctx, HR_PaySelection_ID, trxName);
        if (HR_PaySelection_ID == 0) {
            this.setTotalAmt(Env.ZERO);
            this.setIsApproved(false);
            this.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MHRPaySelection(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRPaySelectionLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MHRPaySelection.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        ArrayList<MHRPaySelectionLine> list = new ArrayList<MHRPaySelectionLine>();
        String sql = "SELECT * FROM HR_PaySelectionLine WHERE HR_PaySelection_ID=? ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getHR_PaySelection_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MHRPaySelectionLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "getLines", (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_lines = new MHRPaySelectionLine[list.size()];
        list.toArray(this.m_lines);
        return this.m_lines;
    }

    public int getC_Currency_ID() {
        if (this.m_C_Currency_ID == 0) {
            String sql = "SELECT C_Currency_ID FROM C_BankAccount WHERE C_BankAccount_ID=?";
            this.m_C_Currency_ID = DB.getSQLValue(null, (String)sql, (int)this.getC_BankAccount_ID());
        }
        return this.m_C_Currency_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MHRPaySelection[");
        sb.append(this.get_ID()).append(",").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        int context_AD_Org_ID;
        if (this.getAD_Org_ID() == 0 && (context_AD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx())) != 0) {
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        return true;
    }
}

