/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.io.File;
import java.io.FileWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_HR_PaySelectionCheck;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MCurrency;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPaySelection;
import org.eevolution.hr.model.MHRPaySelectionLine;
import org.eevolution.hr.model.MHRPayroll;

public class MHRPaySelectionCheck
extends X_HR_PaySelectionCheck {
    private static final long serialVersionUID = -280580616570711570L;
    private static CLogger s_log = CLogger.getCLogger(MHRPaySelectionCheck.class);
    private static final int BP_VALUE = 0;
    private static final int BP_NAME = 1;
    private static final int BP_CONTACT = 2;
    private static final int BP_ADDR1 = 3;
    private static final int BP_ADDR2 = 4;
    private static final int BP_CITY = 5;
    private static final int BP_REGION = 6;
    private static final int BP_POSTAL = 7;
    private static final int BP_COUNTRY = 8;
    private static final int BP_REFNO = 9;
    private MHRPaySelection m_parent = null;
    private List<MHRPaySelectionLine> m_lines = null;

    public static MHRPaySelectionCheck getOfPayment(Properties ctx, int C_Payment_ID, String trxName) {
        String where = "C_Payment_ID=?";
        List pscs = new Query(ctx, "HR_PaySelectionCheck", "C_Payment_ID=?", trxName).setParameters(new Object[]{C_Payment_ID}).list();
        MHRPaySelectionCheck retValue = null;
        int count = 0;
        for (MHRPaySelectionCheck psc : pscs) {
            if (retValue == null) {
                retValue = psc;
            } else if (!retValue.isProcessed() && psc.isProcessed()) {
                retValue = psc;
            }
            ++count;
        }
        if (count > 1) {
            s_log.warning("More then one for C_Payment_ID=" + C_Payment_ID);
        }
        return retValue;
    }

    public static List<MHRPaySelectionCheck> get(Properties ctx, int HR_PaySelection_ID, String PaymentRule, int startDocumentNo, String trxName) {
        s_log.fine("HR_PaySelection_ID=" + HR_PaySelection_ID + ", PaymentRule=" + PaymentRule + ", startDocumentNo=" + startDocumentNo);
        String where = "HR_PaySelection_ID=? AND PaymentRule=?";
        List pscs = new Query(ctx, "HR_PaySelectionCheck", "HR_PaySelection_ID=? AND PaymentRule=?", trxName).setClient_ID().setParameters(new Object[]{HR_PaySelection_ID, PaymentRule}).list();
        int docNo = startDocumentNo;
        for (MHRPaySelectionCheck psc : pscs) {
            psc.setDocumentNo(String.valueOf(docNo++));
        }
        return pscs;
    }

    public static int exportToFile(List<MHRPaySelectionCheck> checks, File file) {
        if (checks == null || checks.size() == 0) {
            return 0;
        }
        if (file.isDirectory()) {
            s_log.log(Level.WARNING, "File is directory - " + file.getAbsolutePath());
            return 0;
        }
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            s_log.log(Level.WARNING, "Could not delete - " + file.getAbsolutePath(), (Throwable)e);
        }
        char x = '\"';
        int noLines = 0;
        StringBuffer line = null;
        try {
            FileWriter fw = new FileWriter(file);
            line = new StringBuffer();
            line.append(x).append("Value").append(x).append(",").append(x).append("Name").append(x).append(",").append(x).append("Contact").append(x).append(",").append(x).append("Addr1").append(x).append(",").append(x).append("Addr2").append(x).append(",").append(x).append("City").append(x).append(",").append(x).append("State").append(x).append(",").append(x).append("ZIP").append(x).append(",").append(x).append("Country").append(x).append(",").append(x).append("ReferenceNo").append(x).append(",").append(x).append("DocumentNo").append(x).append(",").append(x).append("PayDate").append(x).append(",").append(x).append("Currency").append(x).append(",").append(x).append("PayAmount").append(x).append(",").append(x).append("Comment").append(x).append(Env.NL);
            fw.write(line.toString());
            ++noLines;
            for (MHRPaySelectionCheck mpp : checks) {
                if (mpp == null) continue;
                String[] bp = MHRPaySelectionCheck.getBPartnerInfo(mpp.getC_BPartner_ID());
                line = new StringBuffer();
                line.append(x).append(bp[0]).append(x).append(",").append(x).append(bp[1]).append(x).append(",").append(x).append(bp[2]).append(x).append(",").append(x).append(bp[3]).append(x).append(",").append(x).append(bp[4]).append(x).append(",").append(x).append(bp[5]).append(x).append(",").append(x).append(bp[6]).append(x).append(",").append(x).append(bp[7]).append(x).append(",").append(x).append(bp[8]).append(x).append(",").append(x).append(bp[9]).append(x).append(",").append(x).append(mpp.getDocumentNo()).append(x).append(",").append(mpp.getParent().getPayDate()).append(",").append(x).append(MCurrency.getISO_Code((Properties)Env.getCtx(), (int)mpp.getParent().getC_Currency_ID())).append(x).append(",").append(mpp.getPayAmt()).append(",").append(Env.NL);
                fw.write(line.toString());
                ++noLines;
            }
            fw.flush();
            fw.close();
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "", (Throwable)e);
        }
        return noLines;
    }

    private static String[] getBPartnerInfo(int C_BPartner_ID) {
        String[] bp = new String[10];
        String sql = "SELECT bp.Value, bp.Name, c.Name AS Contact, a.Address1, a.Address2, a.City, r.Name AS Region, a.Postal, cc.Name AS Country, bp.ReferenceNo FROM C_BPartner bp, AD_User c, C_BPartner_Location l, C_Location a, C_Region r, C_Country cc WHERE bp.C_BPartner_ID=? AND bp.C_BPartner_ID=c.C_BPartner_ID(+) AND bp.C_BPartner_ID=l.C_BPartner_ID AND l.C_Location_ID=a.C_Location_ID AND a.C_Region_ID=r.C_Region_ID(+) AND a.C_Country_ID=cc.C_Country_ID ORDER BY l.IsBillTo DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_BPartner_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                bp[0] = rs.getString(1);
                if (bp[0] == null) {
                    bp[0] = "";
                }
                bp[1] = rs.getString(2);
                if (bp[1] == null) {
                    bp[1] = "";
                }
                bp[2] = rs.getString(3);
                if (bp[2] == null) {
                    bp[2] = "";
                }
                bp[3] = rs.getString(4);
                if (bp[3] == null) {
                    bp[3] = "";
                }
                bp[4] = rs.getString(5);
                if (bp[4] == null) {
                    bp[4] = "";
                }
                bp[5] = rs.getString(6);
                if (bp[5] == null) {
                    bp[5] = "";
                }
                bp[6] = rs.getString(7);
                if (bp[6] == null) {
                    bp[6] = "";
                }
                bp[7] = rs.getString(8);
                if (bp[7] == null) {
                    bp[7] = "";
                }
                bp[8] = rs.getString(9);
                if (bp[8] == null) {
                    bp[8] = "";
                }
                bp[9] = rs.getString(10);
                if (bp[9] == null) {
                    bp[9] = "";
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return bp;
    }

    public static int confirmPrint(Collection<MHRPaySelectionCheck> checks, MPaymentBatch batch) {
        int lastDocumentNo = 0;
        for (MHRPaySelectionCheck check : checks) {
            StringBuilder sqlConcept = new StringBuilder();
            sqlConcept.append("SELECT HR_Concept_ID FROM HR_Movement m ").append(" WHERE EXISTS(SELECT 1 FROM HR_PaySelectionLine psl ").append(" WHERE psl.HR_Movement_ID = m.HR_Movement_ID AND m.C_BPartner_ID=?").append(" AND psl.HR_PaySelection_ID=?)");
            int conceptId = DB.getSQLValue((String)check.get_TrxName(), (String)sqlConcept.toString(), (int)check.getC_BPartner_ID(), (int)check.getHR_PaySelection_ID());
            StringBuilder sqlPayroll = new StringBuilder();
            sqlPayroll.append("SELECT HR_Payroll_ID FROM HR_PaySelection ps INNER JOIN HR_Process p ON (p.HR_Process_ID=ps.HR_Process_ID) ").append("WHERE ps.HR_PaySelection_ID=?");
            int payrollId = DB.getSQLValueEx((String)check.get_TrxName(), (String)sqlPayroll.toString(), (Object[])new Object[]{check.getHR_PaySelection_ID()});
            MHRConcept concept = new MHRConcept(check.getCtx(), conceptId, check.get_TrxName());
            MHRPayroll payroll = new MHRPayroll(check.getCtx(), payrollId, check.get_TrxName());
            MPayment payment = new MPayment(check.getCtx(), check.getC_Payment_ID(), check.get_TrxName());
            if (check.getC_Payment_ID() > 0) {
                if (check.getPaymentRule().equals("S")) {
                    payment.setCheckNo(check.getDocumentNo());
                    if (!payment.save()) {
                        s_log.log(Level.SEVERE, "Payment not saved: " + payment);
                    }
                }
            } else {
                payment = new MPayment(check.getCtx(), 0, check.get_TrxName());
                if (check.getPaymentRule().equals("S")) {
                    payment.setBankCheck(check.getParent().getC_BankAccount_ID(), false, check.getDocumentNo());
                } else if (check.getPaymentRule().equals("K")) {
                    payment.setTenderType("C");
                } else if (check.getPaymentRule().equals("T") || check.getPaymentRule().equals("D")) {
                    payment.setTenderType("D");
                } else {
                    s_log.log(Level.SEVERE, "Unsupported Payment Rule=" + check.getPaymentRule());
                    continue;
                }
                MHRPaySelection paymentSelection = new MHRPaySelection(check.getCtx(), check.getHR_PaySelection_ID(), check.get_TrxName());
                payment.setTrxType("C");
                payment.setDescription(paymentSelection.getDescription());
                payment.setIsReceipt(check.isReceipt());
                payment.setAmount(check.getParent().getC_Currency_ID(), check.getPayAmt());
                payment.setDiscountAmt(check.getDiscountAmt());
                payment.setDateTrx(check.getParent().getPayDate());
                payment.setDateAcct(payment.getDateTrx());
                payment.setC_BPartner_ID(check.getC_BPartner_ID());
                if (concept.isPrepayment()) {
                    payment.setIsPrepayment(true);
                } else {
                    int C_Charge_ID = DB.getSQLValue((String)check.get_TrxName(), (String)("SELECT MAX(C_Charge_ID) FROM HR_Attribute WHERE IsActive='Y' AND HR_Concept_ID=" + conceptId));
                    if (C_Charge_ID <= 0) {
                        payment.setC_Charge_ID(payroll.getC_Charge_ID());
                    } else {
                        payment.setC_Charge_ID(C_Charge_ID);
                    }
                }
                payment.setC_BankAccount_ID(check.getParent().getC_BankAccount_ID());
                payment.setWriteOffAmt(Env.ZERO);
                payment.saveEx();
                int C_Payment_ID = payment.get_ID();
                if (C_Payment_ID < 1) {
                    s_log.log(Level.SEVERE, "Payment not created=" + check);
                } else {
                    check.setC_Payment_ID(C_Payment_ID);
                    check.save();
                    payment.processIt("CO");
                    if (!payment.save()) {
                        s_log.log(Level.SEVERE, "Payment not saved: " + payment);
                    }
                    payment.setAD_Org_ID(check.getAD_Org_ID());
                    payment.setAD_OrgTrx_ID(check.getAD_Org_ID());
                    payment.saveEx();
                }
            }
            try {
                int no = Integer.parseInt(check.getDocumentNo());
                if (lastDocumentNo < no) {
                    lastDocumentNo = no;
                }
            }
            catch (NumberFormatException ex) {
                s_log.log(Level.SEVERE, "DocumentNo=" + check.getDocumentNo(), (Throwable)ex);
            }
            check.setIsPrinted(true);
            check.setProcessed(true);
            check.saveEx();
        }
        s_log.fine("Last Document No = " + lastDocumentNo);
        return lastDocumentNo;
    }

    public MHRPaySelectionCheck(Properties ctx, int HR_PaySelectionCheck_ID, String trxName) {
        super(ctx, HR_PaySelectionCheck_ID, trxName);
        if (HR_PaySelectionCheck_ID == 0) {
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsPrinted(false);
            this.setIsReceipt(false);
            this.setQty(0);
        }
    }

    public MHRPaySelectionCheck(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRPaySelectionCheck(MHRPaySelectionLine line, String PaymentRule) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg((PO)line);
        this.setHR_PaySelection_ID(line.getHR_PaySelection_ID());
        MHRMovement movement = new MHRMovement(this.getCtx(), line.getHR_Movement_ID(), this.get_TrxName());
        this.setAD_Org_ID(movement.getAD_Org_ID());
        int partnerId = movement.getC_BPartner_ID();
        this.setC_BPartner_ID(partnerId);
        if ("D".equals(PaymentRule)) {
            List parterBankAccts = MBPBankAccount.getByPartner((Properties)line.getCtx(), (int)partnerId);
            parterBankAccts.stream().filter(partnerBankAccount -> partnerBankAccount != null && partnerBankAccount.isDirectDebit()).findFirst().ifPresent(partnerBankAccount -> this.setC_BP_BankAccount_ID(partnerBankAccount.getC_BP_BankAccount_ID()));
        } else if ("T".equals(PaymentRule)) {
            List parterBankAccts = MBPBankAccount.getByPartner((Properties)line.getCtx(), (int)partnerId);
            parterBankAccts.stream().filter(partnerBankAccount -> partnerBankAccount != null && partnerBankAccount.isDirectDeposit()).findFirst().ifPresent(partnerBankAccount -> this.setC_BP_BankAccount_ID(partnerBankAccount.getC_BP_BankAccount_ID()));
        }
        this.setPaymentRule(PaymentRule);
        this.setIsReceipt(line.isSOTrx());
        this.setPayAmt(line.getPayAmt());
        this.setDiscountAmt(line.getDiscountAmt());
        this.setQty(1);
    }

    public MHRPaySelectionCheck(MHRPaySelection ps, String PaymentRule) {
        this(ps.getCtx(), 0, ps.get_TrxName());
        this.setClientOrg((PO)ps);
        this.setHR_PaySelection_ID(ps.getHR_PaySelection_ID());
        this.setPaymentRule(PaymentRule);
    }

    public void addLine(MHRPaySelectionLine line) {
        MHRMovement movement = new MHRMovement(this.getCtx(), line.getHR_Movement_ID(), line.get_TrxName());
        if (this.getC_BPartner_ID() != movement.getC_BPartner_ID()) {
            throw new IllegalArgumentException("Line for fifferent BPartner");
        }
        if (this.isReceipt() == line.isSOTrx()) {
            this.setPayAmt(this.getPayAmt().add(line.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().add(line.getDiscountAmt()));
        } else {
            this.setPayAmt(this.getPayAmt().subtract(line.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().subtract(line.getDiscountAmt()));
        }
        this.setQty(this.getQty() + 1);
    }

    public MHRPaySelection getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MHRPaySelection(this.getCtx(), this.getHR_PaySelection_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isValid() {
        if (this.getC_BP_BankAccount_ID() != 0) {
            return true;
        }
        return !this.isDirect();
    }

    public boolean isDirect() {
        return "T".equals(this.getPaymentRule()) || "D".equals(this.getPaymentRule());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MHRPaymentCheck[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("-").append(this.getPayAmt()).append(",PaymetRule=").append(this.getPaymentRule()).append(",Qty=").append(this.getQty()).append("]");
        return sb.toString();
    }

    public List<MHRPaySelectionLine> getPaySelectionLines(boolean requery) {
        List list;
        if (this.m_lines != null && !requery) {
            return this.m_lines;
        }
        String where = "HR_PaySelectionCheck_ID=?";
        this.m_lines = list = new Query(this.getCtx(), "HR_PaySelectionLine", "HR_PaySelectionCheck_ID=?", this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getHR_PaySelectionCheck_ID()}).setOrderBy("Line").list();
        return this.m_lines;
    }

    public static boolean deleteGeneratedDraft(Properties ctx, int C_Payment_ID, String trxName) {
        MHRPaySelectionCheck mpsc = MHRPaySelectionCheck.getOfPayment(ctx, C_Payment_ID, trxName);
        if (mpsc != null && mpsc.isGeneratedDraft()) {
            MHRPaySelection mps = new MHRPaySelection(ctx, mpsc.getHR_PaySelection_ID(), trxName);
            MHRPaySelectionLine[] mpsl = mps.getLines(true);
            for (int i = 0; i < mpsl.length; ++i) {
                if (mpsl[i].delete(true, trxName)) continue;
                return false;
            }
            if (!mpsc.delete(true, trxName)) {
                return false;
            }
            if (!mps.delete(true, trxName)) {
                return false;
            }
        }
        return true;
    }
}

