/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_PayrollConcept;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRProcess;

public class MHRPayrollConcept
extends X_HR_PayrollConcept {
    private static final long serialVersionUID = 7657163678402925513L;

    public MHRPayrollConcept(Properties ctx, int HR_Concept_ID, String trxName) {
        super(ctx, HR_Concept_ID, trxName);
    }

    public MHRPayrollConcept(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRPayrollConcept(MHRConcept concept, int payroll_id, String trxName) {
        super(concept.getCtx(), 0, trxName);
        this.setHR_Payroll_ID(payroll_id);
        this.setHR_Concept_ID(concept.get_ID());
        this.setName(concept.getName());
        this.setSeqNo(concept.getSeqNo());
        this.setIsPrinted(concept.isPrinted());
        if (concept.isManual() || "I".equals(concept.getType())) {
            this.setIsDisplayed(false);
        } else {
            this.setIsDisplayed(true);
        }
        this.setIsActive(true);
    }

    public static MHRPayrollConcept[] getPayrollConcepts(MHRProcess process) {
        List list = new Query(process.getCtx(), "HR_PayrollConcept", "HR_Payroll_ID=?", process.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{process.getHR_Payroll_ID()}).setOrderBy("SeqNo").list();
        return list.toArray(new MHRPayrollConcept[list.size()]);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getSeqNo() == 0) {
            String sql = "SELECT COALESCE(MAX(SeqNo),0) FROM HR_PayrollConcept WHERE HR_Payroll_ID=?";
            int lastSeqNo = DB.getSQLValueEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{this.getHR_Payroll_ID()});
            if (lastSeqNo < 0) {
                lastSeqNo = 0;
            }
            this.setSeqNo(lastSeqNo + 10);
        }
        return true;
    }
}

