/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_SalaryStructure;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRSalaryStructure
extends X_HR_SalaryStructure {
    private static final long serialVersionUID = -8908364340305802L;
    private static CCache<Integer, MHRSalaryStructure> salaryStructureCacheIds = new CCache("HR_SalaryStructure", 50, 0);
    private static CCache<String, MHRSalaryStructure> salaryStructureCacheValues = new CCache("HR_SalaryStructure", 50, 0);

    public static MHRSalaryStructure getById(Properties ctx, int salaryStructureId, String trxName) {
        MHRSalaryStructure salaryStructure;
        if (salaryStructureId <= 0) {
            return null;
        }
        if (salaryStructureCacheIds.size() == 0) {
            MHRSalaryStructure.getAll(ctx, true);
        }
        if ((salaryStructure = (MHRSalaryStructure)((Object)salaryStructureCacheIds.get((Object)salaryStructureId))) != null && salaryStructure.get_ID() > 0) {
            return salaryStructure;
        }
        salaryStructure = (MHRSalaryStructure)new Query(ctx, "HR_SalaryStructure", "HR_SalaryStructure_ID=?", trxName).setClient_ID().setParameters(new Object[]{salaryStructureId}).first();
        if (salaryStructure != null && salaryStructure.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + salaryStructure.getValue();
            salaryStructureCacheIds.put((Object)salaryStructureId, (Object)salaryStructure);
            salaryStructureCacheValues.put((Object)key, (Object)salaryStructure);
        }
        return salaryStructure;
    }

    public static MHRSalaryStructure getByValue(Properties ctx, String value) {
        if (value == null) {
            return null;
        }
        if (salaryStructureCacheValues.size() == 0) {
            MHRSalaryStructure.getAll(ctx, true);
        }
        int clientId = Env.getAD_Client_ID((Properties)ctx);
        String key = clientId + "#" + value;
        MHRSalaryStructure salaryStructure = (MHRSalaryStructure)new Query(ctx, "HR_SalaryStructure", "Value=?", null).setClient_ID().setParameters(new Object[]{key}).first();
        if (salaryStructure != null && salaryStructure.getHR_SalaryStructure_ID() > 0) {
            salaryStructureCacheValues.put((Object)key, (Object)salaryStructure);
            salaryStructureCacheIds.put((Object)salaryStructure.get_ID(), (Object)salaryStructure);
        }
        return salaryStructure;
    }

    public static List<MHRSalaryStructure> getAll(Properties ctx, boolean resetCache) {
        if (resetCache || salaryStructureCacheIds.size() > 0) {
            List salaryStructureList = new Query(Env.getCtx(), "HR_SalaryStructure", null, null).setClient_ID().setOrderBy("Name").list();
            salaryStructureList.stream().forEach(salaryStructure -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + salaryStructure.getValue();
                salaryStructureCacheIds.put((Object)salaryStructure.getHR_SalaryStructure_ID(), (Object)salaryStructure);
                salaryStructureCacheValues.put((Object)salaryStructure.getValue(), (Object)salaryStructure);
            });
            return salaryStructureList;
        }
        List<MHRSalaryStructure> salaryStructureList = salaryStructureCacheIds.entrySet().stream().map(salaryStructure -> (MHRSalaryStructure)((Object)((Object)salaryStructure.getValue()))).collect(Collectors.toList());
        return salaryStructureList;
    }

    public MHRSalaryStructure(Properties ctx, int salaryStructureId, String trxName) {
        super(ctx, salaryStructureId, trxName);
    }

    public MHRSalaryStructure(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

