/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_SkillType;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRSkillType
extends X_HR_SkillType {
    private static final long serialVersionUID = 6516605057703266045L;
    private static CCache<Integer, MHRSkillType> skillTypeCacheIds = new CCache("HR_SkillType", 50, 0);
    private static CCache<String, MHRSkillType> skillTypeCacheValues = new CCache("HR_SkillType", 50, 0);

    public static MHRSkillType getById(Properties ctx, int skillTypeId, String trxName) {
        MHRSkillType skillType;
        if (skillTypeId <= 0) {
            return null;
        }
        if (skillTypeCacheIds.size() == 0) {
            MHRSkillType.getAll(ctx, true, trxName);
        }
        if ((skillType = (MHRSkillType)((Object)skillTypeCacheIds.get((Object)skillTypeId))) != null && skillType.get_ID() > 0) {
            return skillType;
        }
        skillType = (MHRSkillType)new Query(ctx, "HR_SkillType", "HR_SkillType_ID=?", trxName).setClient_ID().setParameters(new Object[]{skillTypeId}).first();
        if (skillType != null && skillType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + skillType.getValue();
            skillTypeCacheIds.put((Object)skillType.get_ID(), (Object)skillType);
            skillTypeCacheValues.put((Object)key, (Object)skillType);
        }
        return skillType;
    }

    public static MHRSkillType getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRSkillType skillType;
        if (value == null) {
            return null;
        }
        if (skillTypeCacheValues.size() == 0) {
            MHRSkillType.getAll(ctx, true, trxName);
        }
        if ((skillType = (MHRSkillType)((Object)skillTypeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && skillType.get_ID() > 0) {
            return skillType;
        }
        skillType = (MHRSkillType)new Query(ctx, "HR_SkillType", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (skillType != null && skillType.get_ID() > 0) {
            skillTypeCacheValues.put((Object)key, (Object)skillType);
            skillTypeCacheIds.put((Object)skillType.get_ID(), (Object)skillType);
        }
        return skillType;
    }

    public static List<MHRSkillType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || skillTypeCacheIds.size() > 0) {
            List skillTypeList = new Query(Env.getCtx(), "HR_SkillType", null, trxName).setClient_ID().setOrderBy("Name").list();
            skillTypeList.stream().forEach(skillType -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + skillType.getValue();
                skillTypeCacheIds.put((Object)skillType.getHR_SkillType_ID(), (Object)skillType);
                skillTypeCacheValues.put((Object)key, (Object)skillType);
            });
            return skillTypeList;
        }
        List<MHRSkillType> skillTypeList = skillTypeCacheIds.entrySet().stream().map(SkillType -> (MHRSkillType)((Object)((Object)SkillType.getValue()))).collect(Collectors.toList());
        return skillTypeList;
    }

    public MHRSkillType(Properties ctx, String skillTypeValue, String skillTypeName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(skillTypeValue);
        this.setName(skillTypeName);
    }

    public MHRSkillType(Properties ctx, int skillTypeId, String trxName) {
        super(ctx, skillTypeId, trxName);
    }

    public MHRSkillType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

