/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_WorkGroup;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRWorkGroup
extends X_HR_WorkGroup {
    private static final long serialVersionUID = -3426527194456182750L;
    private static CCache<Integer, MHRWorkGroup> workGroupCacheIds = new CCache("HR_WorkGroup", 30);
    private static CCache<String, MHRWorkGroup> workGroupCacheValues = new CCache("HR_WorkGroup", 30);

    public MHRWorkGroup(Properties ctx, int HR_WorkGroup_ID, String trxName) {
        super(ctx, HR_WorkGroup_ID, trxName);
    }

    public MHRWorkGroup(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MHRWorkGroup getById(Properties ctx, int workGroupId, String trxName) {
        if (workGroupId <= 0) {
            return null;
        }
        MHRWorkGroup workGroup = (MHRWorkGroup)((Object)workGroupCacheIds.get((Object)workGroupId));
        if (workGroup != null && workGroup.get_ID() > 0) {
            return workGroup;
        }
        workGroup = (MHRWorkGroup)new Query(ctx, "HR_WorkGroup", "HR_WorkGroup_ID=?", trxName).setClient_ID().setParameters(new Object[]{workGroupId}).first();
        if (workGroup != null && workGroup.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + workGroup.getValue();
            workGroupCacheValues.put((Object)key, (Object)workGroup);
            workGroupCacheIds.put((Object)workGroup.get_ID(), (Object)workGroup);
        }
        return workGroup;
    }

    public static MHRWorkGroup getByValue(Properties ctx, String workGroupValue, String trxName) {
        int clientId;
        String key;
        MHRWorkGroup workGroup;
        if (workGroupValue == null) {
            return null;
        }
        if (workGroupCacheValues.size() == 0) {
            MHRWorkGroup.getAll(ctx, true);
        }
        if ((workGroup = (MHRWorkGroup)((Object)workGroupCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + workGroupValue)))) != null && workGroup.get_ID() > 0) {
            return workGroup;
        }
        workGroup = (MHRWorkGroup)new Query(ctx, "HR_WorkGroup", "Value=?", trxName).setClient_ID().setParameters(new Object[]{workGroupValue}).first();
        if (workGroup != null && workGroup.get_ID() > 0) {
            workGroupCacheValues.put((Object)key, (Object)workGroup);
            workGroupCacheIds.put((Object)workGroup.get_ID(), (Object)workGroup);
        }
        return workGroup;
    }

    public static List<MHRWorkGroup> getAll(Properties ctx, boolean resetCache) {
        if (resetCache || workGroupCacheIds.size() > 0) {
            List workGroupList = new Query(Env.getCtx(), "HR_WorkGroup", null, null).setClient_ID().setOrderBy("Name").list();
            workGroupList.stream().forEach(workGroup -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + workGroup.getValue();
                workGroupCacheIds.put((Object)workGroup.getHR_WorkGroup_ID(), (Object)workGroup);
                workGroupCacheValues.put((Object)key, (Object)workGroup);
            });
            return workGroupList;
        }
        List<MHRWorkGroup> workGroupList = workGroupCacheIds.entrySet().stream().map(workGroup -> (MHRWorkGroup)((Object)((Object)workGroup.getValue()))).collect(Collectors.toList());
        return workGroupList;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isShiftAllocation() && this.getHR_ShiftGroup_ID() == 0 && this.getHR_WorkShift_ID() == 0) {
            throw new AdempiereException("@HR_ShiftGroup_ID@ / @HR_WorkShift_ID@ @IsMandatory@");
        }
        return true;
    }

    public String toString() {
        return "MHRWorkGroup [getHR_WorkGroup_ID()=" + this.getHR_WorkGroup_ID() + ", getName()=" + this.getName() + ", getValue()=" + this.getValue() + "]";
    }
}

