/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_WorkShift;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MHRWorkShift
extends X_HR_WorkShift {
    private static final long serialVersionUID = 955746318164528261L;
    private static CCache<Integer, MHRWorkShift> workShiftCache = new CCache("HR_WorkShift", 1000);
    private static CCache<String, MHRWorkShift> workShiftValueCache = new CCache("HR_WorkShift", 1000);

    public MHRWorkShift(Properties ctx, int HR_WorkShift_ID, String trxName) {
        super(ctx, HR_WorkShift_ID, trxName);
    }

    public MHRWorkShift(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MHRWorkShift getById(Properties ctx, int workShiftId, String trxName) {
        if (workShiftId <= 0) {
            return null;
        }
        MHRWorkShift workShift = (MHRWorkShift)((Object)workShiftCache.get((Object)workShiftId));
        if (workShift != null) {
            return workShift;
        }
        workShift = new MHRWorkShift(ctx, workShiftId, trxName);
        if (workShift.get_ID() == workShiftId) {
            workShiftCache.put((Object)workShiftId, (Object)workShift);
        } else {
            workShift = null;
        }
        return workShift;
    }

    public static MHRWorkShift getById(Properties ctx, int workShiftId) {
        return MHRWorkShift.getById(ctx, workShiftId, null);
    }

    public static MHRWorkShift getByValue(Properties ctx, String workShiftValue, String trxName) {
        if (Util.isEmpty((String)workShiftValue, (boolean)true)) {
            return null;
        }
        int clientId = Env.getAD_Client_ID((Properties)ctx);
        String key = clientId + "#" + workShiftValue;
        MHRWorkShift workShift = (MHRWorkShift)((Object)workShiftValueCache.get((Object)key));
        if (workShift != null) {
            return workShift;
        }
        String whereClause = "Value=? AND AD_Client_ID IN (?,?)";
        workShift = (MHRWorkShift)new Query(ctx, "HR_WorkShift", "Value=? AND AD_Client_ID IN (?,?)", trxName).setParameters(new Object[]{workShiftValue, 0, clientId}).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC").first();
        if (workShift != null) {
            workShiftValueCache.put((Object)key, (Object)workShift);
            workShiftCache.put((Object)workShift.get_ID(), (Object)workShift);
        }
        return workShift;
    }

    public static List<MHRWorkShift> getFromGroup(Properties ctx, int shiftGroupId, String trxName) {
        if (shiftGroupId <= 0) {
            return null;
        }
        String whereClause = "HR_ShiftGroup_ID=?";
        return new Query(ctx, "HR_WorkShift", "HR_ShiftGroup_ID=?", trxName).setParameters(new Object[]{shiftGroupId}).setOnlyActiveRecords(true).setOrderBy("SeqNo").list();
    }

    public static MHRWorkShift getDefaultFromGroup(Properties ctx, int shiftGroupId, String trxName) {
        if (shiftGroupId <= 0) {
            return null;
        }
        List<MHRWorkShift> listOfGroup = MHRWorkShift.getFromGroup(ctx, shiftGroupId, trxName);
        if (listOfGroup != null && listOfGroup.size() > 0) {
            return (MHRWorkShift)((Object)listOfGroup.stream().findFirst().get());
        }
        return null;
    }

    public static MHRWorkShift getByValue(Properties ctx, String workShiftValue) {
        return MHRWorkShift.getByValue(ctx, workShiftValue, null);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isOnSunday() && this.isOnMonday() && this.isOnTuesday() && this.isOnWednesday() && this.isOnThursday() && this.isOnFriday() && this.isOnSaturday()) {
            throw new AdempiereException("@TNA.AtLeastBusinessDay@");
        }
        Timestamp fromTime = this.getShiftFromTime();
        Timestamp toTime = this.getShiftToTime();
        Timestamp breakStartTime = this.getBreakStartTime();
        Timestamp breakEndTime = this.getBreakEndTime();
        BigDecimal breakHourNo = this.getBreakHoursNo();
        if (fromTime != null && toTime != null && fromTime.after(toTime)) {
            toTime = TimeUtil.getDayTime((Timestamp)TimeUtil.addDays((Timestamp)toTime, (int)1), (Timestamp)toTime);
        }
        if (breakStartTime != null && breakEndTime != null) {
            if (fromTime.after(breakStartTime)) {
                breakStartTime = TimeUtil.getDayTime((Timestamp)TimeUtil.addDays((Timestamp)breakStartTime, (int)1), (Timestamp)breakStartTime);
            }
            if (breakStartTime.after(breakEndTime)) {
                breakEndTime = TimeUtil.getDayTime((Timestamp)TimeUtil.addDays((Timestamp)breakEndTime, (int)1), (Timestamp)breakEndTime);
            }
            long breakDifference = breakEndTime.getTime() - breakStartTime.getTime();
            breakHourNo = new BigDecimal((double)breakDifference / 3600000.0);
        }
        if (breakHourNo == null) {
            breakHourNo = Env.ZERO;
        }
        if (!TimeUtil.isValid((Timestamp)fromTime, (Timestamp)toTime, (Timestamp)breakStartTime)) {
            throw new AdempiereException("@TNA.InvalidBreakStartTime@");
        }
        if (!TimeUtil.isValid((Timestamp)fromTime, (Timestamp)toTime, (Timestamp)breakEndTime)) {
            throw new AdempiereException("@TNA.InvalidBreakEndTime@");
        }
        if (breakStartTime != null && breakEndTime != null && breakEndTime.getTime() < breakStartTime.getTime()) {
            throw new AdempiereException("@TNA.InvalidBreakTime@");
        }
        if (this.getMinAttendanceRequire() > 0 && this.getMinAttendanceRequire() % 2 != 0) {
            throw new AdempiereException("@TNA.AttendanceNotPair@");
        }
        long workDifference = toTime.getTime() - fromTime.getTime();
        BigDecimal workHourNo = new BigDecimal((double)workDifference / 3600000.0);
        this.setBreakHoursNo(breakHourNo);
        this.setNoOfHours(workHourNo.subtract(breakHourNo));
        this.setShiftFromTime(fromTime);
        this.setShiftToTime(toTime);
        this.setBreakStartTime(breakStartTime);
        this.setBreakEndTime(breakEndTime);
        return true;
    }

    public String toString() {
        return "MHRWorkShift [getBreakEndTime()=" + this.getBreakEndTime() + ", getBreakHoursNo()=" + this.getBreakHoursNo() + ", getBreakStartTime()=" + this.getBreakStartTime() + ", isOverTimeApplicable()=" + this.isOverTimeApplicable() + ", getName()=" + this.getName() + ", getNoOfHours()=" + this.getNoOfHours() + ", isOnFriday()=" + this.isOnFriday() + ", isOnMonday()=" + this.isOnMonday() + ", isOnSaturday()=" + this.isOnSaturday() + ", isOnSunday()=" + this.isOnSunday() + ", isOnThursday()=" + this.isOnThursday() + ", isOnTuesday()=" + this.isOnTuesday() + ", isOnWednesday()=" + this.isOnWednesday() + ", getShiftFromTime()=" + this.getShiftFromTime() + ", getShiftToTime()=" + this.getShiftToTime() + "]";
    }
}

