/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.Query;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRPayrollConcept;
import org.eevolution.hr.process.HRCreateConceptAbstract;

public class HRCreateConcept
extends HRCreateConceptAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        int count = 0;
        List concepts = this.getInstancesForSelection(this.get_TrxName());
        if (this.getRecord_ID() > 0 && this.getSelectionKeys().size() > 0 && this.getTableSelectionId() == MHRConcept.Table_ID) {
            count = this.createPayrollConcept(concepts, this.getRecord_ID());
        } else if (this.getRecord_ID() == 0 && this.getSelectionKeys().size() > 0) {
            count = this.updatingConceptProperties(concepts, this.getRecord_ID());
        }
        return "@Created@/@Updated@ #" + count;
    }

    private int createPayrollConcept(List<MHRConcept> concepts, int payrollId) {
        AtomicInteger count = new AtomicInteger(0);
        concepts.stream().filter(concept -> !this.existsPayrollConcept(concept.getHR_Concept_ID(), payrollId)).forEach(concept -> {
            MHRPayrollConcept payrollConcept = new MHRPayrollConcept((MHRConcept)((Object)concept), payrollId, this.get_TrxName());
            payrollConcept.setIsPrinted(concept.isPrinted());
            payrollConcept.setSeqNo(concept.getSeqNo());
            payrollConcept.setName(concept.getName());
            payrollConcept.saveEx();
            this.addLog("@SeqNo@" + payrollConcept.getSeqNo() + " @HR_PayrollConcept_ID@ : " + payrollConcept.getName());
            count.updateAndGet(no -> no + 1);
        });
        return count.get();
    }

    private int updatingConceptProperties(List<MHRConcept> concepts, int payrollId) {
        AtomicInteger count = new AtomicInteger(0);
        concepts.stream().filter(concept -> concept != null).forEach(concept -> {
            Optional.ofNullable(this.getSelectionAsString(concept.get_ID(), this.getPrefixAliasForTableSelection() + "Name")).ifPresent(name -> concept.setName((String)name));
            Optional.ofNullable(this.getSelectionAsString(concept.get_ID(), this.getPrefixAliasForTableSelection() + "Description")).ifPresent(description -> concept.setDescription((String)description));
            Optional.ofNullable(this.getSelectionAsInt(concept.get_ID(), this.getPrefixAliasForTableSelection() + "HR_Concept_Category_ID")).ifPresent(categoryId -> concept.setHR_Concept_Category_ID((int)categoryId));
            Optional.ofNullable(this.getSelectionAsInt(concept.get_ID(), this.getPrefixAliasForTableSelection() + "HR_Concept_Type_ID")).ifPresent(typeId -> concept.setHR_Concept_Type_ID((int)typeId));
            Optional.ofNullable(this.getSelectionAsInt(concept.get_ID(), this.getPrefixAliasForTableSelection() + "SeqNo")).ifPresent(seqNo -> concept.setSeqNo((int)seqNo));
            Optional.ofNullable(this.getSelectionAsString(concept.get_ID(), this.getPrefixAliasForTableSelection() + "Type")).ifPresent(type -> concept.setType((String)type));
            Optional.ofNullable(this.getSelectionAsString(concept.get_ID(), this.getPrefixAliasForTableSelection() + "ColumnType")).ifPresent(columnType -> concept.setColumnType((String)columnType));
            Optional.ofNullable(this.getSelectionAsString(concept.get_ID(), this.getPrefixAliasForTableSelection() + "AccountSign")).ifPresent(accountSign -> concept.setAccountSign((String)accountSign));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsActive")).ifPresent(isActive -> concept.setIsActive((boolean)isActive));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsEmployee")).ifPresent(isEmployee -> concept.setIsEmployee((boolean)isEmployee));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsManual")).ifPresent(isManual -> concept.setIsManual((boolean)isManual));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsPaid")).ifPresent(isPaid -> concept.setIsPaid((boolean)isPaid));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsPrepayment")).ifPresent(isPrepayment -> concept.setIsPrepayment((boolean)isPrepayment));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsInvoiced")).ifPresent(isInvoiced -> concept.setIsInvoiced((boolean)isInvoiced));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsSaveInHistoric")).ifPresent(isSaveInHistoric -> concept.setIsSaveInHistoric((boolean)isSaveInHistoric));
            Optional.ofNullable(this.getSelectionAsBoolean(concept.get_ID(), this.getPrefixAliasForTableSelection() + "IsPrinted")).ifPresent(isPrint -> concept.setIsPrinted((boolean)isPrint));
            if (concept.is_Changed()) {
                count.updateAndGet(no -> no + 1);
                concept.saveEx();
                this.addLog("@Updated@ @HR_Concept_ID@ : " + concept.getName());
            }
        });
        return count.get();
    }

    private boolean existsPayrollConcept(int conceptId, int payrollId) {
        String whereClause = "HR_Payroll_ID=? AND HR_Concept_ID=?";
        return new Query(this.getCtx(), "HR_PayrollConcept", "HR_Payroll_ID=? AND HR_Concept_ID=?", this.get_TrxName()).setParameters(new Object[]{payrollId, conceptId}).match();
    }
}

