/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_I_HR_Employee;
import org.compiere.model.MActivity;
import org.compiere.model.MBPartner;
import org.compiere.model.MCampaign;
import org.compiere.model.MImage;
import org.compiere.model.MOrg;
import org.compiere.model.MProject;
import org.compiere.model.MSalesRegion;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRCareerLevel;
import org.eevolution.hr.model.MHRDegree;
import org.eevolution.hr.model.MHRDepartment;
import org.eevolution.hr.model.MHRDesignation;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHREmployeeType;
import org.eevolution.hr.model.MHRGrade;
import org.eevolution.hr.model.MHRJob;
import org.eevolution.hr.model.MHRJobEducation;
import org.eevolution.hr.model.MHRJobType;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRRace;
import org.eevolution.hr.model.MHRSalaryRange;
import org.eevolution.hr.model.MHRSalaryStructure;
import org.eevolution.hr.model.MHRShiftGroup;
import org.eevolution.hr.model.MHRSkillType;
import org.eevolution.hr.model.MHRWorkGroup;
import org.eevolution.hr.process.ImportEmployeeAbstract;

public class ImportEmployee
extends ImportEmployeeAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getImportEmployeeIds(true, true)).forEach(importEmployeeId -> {
                X_I_HR_Employee importEmployee = new X_I_HR_Employee(this.getCtx(), importEmployeeId, null);
                importEmployee.deleteEx(true);
            });
        }
        AtomicInteger importedRecord = new AtomicInteger(0);
        AtomicInteger withErrors = new AtomicInteger(0);
        Arrays.stream(this.getImportEmployeeIds(false, false)).forEach(importEmployeeId -> Trx.run(trxName -> {
            X_I_HR_Employee importEmployee = new X_I_HR_Employee(this.getCtx(), importEmployeeId, trxName);
            importEmployee.setI_ErrorMsg(null);
            this.fillIdValues(importEmployee, trxName);
            if (this.importRecord(importEmployee, trxName)) {
                importedRecord.updateAndGet(record -> record + 1);
            } else {
                withErrors.updateAndGet(error -> error + 1);
            }
        }));
        return "@HR_Employee_ID@ @Import@ @Records@ " + importedRecord.get() + " @Errors@ " + withErrors.get();
    }

    private void fillIdValues(X_I_HR_Employee importEmployee, String trxName) {
        Integer partnerId;
        StringBuffer stringError = new StringBuffer("");
        Integer orgId = 0;
        if (importEmployee.getAD_Org_ID() > 0) {
            orgId = importEmployee.getAD_Org_ID();
        }
        if (orgId <= 0) {
            orgId = this.getId("AD_Org", "Value=?", trxName, importEmployee.getOrgValue());
        }
        if (orgId > 0) {
            importEmployee.setAD_Org_ID(orgId.intValue());
        }
        if ((partnerId = Integer.valueOf(this.getId("C_BPartner", "Value=?", trxName, importEmployee.getBPartnerValue()))) > 0) {
            importEmployee.setC_BPartner_ID(partnerId.intValue());
        } else if (this.isCreated()) {
            if (this.getBPGroupId() > 0) {
                MBPartner partner = this.createPartnerFromEmployeeData(importEmployee);
                partnerId = partner.get_ID();
                importEmployee.setC_BPartner_ID(partnerId.intValue());
            } else {
                stringError.append(" @C_BP_Group_ID@ @NotFound@");
            }
        }
        MHRRace race = null;
        if (importEmployee.getHR_Race_ID() > 0) {
            race = MHRRace.getById(this.getCtx(), importEmployee.getHR_Race_ID(), trxName);
        }
        if (race != null && race.getHR_Race_ID() < 0 && importEmployee.getRaceValue() != null) {
            race = MHRRace.getByValue(this.getCtx(), importEmployee.getRaceValue(), trxName);
        }
        if ((race == null || race.getHR_Race_ID() < 0) && importEmployee.getRaceValue() != null && importEmployee.getRaceName() != null) {
            race = new MHRRace(this.getCtx(), importEmployee.getRaceValue(), importEmployee.getRaceName(), trxName);
            race.saveEx();
        }
        if (race != null && race.getHR_Race_ID() > 0) {
            importEmployee.setHR_Race_ID(race.getHR_Race_ID());
        }
        MOrg orgTrx = null;
        if (importEmployee.getAD_OrgTrx_ID() > 0) {
            orgTrx = MOrg.get((Properties)this.getCtx(), (int)importEmployee.getAD_OrgTrx_ID());
        }
        if (orgTrx == null && importEmployee.getOrgTrxValue() != null) {
            int orgTrxId = this.getId("AD_Org", "Value=?", trxName, importEmployee.getOrgTrxValue());
            orgTrx = MOrg.get((Properties)this.getCtx(), (int)orgTrxId);
        }
        if (orgTrx != null && orgTrx.getAD_Org_ID() > 0) {
            importEmployee.setAD_OrgTrx_ID(orgTrx.getAD_Org_ID());
        }
        MProject project = null;
        if (importEmployee.getC_Project_ID() > 0) {
            project = MProject.getById((Properties)this.getCtx(), (Integer)importEmployee.getC_Project_ID(), (String)trxName);
        }
        if (project == null && importEmployee.getProjectValue() != null) {
            project = MProject.getByValue((Properties)this.getCtx(), (String)importEmployee.getProjectValue(), (String)trxName);
        }
        if (project != null && project.getC_Project_ID() > 0) {
            importEmployee.setC_Project_ID(project.getC_Project_ID());
        }
        MHRDepartment department = null;
        if (importEmployee.getHR_Department_ID() > 0) {
            department = MHRDepartment.getById(this.getCtx(), importEmployee.getHR_Department_ID(), trxName);
        }
        if (department == null && importEmployee.getDepartmentValue() != null) {
            department = MHRDepartment.getByValue(this.getCtx(), importEmployee.getDepartmentValue(), trxName);
        }
        if ((department == null || department.getHR_Department_ID() < 0) && importEmployee.getDepartmentValue() != null && importEmployee.getDepartmentName() != null) {
            department = new MHRDepartment(this.getCtx(), importEmployee.getDepartmentValue(), importEmployee.getDepartmentName(), trxName);
            department.saveEx();
        }
        if (department != null && department.getHR_Department_ID() > 0) {
            importEmployee.setHR_Department_ID(department.getHR_Department_ID());
        }
        MHRJob job = null;
        if (importEmployee.getHR_Job_ID() > 0) {
            job = MHRJob.getById(this.getCtx(), importEmployee.getHR_Job_ID(), trxName);
        }
        if (job == null && importEmployee.getJobValue() != null) {
            job = MHRJob.getByValue(this.getCtx(), importEmployee.getJobValue(), trxName);
        }
        if ((job == null || job.getHR_Job_ID() < 0) && importEmployee.getJobValue() != null && importEmployee.getJobName() != null) {
            job = new MHRJob(this.getCtx(), importEmployee.getJobValue(), importEmployee.getJobName(), trxName);
            job.saveEx();
        }
        if (job != null && job.getHR_Job_ID() > 0) {
            importEmployee.setHR_Job_ID(job.getHR_Job_ID());
        }
        MHRJobEducation jobEducation = null;
        if (importEmployee.getHR_JobEducation_ID() > 0) {
            jobEducation = MHRJobEducation.getById(this.getCtx(), importEmployee.getHR_JobEducation_ID(), trxName);
        }
        if (jobEducation == null && importEmployee.getJobEducationValue() != null) {
            jobEducation = MHRJobEducation.getByValue(this.getCtx(), importEmployee.getJobEducationValue(), trxName);
        }
        if ((jobEducation == null || jobEducation.getHR_JobEducation_ID() < 0) && importEmployee.getJobEducationValue() != null && importEmployee.getJobEducationName() != null) {
            jobEducation = new MHRJobEducation(this.getCtx(), importEmployee.getJobEducationValue(), importEmployee.getJobEducationName(), trxName);
            jobEducation.saveEx();
        }
        if (jobEducation != null && jobEducation.getHR_JobEducation_ID() > 0) {
            importEmployee.setHR_JobEducation_ID(jobEducation.getHR_JobEducation_ID());
        }
        MHRCareerLevel careerLevel = null;
        if (importEmployee.getHR_CareerLevel_ID() > 0) {
            careerLevel = MHRCareerLevel.getById(this.getCtx(), importEmployee.getHR_CareerLevel_ID(), trxName);
        }
        if (careerLevel == null && importEmployee.getCareerLevelValue() != null) {
            careerLevel = MHRCareerLevel.getByValue(this.getCtx(), importEmployee.getCareerLevelValue(), trxName);
        }
        if ((careerLevel == null || careerLevel.getHR_CareerLevel_ID() < 0) && importEmployee.getCareerLevelValue() != null && importEmployee.getCareerLevelName() != null) {
            careerLevel = new MHRCareerLevel(this.getCtx(), importEmployee.getCareerLevelValue(), importEmployee.getCareerLevelName(), trxName);
            careerLevel.saveEx();
        }
        if (careerLevel != null && careerLevel.getHR_CareerLevel_ID() > 0) {
            importEmployee.setHR_CareerLevel_ID(careerLevel.getHR_CareerLevel_ID());
        }
        MHRJobType jobType = null;
        if (importEmployee.getHR_JobType_ID() > 0) {
            jobType = MHRJobType.getById(this.getCtx(), importEmployee.getHR_JobType_ID(), trxName);
        }
        if (jobType == null && importEmployee.getJobTypeValue() != null) {
            jobType = MHRJobType.getByValue(this.getCtx(), importEmployee.getJobTypeValue(), trxName);
        }
        if ((jobType == null || jobType.getHR_JobType_ID() < 0) && importEmployee.getJobTypeValue() != null && importEmployee.getJobTypeName() != null) {
            jobType = new MHRJobType(this.getCtx(), importEmployee.getJobTypeValue(), importEmployee.getJobTypeName(), trxName);
            jobType.saveEx();
        }
        if (jobType != null && jobType.getHR_JobType_ID() > 0) {
            importEmployee.setHR_JobType_ID(jobType.getHR_JobType_ID());
        }
        MHRPayroll payroll = null;
        if (importEmployee.getHR_Payroll_ID() > 0) {
            payroll = MHRPayroll.getById(this.getCtx(), importEmployee.getHR_Job_ID(), trxName);
        }
        if (payroll == null && importEmployee.getPayrollValue() != null) {
            payroll = MHRPayroll.getByValue(this.getCtx(), importEmployee.getPayrollValue(), trxName);
        }
        if (payroll != null && payroll.getHR_Payroll_ID() > 0) {
            importEmployee.setHR_Payroll_ID(payroll.getHR_Payroll_ID());
        }
        MActivity activity = null;
        if (importEmployee.getC_Activity_ID() > 0) {
            activity = MActivity.getById((Properties)this.getCtx(), (int)importEmployee.getC_Activity_ID(), (String)trxName);
        }
        if (activity == null && importEmployee.getActivityValue() != null) {
            activity = MActivity.getByValue((Properties)this.getCtx(), (String)importEmployee.getActivityValue(), (String)trxName);
        }
        if (activity != null && activity.getC_Activity_ID() > 0) {
            importEmployee.setC_Activity_ID(activity.getC_Activity_ID());
        }
        MCampaign campaign = null;
        if (importEmployee.getC_Campaign_ID() > 0) {
            campaign = MCampaign.getById((Properties)this.getCtx(), (int)importEmployee.getC_Campaign_ID(), (String)trxName);
        }
        if (campaign == null && importEmployee.getCampaignValue() != null) {
            campaign = MCampaign.getByValue((Properties)this.getCtx(), (String)importEmployee.getCampaignValue(), (String)trxName);
        }
        if (campaign != null && campaign.getC_Campaign_ID() > 0) {
            importEmployee.setC_Campaign_ID(campaign.getC_Campaign_ID());
        }
        MSalesRegion salesRegion = null;
        if (importEmployee.getC_SalesRegion_ID() > 0) {
            salesRegion = MSalesRegion.getById((Properties)this.getCtx(), (int)importEmployee.getC_SalesRegion_ID(), (String)trxName);
        }
        if (salesRegion == null && importEmployee.getSalesRegionValue() != null) {
            salesRegion = MSalesRegion.getByValue((Properties)this.getCtx(), (String)importEmployee.getSalesRegionValue(), (String)trxName);
        }
        if (salesRegion != null && salesRegion.getC_SalesRegion_ID() > 0) {
            importEmployee.setC_SalesRegion_ID(salesRegion.getC_SalesRegion_ID());
        }
        MHRWorkGroup workGroup = null;
        if (importEmployee.getHR_WorkGroup_ID() > 0) {
            workGroup = MHRWorkGroup.getById(this.getCtx(), importEmployee.getHR_WorkGroup_ID(), trxName);
        }
        if (workGroup == null && importEmployee.getWorkGroupValue() != null) {
            workGroup = MHRWorkGroup.getByValue(this.getCtx(), importEmployee.getWorkGroupValue(), trxName);
        }
        if (workGroup != null && workGroup.getHR_WorkGroup_ID() > 0) {
            importEmployee.setHR_WorkGroup_ID(workGroup.getHR_WorkGroup_ID());
        }
        MHRShiftGroup shiftGroup = null;
        if (importEmployee.getHR_ShiftGroup_ID() > 0) {
            shiftGroup = MHRShiftGroup.getById(this.getCtx(), importEmployee.getHR_WorkGroup_ID(), trxName);
        }
        if (shiftGroup == null && importEmployee.getShiftGroupValue() != null) {
            shiftGroup = MHRShiftGroup.getByValue(this.getCtx(), importEmployee.getWorkGroupValue(), trxName);
        }
        if (shiftGroup != null && shiftGroup.getHR_ShiftGroup_ID() > 0) {
            importEmployee.setHR_ShiftGroup_ID(shiftGroup.getHR_ShiftGroup_ID());
        }
        MHRDegree degree = null;
        if (importEmployee.getHR_Degree_ID() > 0) {
            degree = MHRDegree.getById(this.getCtx(), importEmployee.getHR_Degree_ID(), trxName);
        }
        if (degree == null && importEmployee.getDegreeValue() != null) {
            degree = MHRDegree.getByValue(this.getCtx(), importEmployee.getDegreeValue(), trxName);
        }
        if ((degree == null || degree.getHR_Degree_ID() < 0) && importEmployee.getDegreeValue() != null && importEmployee.getDegreeName() != null) {
            degree = new MHRDegree(this.getCtx(), importEmployee.getDegreeValue(), importEmployee.getDegreeName(), trxName);
            degree.saveEx();
        }
        if (degree != null && degree.getHR_Degree_ID() > 0) {
            importEmployee.setHR_Degree_ID(degree.getHR_Degree_ID());
        }
        MHRGrade grade = null;
        if (importEmployee.getHR_Grade_ID() > 0) {
            grade = MHRGrade.getById(this.getCtx(), importEmployee.getHR_Grade_ID(), trxName);
        }
        if (grade == null && importEmployee.getGradeValue() != null) {
            grade = MHRGrade.getByValue(this.getCtx(), importEmployee.getGradeValue(), trxName);
        }
        if ((grade == null || grade.getHR_Grade_ID() < 0) && importEmployee.getGradeValue() != null && importEmployee.getGradeName() != null) {
            grade = new MHRGrade(this.getCtx(), importEmployee.getGradeValue(), importEmployee.getGradeName(), trxName);
            grade.saveEx();
        }
        if (grade != null && grade.getHR_Grade_ID() > 0) {
            importEmployee.setHR_Grade_ID(grade.getHR_Grade_ID());
        }
        MHRDesignation designation = null;
        if (importEmployee.getHR_Designation_ID() > 0) {
            designation = MHRDesignation.getById(this.getCtx(), importEmployee.getHR_Designation_ID(), trxName);
        }
        if (designation == null && importEmployee.getDesignationValue() != null) {
            designation = MHRDesignation.getByValue(this.getCtx(), importEmployee.getDesignationValue(), trxName);
        }
        if (designation != null && designation.getHR_Designation_ID() > 0) {
            importEmployee.setHR_Designation_ID(designation.getHR_Designation_ID());
        }
        MHRSalaryStructure salaryStructure = null;
        if (importEmployee.getHR_SalaryRange_ID() > 0) {
            salaryStructure = MHRSalaryStructure.getById(this.getCtx(), importEmployee.getHR_SalaryStructure_ID(), trxName);
        }
        if (salaryStructure == null && importEmployee.getSalaryStructureValue() != null) {
            salaryStructure = MHRSalaryStructure.getByValue(this.getCtx(), importEmployee.getSalaryStructureValue());
        }
        if (salaryStructure != null && salaryStructure.getHR_SalaryStructure_ID() > 0) {
            importEmployee.setHR_SalaryRange_ID(salaryStructure.getHR_SalaryStructure_ID());
        }
        MHRSalaryRange salaryRange = null;
        if (importEmployee.getHR_SalaryRange_ID() > 0) {
            salaryRange = MHRSalaryRange.getById(this.getCtx(), importEmployee.getHR_SalaryRange_ID(), trxName);
        }
        if (salaryRange == null && importEmployee.getSalaryRangeValue() != null) {
            salaryRange = MHRSalaryRange.getByValue(this.getCtx(), importEmployee.getSalaryRangeValue(), trxName);
        }
        if (salaryRange != null && salaryRange.getHR_SalaryRange_ID() > 0) {
            importEmployee.setHR_SalaryRange_ID(salaryRange.getHR_SalaryRange_ID());
        }
        MHREmployeeType employeeType = null;
        if (importEmployee.getHR_EmployeeType_ID() > 0) {
            employeeType = MHREmployeeType.getById(this.getCtx(), importEmployee.getHR_EmployeeType_ID(), trxName);
        }
        if (employeeType == null && importEmployee.getEmployeeTypeValue() != null) {
            employeeType = MHREmployeeType.getByValue(this.getCtx(), importEmployee.getEmployeeTypeValue(), trxName);
        }
        if ((employeeType == null || employeeType.getHR_EmployeeType_ID() < 0) && importEmployee.getEmployeeTypeValue() != null && importEmployee.getEmployeeTypeName() != null && payroll != null && payroll.getHR_Payroll_ID() > 0) {
            employeeType = new MHREmployeeType(this.getCtx(), importEmployee.getEmployeeTypeValue(), importEmployee.getEmployeeTypeName(), "DA", payroll.getHR_Payroll_ID(), trxName);
            employeeType.saveEx();
        }
        if (employeeType != null && employeeType.getHR_EmployeeType_ID() > 0) {
            importEmployee.setHR_EmployeeType_ID(employeeType.getHR_EmployeeType_ID());
        }
        MHRSkillType skillType = null;
        if (importEmployee.getHR_SkillType_ID() > 0) {
            skillType = MHRSkillType.getById(this.getCtx(), importEmployee.getHR_SkillType_ID(), trxName);
        }
        if (skillType == null && importEmployee.getSkillTypeValue() != null) {
            skillType = MHRSkillType.getByValue(this.getCtx(), importEmployee.getSkillTypeValue(), trxName);
        }
        if ((skillType == null || skillType.getHR_SkillType_ID() < 0) && importEmployee.getSkillTypeValue() != null && importEmployee.getSkillTypeName() != null) {
            skillType = new MHRSkillType(this.getCtx(), importEmployee.getSkillTypeValue(), importEmployee.getSkillTypeName(), trxName);
            skillType.saveEx();
        }
        if (skillType != null && skillType.getHR_SkillType_ID() > 0) {
            importEmployee.setHR_SkillType_ID(skillType.getHR_SkillType_ID());
        }
        if (importEmployee.getAD_Org_ID() <= 0) {
            stringError.append(" @AD_Org_ID@ @IsMandatory@");
        }
        if (importEmployee.getC_BPartner_ID() <= 0) {
            stringError.append(" @C_BPartner_ID@ @IsMandatory@,");
        }
        if (importEmployee.getHR_Department_ID() <= 0) {
            stringError.append(" @HR_Department_ID@ @NotFound@,");
        }
        if (importEmployee.getHR_Job_ID() <= 0) {
            stringError.append(" @HR_Job_ID@ @NotFound@,");
        }
        if (importEmployee.getStartDate() == null) {
            stringError.append(" @StartDate@ @IsMandatory@ ");
        }
        if (!stringError.toString().isEmpty() && stringError.toString().length() > 0) {
            importEmployee.setI_ErrorMsg(Msg.parseTranslation((Properties)this.getCtx(), (String)stringError.toString()));
            importEmployee.saveEx();
        }
        importEmployee.saveEx();
    }

    private boolean importRecord(X_I_HR_Employee importEmployee, String trxName) {
        if (importEmployee.getI_ErrorMsg() != null) {
            return false;
        }
        if (!this.isValidateOnly()) {
            MHREmployee employee = MHREmployee.getByPartnerIdAndStartDate(importEmployee.getCtx(), importEmployee.getC_BPartner_ID(), importEmployee.getStartDate(), trxName);
            if (employee != null && employee.getHR_Employee_ID() <= 0) {
                this.importEmployeeImages(importEmployee);
                employee.updateEmployeeData(importEmployee).saveEx();
            } else {
                this.importEmployeeImages(importEmployee);
                employee = new MHREmployee(importEmployee);
                employee.saveEx();
                this.updatePartnerFromEmployeeData(importEmployee);
            }
            importEmployee.setHR_Employee_ID(employee.getHR_Employee_ID());
            importEmployee.setI_IsImported(true);
            importEmployee.setProcessed(true);
            importEmployee.saveEx();
            return true;
        }
        return false;
    }

    private MBPartner createPartnerFromEmployeeData(X_I_HR_Employee importEmployee) {
        MBPartner partner = new MBPartner(importEmployee.getCtx(), 0, importEmployee.get_TrxName());
        partner.setAD_Org_ID(0);
        partner.setValue(importEmployee.getBPartnerValue());
        partner.setName(importEmployee.getName());
        partner.setName2(importEmployee.getName2());
        partner.setIsEmployee(true);
        partner.setIsCustomer(true);
        partner.setIsSalesRep(false);
        partner.setC_BP_Group_ID(this.getBPGroupId());
        partner.setBirthday(importEmployee.getBirthday());
        partner.setBloodGroup(importEmployee.getBloodGroup());
        partner.setGender(importEmployee.getGender());
        partner.setFathersName(importEmployee.getFathersName());
        partner.saveEx();
        importEmployee.setC_BPartner_ID(importEmployee.getC_BPartner_ID());
        importEmployee.saveEx();
        return partner;
    }

    private MBPartner updatePartnerFromEmployeeData(X_I_HR_Employee importEmployee) {
        MBPartner partner = (MBPartner)importEmployee.getC_BPartner();
        if (!Util.isEmpty((String)importEmployee.getName())) {
            partner.setName(importEmployee.getName());
        }
        if (!Util.isEmpty((String)importEmployee.getName2())) {
            partner.setName2(importEmployee.getName2());
        }
        if (importEmployee.getBirthday() != null) {
            partner.setBirthday(importEmployee.getBirthday());
        }
        if (!Util.isEmpty((String)importEmployee.getBloodGroup())) {
            partner.setBloodGroup(importEmployee.getBloodGroup());
        }
        if (!Util.isEmpty((String)importEmployee.getGender())) {
            partner.setGender(importEmployee.getGender());
        }
        if (!Util.isEmpty((String)importEmployee.getFathersName())) {
            partner.setFathersName(importEmployee.getFathersName());
        }
        partner.saveEx();
        return partner;
    }

    private int getId(String tableName, String whereClause, String trxName, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, trxName).setParameters(parameters).firstId();
    }

    private int[] getImportEmployeeIds(boolean isImported, boolean isProcessed) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_HR_Employee", whereClause.toString(), null).setOnlyActiveRecords(true).setParameters(new Object[]{isImported, isProcessed}).getIDs();
    }

    private void importEmployeeImages(X_I_HR_Employee importEmployee) {
        byte[] thumbEmployee;
        byte[] logoEmployee;
        String fileName = importEmployee.getFile_Directory();
        String imageEmployeeName = importEmployee.getBPartnerValue();
        String logoEmployeeName = "Logo" + importEmployee.getBPartnerValue();
        String thumbEmployeeName = "Thumb" + importEmployee.getBPartnerValue();
        String path = fileName + "/" + imageEmployeeName;
        byte[] imageEmployee = this.getImage(path + ".jpg");
        if (imageEmployee == null) {
            imageEmployee = this.getImage(path + ".JPG");
        }
        if (imageEmployee == null) {
            imageEmployee = this.getImage(path + ".png");
        }
        if (imageEmployee == null) {
            imageEmployee = this.getImage(path + ".PNG");
        }
        if (imageEmployee != null && imageEmployee.length > 0) {
            MImage image = MImage.get((Properties)Env.getCtx(), (int)0);
            image.setName(imageEmployeeName);
            image.setImageURL(imageEmployeeName);
            image.setBinaryData(imageEmployee);
            image.saveEx();
            importEmployee.setEmployeeImage_ID(image.getAD_Image_ID());
            importEmployee.saveEx();
        }
        if ((logoEmployee = this.getImage((path = fileName + "/" + logoEmployeeName) + ".jpg")) == null) {
            logoEmployee = this.getImage(path + ".JPG");
        }
        if (logoEmployee == null) {
            logoEmployee = this.getImage(path + ".png");
        }
        if (logoEmployee == null) {
            logoEmployee = this.getImage(path + ".PNG");
        }
        if (logoEmployee != null && logoEmployee.length > 0) {
            MImage image = MImage.get((Properties)Env.getCtx(), (int)0);
            image.setName(logoEmployeeName);
            image.setImageURL(logoEmployeeName);
            image.setBinaryData(logoEmployee);
            image.saveEx();
            importEmployee.setLogo_ID(image.getAD_Image_ID());
            importEmployee.saveEx();
        }
        if ((thumbEmployee = this.getImage((path = fileName + "/" + thumbEmployeeName) + ".jpg")) == null) {
            thumbEmployee = this.getImage(path + ".JPG");
        }
        if (thumbEmployee == null) {
            thumbEmployee = this.getImage(path + ".png");
        }
        if (thumbEmployee == null) {
            thumbEmployee = this.getImage(path + ".PNG");
        }
        if (thumbEmployee != null && thumbEmployee.length > 0) {
            MImage image = MImage.get((Properties)Env.getCtx(), (int)0);
            image.setName(thumbEmployeeName);
            image.setImageURL(thumbEmployeeName);
            image.setBinaryData(thumbEmployee);
            image.saveEx();
            importEmployee.setThumbImage_ID(image.getAD_Image_ID());
            importEmployee.saveEx();
        }
    }

    private byte[] getImage(String pathFile) {
        byte[] imageBytes = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(pathFile);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int length = -1;
            while ((length = fileInputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            fileInputStream.close();
            imageBytes = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return imageBytes;
        }
        catch (Exception e) {
            return null;
        }
    }
}

