/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.core.domains.models.X_I_HR_Attribute;
import org.compiere.model.MActivity;
import org.compiere.model.MCampaign;
import org.compiere.model.MOrg;
import org.compiere.model.MProject;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.hr.model.MHRAttribute;
import org.eevolution.hr.model.MHRCareerLevel;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRDegree;
import org.eevolution.hr.model.MHRDepartment;
import org.eevolution.hr.model.MHRDesignation;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHREmployeeType;
import org.eevolution.hr.model.MHRGrade;
import org.eevolution.hr.model.MHRJob;
import org.eevolution.hr.model.MHRJobEducation;
import org.eevolution.hr.model.MHRJobType;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRRace;
import org.eevolution.hr.model.MHRSalaryRange;
import org.eevolution.hr.model.MHRSalaryStructure;
import org.eevolution.hr.model.MHRShiftGroup;
import org.eevolution.hr.model.MHRSkillType;
import org.eevolution.hr.model.MHRWorkGroup;
import org.eevolution.hr.process.ImportEmployeeAttributesAbstract;

public class ImportEmployeeAttributes
extends ImportEmployeeAttributesAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.isDeleteOldImported()) {
            Arrays.stream(this.getAttributeIds(true, true, null)).forEach(recordId -> {
                X_I_HR_Attribute importAttribute = new X_I_HR_Attribute(this.getCtx(), recordId, null);
                importAttribute.deleteEx(true);
            });
        }
        AtomicInteger importedRecord = new AtomicInteger(0);
        AtomicInteger withErrors = new AtomicInteger(0);
        Arrays.stream(this.getAttributeIds(false, false, null)).forEach(recordId -> Trx.run(trxName -> {
            X_I_HR_Attribute importEmployeeAttribute = new X_I_HR_Attribute(this.getCtx(), recordId, trxName);
            this.fillIdValues(importEmployeeAttribute);
            if (this.importRecord(importEmployeeAttribute)) {
                importedRecord.updateAndGet(record -> record + 1);
            } else {
                withErrors.updateAndGet(error -> error + 1);
            }
        }));
        return "@HR_Attribute_ID@ @Import@ @Records@ " + importedRecord.get() + " @Errors@ " + withErrors.get();
    }

    private void fillIdValues(X_I_HR_Attribute importEmployeeAttribute) {
        MHRConcept concept;
        StringBuilder messageError = new StringBuilder();
        importEmployeeAttribute.setI_ErrorMsg("");
        String conceptQuery = "SELECT HR_Concept_ID FROM HR_Concept WHERE TRIM(Value) = TRIM(?)";
        int conceptId = DB.getSQLValue((String)importEmployeeAttribute.get_TrxName(), (String)"SELECT HR_Concept_ID FROM HR_Concept WHERE TRIM(Value) = TRIM(?)", (String)importEmployeeAttribute.getConceptValue());
        if (conceptId < 0) {
            messageError.append(", ").append("@HR_Concept_ID@ @NotFound@");
        }
        String partnerQuery = "SELECT C_BPartner_ID FROM C_BPartner WHERE TRIM(Value) = TRIM(?)";
        int partnerId = DB.getSQLValue(null, (String)"SELECT C_BPartner_ID FROM C_BPartner WHERE TRIM(Value) = TRIM(?)", (String)importEmployeeAttribute.getValue());
        if (conceptId > 0 && (concept = MHRConcept.getById(this.getCtx(), conceptId, importEmployeeAttribute.get_TrxName())).isEmployee() && partnerId < 0) {
            messageError.append("@HR_Employee_ID@ @NotFound@");
        }
        if (importEmployeeAttribute.getValidFrom() == null) {
            messageError.append(", ").append("@Invalid@ @ValidFrom@");
        }
        if (messageError.length() > 0) {
            this.setImportError(importEmployeeAttribute, messageError.toString()).saveEx(importEmployeeAttribute.get_TrxName());
        }
        importEmployeeAttribute.setC_BPartner_ID(partnerId);
        importEmployeeAttribute.setHR_Concept_ID(conceptId);
        MHRRace race = null;
        if (importEmployeeAttribute.getHR_Race_ID() > 0) {
            race = MHRRace.getById(this.getCtx(), importEmployeeAttribute.getHR_Race_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (race != null && race.getHR_Race_ID() < 0 && importEmployeeAttribute.getRaceValue() != null) {
            race = MHRRace.getByValue(this.getCtx(), importEmployeeAttribute.getRaceValue(), importEmployeeAttribute.get_TrxName());
        }
        if (race != null && race.getHR_Race_ID() > 0) {
            importEmployeeAttribute.setHR_Race_ID(race.getHR_Race_ID());
        }
        MOrg orgTrx = null;
        if (importEmployeeAttribute.getAD_OrgTrx_ID() > 0) {
            orgTrx = MOrg.get((Properties)this.getCtx(), (int)importEmployeeAttribute.getAD_OrgTrx_ID());
        }
        if (orgTrx == null && importEmployeeAttribute.getOrgTrxValue() != null) {
            int orgTrxId = this.getId("AD_Org", "Value=?", this.get_TrxName(), importEmployeeAttribute.getOrgTrxValue());
            orgTrx = MOrg.get((Properties)this.getCtx(), (int)orgTrxId);
        }
        if (orgTrx != null && orgTrx.getAD_Org_ID() > 0) {
            importEmployeeAttribute.setAD_OrgTrx_ID(orgTrx.getAD_Org_ID());
        }
        MProject project = null;
        if (importEmployeeAttribute.getC_Project_ID() > 0) {
            project = MProject.getById((Properties)this.getCtx(), (Integer)importEmployeeAttribute.getC_Project_ID(), (String)importEmployeeAttribute.get_TrxName());
        }
        if (project == null && importEmployeeAttribute.getProjectValue() != null) {
            project = MProject.getByValue((Properties)this.getCtx(), (String)importEmployeeAttribute.getProjectValue(), (String)importEmployeeAttribute.get_TrxName());
        }
        if (project != null && project.getC_Project_ID() > 0) {
            importEmployeeAttribute.setC_Project_ID(project.getC_Project_ID());
        }
        MHRDepartment department = null;
        if (importEmployeeAttribute.getHR_Department_ID() > 0) {
            department = MHRDepartment.getById(this.getCtx(), importEmployeeAttribute.getHR_Department_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (department == null && importEmployeeAttribute.getDepartmentValue() != null) {
            department = MHRDepartment.getByValue(this.getCtx(), importEmployeeAttribute.getDepartmentValue(), importEmployeeAttribute.get_TrxName());
        }
        if (department != null && department.getHR_Department_ID() > 0) {
            importEmployeeAttribute.setHR_Department_ID(department.getHR_Department_ID());
        }
        MHRJob job = null;
        if (importEmployeeAttribute.getHR_Job_ID() > 0) {
            job = MHRJob.getById(this.getCtx(), importEmployeeAttribute.getHR_Job_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (job == null && importEmployeeAttribute.getJobValue() != null) {
            job = MHRJob.getByValue(this.getCtx(), importEmployeeAttribute.getJobValue(), importEmployeeAttribute.get_TrxName());
        }
        if (job != null && job.getHR_Job_ID() > 0) {
            importEmployeeAttribute.setHR_Job_ID(job.getHR_Job_ID());
        }
        MHRJobEducation jobEducation = null;
        if (importEmployeeAttribute.getHR_JobEducation_ID() > 0) {
            jobEducation = MHRJobEducation.getById(this.getCtx(), importEmployeeAttribute.getHR_JobEducation_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (jobEducation == null && importEmployeeAttribute.getJobEducationValue() != null) {
            jobEducation = MHRJobEducation.getByValue(this.getCtx(), importEmployeeAttribute.getJobEducationValue(), importEmployeeAttribute.get_TrxName());
        }
        if (jobEducation != null && jobEducation.getHR_JobEducation_ID() > 0) {
            importEmployeeAttribute.setHR_JobEducation_ID(jobEducation.getHR_JobEducation_ID());
        }
        MHRCareerLevel careerLevel = null;
        if (importEmployeeAttribute.getHR_CareerLevel_ID() > 0) {
            careerLevel = MHRCareerLevel.getById(this.getCtx(), importEmployeeAttribute.getHR_CareerLevel_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (careerLevel == null && importEmployeeAttribute.getCareerLevelValue() != null) {
            careerLevel = MHRCareerLevel.getByValue(this.getCtx(), importEmployeeAttribute.getCareerLevelValue(), importEmployeeAttribute.get_TrxName());
        }
        if (careerLevel != null && careerLevel.getHR_CareerLevel_ID() > 0) {
            importEmployeeAttribute.setHR_CareerLevel_ID(careerLevel.getHR_CareerLevel_ID());
        }
        MHRJobType jobType = null;
        if (importEmployeeAttribute.getHR_JobType_ID() > 0) {
            jobType = MHRJobType.getById(this.getCtx(), importEmployeeAttribute.getHR_JobType_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (jobType == null && importEmployeeAttribute.getJobTypeValue() != null) {
            jobType = MHRJobType.getByValue(this.getCtx(), importEmployeeAttribute.getJobTypeValue(), importEmployeeAttribute.get_TrxName());
        }
        if (jobType != null && jobType.getHR_JobType_ID() > 0) {
            importEmployeeAttribute.setHR_JobType_ID(jobType.getHR_JobType_ID());
        }
        MHRPayroll payroll = null;
        if (importEmployeeAttribute.getHR_Payroll_ID() > 0) {
            payroll = MHRPayroll.getById(this.getCtx(), importEmployeeAttribute.getHR_Job_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (payroll == null && importEmployeeAttribute.getPayrollValue() != null) {
            payroll = MHRPayroll.getByValue(this.getCtx(), importEmployeeAttribute.getPayrollValue(), importEmployeeAttribute.get_TrxName());
        }
        if (payroll != null && payroll.getHR_Payroll_ID() > 0) {
            importEmployeeAttribute.setHR_Payroll_ID(payroll.getHR_Payroll_ID());
        }
        MActivity activity = null;
        if (importEmployeeAttribute.getC_Activity_ID() > 0) {
            activity = MActivity.getById((Properties)this.getCtx(), (int)importEmployeeAttribute.getC_Activity_ID(), (String)importEmployeeAttribute.get_TrxName());
        }
        if (activity == null && importEmployeeAttribute.getActivityValue() != null) {
            activity = MActivity.getByValue((Properties)this.getCtx(), (String)importEmployeeAttribute.getActivityValue(), (String)importEmployeeAttribute.get_TrxName());
        }
        if (activity != null && activity.getC_Activity_ID() > 0) {
            importEmployeeAttribute.setC_Activity_ID(activity.getC_Activity_ID());
        }
        MCampaign campaign = null;
        if (importEmployeeAttribute.getC_Campaign_ID() > 0) {
            campaign = MCampaign.getById((Properties)this.getCtx(), (int)importEmployeeAttribute.getC_Campaign_ID(), (String)importEmployeeAttribute.get_TrxName());
        }
        if (campaign == null && importEmployeeAttribute.getCampaignValue() != null) {
            campaign = MCampaign.getByValue((Properties)this.getCtx(), (String)importEmployeeAttribute.getCampaignValue(), (String)importEmployeeAttribute.get_TrxName());
        }
        if (campaign != null && campaign.getC_Campaign_ID() > 0) {
            importEmployeeAttribute.setC_Campaign_ID(campaign.getC_Campaign_ID());
        }
        MHRWorkGroup workGroup = null;
        if (importEmployeeAttribute.getHR_WorkGroup_ID() > 0) {
            workGroup = MHRWorkGroup.getById(this.getCtx(), importEmployeeAttribute.getHR_WorkGroup_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (workGroup == null && importEmployeeAttribute.getWorkGroupValue() != null) {
            workGroup = MHRWorkGroup.getByValue(this.getCtx(), importEmployeeAttribute.getWorkGroupValue(), importEmployeeAttribute.get_TrxName());
        }
        if (workGroup != null && workGroup.getHR_WorkGroup_ID() > 0) {
            importEmployeeAttribute.setHR_WorkGroup_ID(workGroup.getHR_WorkGroup_ID());
        }
        MHRShiftGroup shiftGroup = null;
        if (importEmployeeAttribute.getHR_ShiftGroup_ID() > 0) {
            shiftGroup = MHRShiftGroup.getById(this.getCtx(), importEmployeeAttribute.getHR_WorkGroup_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (shiftGroup == null && importEmployeeAttribute.getShiftGroupValue() != null) {
            shiftGroup = MHRShiftGroup.getByValue(this.getCtx(), importEmployeeAttribute.getWorkGroupValue(), importEmployeeAttribute.get_TrxName());
        }
        if (shiftGroup != null && shiftGroup.getHR_ShiftGroup_ID() > 0) {
            importEmployeeAttribute.setHR_ShiftGroup_ID(shiftGroup.getHR_ShiftGroup_ID());
        }
        MHRDegree degree = null;
        if (importEmployeeAttribute.getHR_Degree_ID() > 0) {
            degree = MHRDegree.getById(this.getCtx(), importEmployeeAttribute.getHR_Degree_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (degree == null && importEmployeeAttribute.getDegreeValue() != null) {
            degree = MHRDegree.getByValue(this.getCtx(), importEmployeeAttribute.getDegreeValue(), importEmployeeAttribute.get_TrxName());
        }
        if (degree != null && degree.getHR_Degree_ID() > 0) {
            importEmployeeAttribute.setHR_Degree_ID(degree.getHR_Degree_ID());
        }
        MHRGrade grade = null;
        if (importEmployeeAttribute.getHR_Grade_ID() > 0) {
            grade = MHRGrade.getById(this.getCtx(), importEmployeeAttribute.getHR_Grade_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (grade == null && importEmployeeAttribute.getGradeValue() != null) {
            grade = MHRGrade.getByValue(this.getCtx(), importEmployeeAttribute.getGradeValue(), importEmployeeAttribute.get_TrxName());
        }
        if (grade != null && grade.getHR_Grade_ID() > 0) {
            importEmployeeAttribute.setHR_Grade_ID(grade.getHR_Grade_ID());
        }
        MHRDesignation designation = null;
        if (importEmployeeAttribute.getHR_Designation_ID() > 0) {
            designation = MHRDesignation.getById(this.getCtx(), importEmployeeAttribute.getHR_Designation_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (designation == null && importEmployeeAttribute.getDesignationValue() != null) {
            designation = MHRDesignation.getByValue(this.getCtx(), importEmployeeAttribute.getDesignationValue(), importEmployeeAttribute.get_TrxName());
        }
        if (designation != null && designation.getHR_Designation_ID() > 0) {
            importEmployeeAttribute.setHR_Designation_ID(designation.getHR_Designation_ID());
        }
        MHRSalaryStructure salaryStructure = null;
        if (importEmployeeAttribute.getHR_SalaryRange_ID() > 0) {
            salaryStructure = MHRSalaryStructure.getById(this.getCtx(), importEmployeeAttribute.getHR_SalaryStructure_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (salaryStructure == null && importEmployeeAttribute.getSalaryStructureValue() != null) {
            salaryStructure = MHRSalaryStructure.getByValue(this.getCtx(), importEmployeeAttribute.getSalaryStructureValue());
        }
        if (salaryStructure != null && salaryStructure.getHR_SalaryStructure_ID() > 0) {
            importEmployeeAttribute.setHR_SalaryRange_ID(salaryStructure.getHR_SalaryStructure_ID());
        }
        MHRSalaryRange salaryRange = null;
        if (importEmployeeAttribute.getHR_SalaryRange_ID() > 0) {
            salaryRange = MHRSalaryRange.getById(this.getCtx(), importEmployeeAttribute.getHR_SalaryRange_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (salaryRange == null && importEmployeeAttribute.getSalaryRangeValue() != null) {
            salaryRange = MHRSalaryRange.getByValue(this.getCtx(), importEmployeeAttribute.getSalaryRangeValue(), importEmployeeAttribute.get_TrxName());
        }
        if (salaryRange != null && salaryRange.getHR_SalaryRange_ID() > 0) {
            importEmployeeAttribute.setHR_SalaryRange_ID(salaryRange.getHR_SalaryRange_ID());
        }
        MHREmployeeType employeeType = null;
        if (importEmployeeAttribute.getHR_EmployeeType_ID() > 0) {
            employeeType = MHREmployeeType.getById(this.getCtx(), importEmployeeAttribute.getHR_EmployeeType_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (employeeType == null && importEmployeeAttribute.getEmployeeTypeValue() != null) {
            employeeType = MHREmployeeType.getByValue(this.getCtx(), importEmployeeAttribute.getEmployeeTypeValue(), importEmployeeAttribute.get_TrxName());
        }
        if (employeeType != null && employeeType.getHR_EmployeeType_ID() > 0) {
            importEmployeeAttribute.setHR_EmployeeType_ID(employeeType.getHR_EmployeeType_ID());
        }
        MHRSkillType skillType = null;
        if (importEmployeeAttribute.getHR_SkillType_ID() > 0) {
            skillType = MHRSkillType.getById(this.getCtx(), importEmployeeAttribute.getHR_SkillType_ID(), importEmployeeAttribute.get_TrxName());
        }
        if (skillType == null && importEmployeeAttribute.getSkillTypeValue() != null) {
            skillType = MHRSkillType.getByValue(this.getCtx(), importEmployeeAttribute.getSkillTypeValue(), importEmployeeAttribute.get_TrxName());
        }
        if (skillType != null && skillType.getHR_SkillType_ID() > 0) {
            importEmployeeAttribute.setHR_SkillType_ID(skillType.getHR_SkillType_ID());
        }
        importEmployeeAttribute.saveEx();
    }

    private int getId(String tableName, String whereClause, String trxName, Object ... parameters) {
        return new Query(this.getCtx(), tableName, whereClause, trxName).setParameters(parameters).firstId();
    }

    private X_I_HR_Attribute setImportError(X_I_HR_Attribute importEmployeeAttribute, String error) {
        importEmployeeAttribute.setI_ErrorMsg(Msg.parseTranslation((Properties)this.getCtx(), (String)error));
        this.addLog(importEmployeeAttribute.getHR_Attribute_ID(), importEmployeeAttribute.getValidFrom(), importEmployeeAttribute.getAmount(), importEmployeeAttribute.getI_ErrorMsg());
        return importEmployeeAttribute;
    }

    private boolean importRecord(X_I_HR_Attribute importEmployeeAttribute) {
        MHRAttribute employeeAttribute;
        MHREmployee employee;
        if (importEmployeeAttribute.getI_ErrorMsg() != null && importEmployeeAttribute.getI_ErrorMsg().length() > 0) {
            importEmployeeAttribute.setProcessed(false);
            importEmployeeAttribute.setI_IsImported(false);
            importEmployeeAttribute.saveEx();
            return false;
        }
        Optional<BigDecimal> optionalAmount = Optional.ofNullable(importEmployeeAttribute.getAmount());
        Optional<BigDecimal> optionalQuantity = Optional.ofNullable(importEmployeeAttribute.getQty());
        Optional<Timestamp> optionalServiceDate = Optional.ofNullable(importEmployeeAttribute.getServiceDate());
        Optional<String> optionalTextMsg = Optional.ofNullable(importEmployeeAttribute.getTextMsg());
        Optional<Integer> optionalMinValue = Optional.ofNullable(importEmployeeAttribute.getMinValue());
        Optional<Integer> optionalMaxValue = Optional.ofNullable(importEmployeeAttribute.getMaxValue());
        Optional<Integer> optionalDepartmentId = Optional.ofNullable(importEmployeeAttribute.getHR_Department_ID());
        Optional<Integer> optionalJobId = Optional.ofNullable(importEmployeeAttribute.getHR_Job_ID());
        Optional<Timestamp> optionalValidFrom = Optional.ofNullable(importEmployeeAttribute.getValidFrom());
        Optional<Timestamp> optionalValidTo = Optional.ofNullable(importEmployeeAttribute.getValidTo());
        Optional<Integer> optionalRuleId = Optional.ofNullable(importEmployeeAttribute.getAD_Rule_ID());
        Optional<MHRPayroll> optionalPayroll = Optional.ofNullable(MHRPayroll.getByValue(this.getCtx(), importEmployeeAttribute.getPayrollValue(), importEmployeeAttribute.get_TrxName()));
        Optional<String> optinalReferenceNo = Optional.ofNullable(importEmployeeAttribute.getReferenceNo());
        int payrollId = optionalPayroll.isPresent() ? optionalPayroll.get().getHR_Payroll_ID() : 0;
        MHRConcept concept = MHRConcept.getById(this.getCtx(), importEmployeeAttribute.getHR_Concept_ID(), importEmployeeAttribute.get_TrxName());
        Optional<MHRAttribute> optionalAttribute = Optional.ofNullable(MHRAttribute.getByConceptAndPartnerId(concept, importEmployeeAttribute.getC_BPartner_ID(), payrollId, importEmployeeAttribute.getReferenceNo(), importEmployeeAttribute.getDescription(), importEmployeeAttribute.getValidFrom()));
        int employeeId = 0;
        if (importEmployeeAttribute.getC_BPartner_ID() > 0 && (employee = MHREmployee.getActiveEmployee(this.getCtx(), importEmployeeAttribute.getC_BPartner_ID(), this.get_TrxName())) != null) {
            employeeId = employee.getHR_Employee_ID();
        }
        if ((employeeAttribute = optionalAttribute.orElseGet(() -> new MHRAttribute(importEmployeeAttribute))).getHR_Attribute_ID() <= 0) {
            employeeAttribute.setColumnType(concept.getColumnType());
            optionalValidFrom.ifPresent(validFrom -> employeeAttribute.setValidFrom((Timestamp)validFrom));
            optionalPayroll.ifPresent(payroll -> employeeAttribute.setHR_Payroll_ID(payroll.getHR_Payroll_ID()));
            if (employeeId > 0) {
                employeeAttribute.setHR_Employee_ID(employeeId);
            }
        }
        optinalReferenceNo.ifPresent(referenceNo -> employeeAttribute.setReferenceNo((String)referenceNo));
        optionalAmount.filter(amount -> amount != null && amount.signum() > 0).ifPresent(amount -> employeeAttribute.setAmount((BigDecimal)amount));
        optionalQuantity.filter(quantity -> quantity != null && quantity.signum() > 0).ifPresent(quantity -> employeeAttribute.setQty((BigDecimal)quantity));
        optionalServiceDate.ifPresent(serviceDate -> employeeAttribute.setServiceDate((Timestamp)serviceDate));
        optionalTextMsg.ifPresent(msgText -> employeeAttribute.setTextMsg((String)msgText));
        optionalMinValue.filter(minValue -> minValue != null && minValue > 0).ifPresent(minValue -> employeeAttribute.setMinValue((int)minValue));
        optionalMaxValue.filter(maxValue -> maxValue != null && maxValue > 0).ifPresent(maxValue -> employeeAttribute.setMaxValue((int)maxValue));
        optionalDepartmentId.ifPresent(departamentId -> employeeAttribute.setHR_Department_ID((int)departamentId));
        optionalJobId.ifPresent(jobId -> employeeAttribute.setHR_Job_ID((int)jobId));
        optionalValidTo.ifPresent(validTo -> employeeAttribute.setValidTo((Timestamp)validTo));
        optionalRuleId.filter(ruleId -> ruleId != null && ruleId > 0).ifPresent(ruleId -> employeeAttribute.setAD_Rule_ID((int)ruleId));
        employeeAttribute.setIsActive(true);
        employeeAttribute.saveEx();
        importEmployeeAttribute.setHR_Attribute_ID(employeeAttribute.get_ID());
        importEmployeeAttribute.setI_IsImported(true);
        importEmployeeAttribute.setI_ErrorMsg("");
        importEmployeeAttribute.setProcessed(true);
        importEmployeeAttribute.saveEx();
        return true;
    }

    private int[] getAttributeIds(boolean isImported, boolean isProcessed, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("I_IsImported").append("=? AND ").append("Processed").append("=?");
        return new Query(this.getCtx(), "I_HR_Attribute", whereClause.toString(), trxName).setOnlyActiveRecords(true).setParameters(new Object[]{isImported, isProcessed}).getIDs();
    }
}

