/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class PayrollViaEMail
extends SvrProcess {
    private int mailTextId = -1;
    private MMailText mailText = null;
    private int bPartnerId = -1;
    private MClient client = null;
    private MBPartner employee = null;
    private int m_counter = 0;
    private int m_errors = 0;
    private int payrollProcessId = -1;
    private int bPartnerGroupId = -1;
    private int reportProcessId = -1;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) {
                this.log.fine("Null parameter: " + name);
                continue;
            }
            if (name.equals("HR_Process_ID")) {
                this.payrollProcessId = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("R_MailText_ID")) {
                this.mailTextId = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.bPartnerGroupId = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.bPartnerId = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Process_ID")) {
                this.reportProcessId = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.mailTextId);
        this.mailText = new MMailText(this.getCtx(), this.mailTextId, this.get_TrxName());
        if (this.mailText.getR_MailText_ID() == 0) {
            throw new Exception("@R_MailText_ID@=" + this.mailTextId + " @NotFound@ ");
        }
        this.client = MClient.get((Properties)this.getCtx());
        if (this.client.getAD_Client_ID() == 0) {
            throw new Exception(" @AD_Client_ID@  @NotFound@ ");
        }
        if (this.client.getSMTPHost() == null || this.client.getSMTPHost().length() == 0) {
            throw new Exception("@SMTPHost@  @NotFound@ ");
        }
        long start = System.currentTimeMillis();
        if (this.bPartnerId > 0) {
            this.employee = new MBPartner(this.getCtx(), this.bPartnerId, this.get_TrxName());
            if (this.employee == null) {
                throw new Exception("@C_BPartner_ID@=" + this.bPartnerId + " @NotFound@");
            }
            this.sendIndividualMail(this.bPartnerId, null);
        } else {
            this.sendBPGroup();
        }
        this.log.fine("From " + this.employee);
        return "@Created@=" + this.m_counter + ", @Errors@=" + this.m_errors + " - " + (System.currentTimeMillis() - start) + "ms";
    }

    private void sendBPGroup() {
        int[] employeeIds;
        ArrayList<Comparable<Boolean>> parameters = new ArrayList<Comparable<Boolean>>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("IsActive").append("=? AND ").append("IsEmployee").append("=? AND ").append("EXISTS (SELECT 1 FROM HR_Movement m WHERE m.C_BPartner_ID=C_BPartner.C_BPartner_ID AND m.HR_Process_ID=?)");
        parameters.add(Boolean.valueOf(true));
        parameters.add(Boolean.valueOf(true));
        parameters.add(Integer.valueOf(this.payrollProcessId));
        if (this.bPartnerGroupId > 0) {
            whereClause.append(" AND ").append("C_BP_Group_ID").append("=? ");
            parameters.add(Integer.valueOf(this.bPartnerGroupId));
        }
        int[] nArray = employeeIds = new Query(this.getCtx(), "C_BPartner", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).getIDs();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer employeeId = nArray[i];
            boolean ok = this.sendIndividualMail(employeeId, null);
            if (ok) {
                ++this.m_counter;
                continue;
            }
            ++this.m_errors;
        }
    }

    private boolean sendIndividualMail(int bPartnerId, String unSubscribe) {
        try {
            MBPartner employee = new MBPartner(this.getCtx(), bPartnerId, null);
            Object message = this.mailText.getMailText(true);
            if (unSubscribe != null) {
                message = (String)message + unSubscribe;
            }
            StringBuffer whereClause = new StringBuffer();
            whereClause.append("C_BPartner_ID").append(" = ? AND ").append("ContactType").append("=?");
            MBPartnerLocation location = (MBPartnerLocation)new Query(this.getCtx(), "C_BPartner_Location", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{bPartnerId, "Primary"}).first();
            if (location == null) {
                this.addLog(0, null, null, employee.getName() + " @Email@ @NotFound@");
                return false;
            }
            DefaultNotifier notifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(this.get_TrxName());
            notifier.clearMessage().withUserId(this.getAD_User_ID()).addAttachment(this.CreatePDF(bPartnerId)).withText((String)message).withDescription(this.mailText.getMailHeader());
            Optional<MUser> maybeContact = Arrays.asList(MUser.getOfBPartner((Properties)this.getCtx(), (int)bPartnerId, null)).stream().filter(user -> user.getC_BPartner_Location_ID() == location.getC_BPartner_Location_ID()).findFirst();
            if (maybeContact.isPresent()) {
                notifier.withApplicationType("UDP").addRecipient(maybeContact.get().getAD_User_ID());
            } else {
                notifier.withApplicationType("EMA").addRecipient(location.getEMail());
            }
            notifier.addToQueue();
            return true;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    private File CreatePDF(int bPartnerId) {
        File attachment = null;
        int AD_Process_ID = this.reportProcessId;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, bPartnerId);
        instance.saveEx();
        ProcessInfo pi = new ProcessInfo("PH_SendEmail", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("HR_Process_ID", this.payrollProcessId);
        ip.saveEx();
        pi.setRecord_ID(bPartnerId);
        pi.setIsBatch(true);
        MProcess worker = new MProcess(this.getCtx(), AD_Process_ID, this.get_TrxName());
        worker.processIt(pi, Trx.get((String)this.get_TrxName(), (boolean)true));
        attachment = pi.getPDFReport();
        return attachment;
    }
}

