/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.services;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_HR_Process;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRDepartment;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRPeriod;

public class HRActionNotice {
    protected static CLogger log = CLogger.getCLogger(HRActionNotice.class);
    public int m_WindowNo = 0;
    protected I_HR_Process payrollProcess = null;
    protected int payrollProcessId = 0;
    protected int payrollId = 0;
    protected int conceptId = 0;
    protected int partnerId = 0;
    protected int movementId = 0;
    protected boolean isLookupTextMsg = false;
    protected Timestamp dateStart = null;
    protected Timestamp dateEnd = null;
    protected BigDecimal quantity = Env.ZERO;
    protected BigDecimal amount = Env.ZERO;
    protected String text = null;
    protected Timestamp serviceDate = null;
    protected String description;
    protected Timestamp validFrom = null;
    protected Timestamp validTo = null;

    public void dynInit() throws Exception {
        log.info("HRActionNotice");
    }

    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("HR_Movement_ID");
        miniTable.addColumn("AD_Org_ID");
        miniTable.addColumn("HR_Concept_ID");
        miniTable.addColumn("ValidFrom");
        miniTable.addColumn("ColumnType");
        miniTable.addColumn("Qty");
        miniTable.addColumn("Amount");
        miniTable.addColumn("ServiceDate");
        miniTable.addColumn("TextMsg");
        miniTable.addColumn("Description");
        miniTable.setColumnClass(0, IDColumn.class, false, " ");
        miniTable.setColumnClass(1, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        miniTable.setColumnClass(2, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"HR_Concept_ID"));
        miniTable.setColumnClass(3, Timestamp.class, true, Msg.translate((Properties)Env.getCtx(), (String)"ValidFrom"));
        miniTable.setColumnClass(4, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"ColumnType"));
        miniTable.setColumnClass(5, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Qty"));
        miniTable.setColumnClass(6, BigDecimal.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        miniTable.setColumnClass(7, Timestamp.class, true, Msg.translate((Properties)Env.getCtx(), (String)"ServiceDate"));
        miniTable.setColumnClass(8, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"TextMsg"));
        miniTable.setColumnClass(9, String.class, true, Msg.translate((Properties)Env.getCtx(), (String)"Description"));
        miniTable.autoSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Properties ctx, IMiniTable miniTable, int beging) {
        if (this.payrollProcessId == 0 || this.partnerId == 0) {
            return;
        }
        StringBuffer sqlQuery = new StringBuffer("SELECT o.Name, hc.Name, hm.ValidFrom, cr.ColumnType, hm.Qty, hm.Amount, hm.ServiceDate, hm.TextMsg, hm.Description, hm.HR_Movement_ID, hm.AD_Org_ID, hm.HR_Process_ID,hm.HR_Concept_ID ");
        sqlQuery.append("FROM HR_Movement hm INNER JOIN AD_Org o ON(hm.AD_Org_ID = o.AD_Org_ID) INNER JOIN HR_Concept hc ON(hm.HR_Concept_ID = hc.HR_Concept_ID) LEFT JOIN (SELECT r.Value, COALESCE(rt.Name, r.Name) ColumnType \t\t\t\tFROM AD_Ref_List r \t\t\t\tLEFT JOIN AD_Ref_List_Trl rt ON(rt.AD_Ref_List_ID = r.AD_Ref_List_ID AND rt.AD_Language = ?) \t\t\t\tWHERE r.AD_Reference_ID = ?) cr ON(cr.Value = hc.ColumnType) ");
        sqlQuery.append("WHERE hm.Processed = 'N' AND hm.HR_Process_ID = ? AND hm.C_BPartner_ID = ? ");
        sqlQuery.append("ORDER BY o.AD_Org_ID, hm.HR_Process_ID, hm.ValidFrom, hm.HR_Concept_ID");
        int row = 0;
        miniTable.setRowCount(row);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sqlQuery.toString(), null);
            pstmt.setString(1, Env.getAD_Language((Properties)Env.getCtx()));
            pstmt.setInt(2, 53243);
            pstmt.setInt(3, this.payrollProcessId);
            pstmt.setInt(4, this.partnerId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int column = beging;
                miniTable.setRowCount(row + 1);
                miniTable.setColumnClass(0, IDColumn.class, false, " ");
                miniTable.setValueAt((Object)rs.getString(1), row, column++);
                miniTable.setValueAt((Object)rs.getString(2), row, column++);
                miniTable.setValueAt((Object)rs.getTimestamp(3), row, column++);
                miniTable.setValueAt((Object)rs.getString(4), row, column++);
                miniTable.setValueAt((Object)(rs.getObject(5) != null ? rs.getBigDecimal(5) : Env.ZERO), row, column++);
                miniTable.setValueAt((Object)(rs.getObject(6) != null ? rs.getBigDecimal(6) : Env.ZERO), row, column++);
                miniTable.setValueAt((Object)rs.getTimestamp(7), row, column++);
                miniTable.setValueAt((Object)rs.getString(8), row, column++);
                miniTable.setValueAt((Object)rs.getString(9), row, column++);
                ++row;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sqlQuery.toString(), (Throwable)e);
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        miniTable.autoSize();
    }

    public static KeyNamePair[] getProcess() {
        String sql = MRole.getDefault().addAccessSQL("SELECT hrp.HR_Process_ID,hrp.DocumentNo ||'-'|| hrp.Name, hrp.DocumentNo, hrp.Name FROM HR_Process hrp", "hrp", true, false) + " AND hrp.IsActive = 'Y' AND hrp.DocStatus IN('DR', 'IP') ";
        sql = sql + " ORDER BY hrp.DocumentNo, hrp.Name";
        return DB.getKeyNamePairs((String)sql, (boolean)true);
    }

    public static KeyNamePair[] getEmployeeValid(I_HR_Process process) {
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        if (process == null) {
            return new KeyNamePair[]{new KeyNamePair(0, "")};
        }
        MHRPayroll payroll = MHRPayroll.getById(Env.getCtx(), process.getHR_Payroll_ID(), process.getName());
        KeyNamePair pp = new KeyNamePair(0, "");
        list.add(pp);
        String sql = MRole.getDefault().addAccessSQL("SELECT bp.C_BPartner_ID, bp.Value || ' - ' || bp.Name || COALESCE(' ' || bp.Name2, '') FROM C_BPartner bp", "bp", true, false) + " AND bp.IsActive = 'Y' AND EXISTS(SELECT 1 FROM HR_Employee hrpe \t\t\t\tWHERE hrpe.C_BPartner_ID = bp.C_BPartner_ID \t\t\t\tAND hrpe.IsActive = 'Y'";
        if (process.getHR_Payroll_ID() != 0 && process.getHR_Payroll_ID() != 0 && !payroll.isIgnoreDefaultPayroll()) {
            sql = sql + " AND (hrpe.HR_Payroll_ID =" + process.getHR_Payroll_ID() + " OR hrpe.HR_Payroll_ID is NULL)";
            if (process.getHR_Department_ID() > 0) {
                sql = sql + " AND (hrpe.HR_Department_ID =" + process.getHR_Department_ID() + " OR hrpe.HR_Department_ID is NULL)";
            }
            if (process.getHR_Job_ID() > 0) {
                sql = sql + " AND (hrpe.HR_Job_ID =" + process.getHR_Job_ID() + " OR hrpe.HR_Job_ID is NULL)";
            }
            if (process.getHR_Employee_ID() > 0) {
                sql = sql + " AND (hrpe.HR_Employee_ID =" + process.getHR_Employee_ID() + " OR hrpe.HR_Employee_ID is NULL)";
            }
        }
        sql = sql + ") ORDER BY 2 ";
        return DB.getKeyNamePairs((String)sql, (boolean)true);
    }

    public KeyNamePair[] getConcept(I_HR_Process process, boolean isFieldProcessNull) {
        if (process == null) {
            return null;
        }
        String sql = MRole.getDefault().addAccessSQL("SELECT hrpc.HR_Concept_ID, hrpc.Value || ' - ' || hrpc.Name, hrpc.Value FROM HR_Concept hrpc ", "hrpc", true, false) + " AND hrpc.AD_Client_ID = " + process.getAD_Client_ID() + " AND hrpc.IsActive = 'Y' AND hrpc.IsManual = 'Y' AND hrpc.Type != 'E' AND EXISTS(SELECT 1 FROM HR_Attribute a \t\t\t\t\t\tWHERE a.HR_Concept_ID = hrpc.HR_Concept_ID";
        if (!isFieldProcessNull) {
            if (process.getHR_Payroll_ID() != 0) {
                sql = sql + " AND (a.HR_Payroll_ID = " + process.getHR_Payroll_ID() + " OR a.HR_Payroll_ID is NULL)";
            }
            if (process.getHR_Department_ID() != 0) {
                // empty if block
            }
            sql = sql + " AND (a.HR_Department_ID = " + process.getHR_Department_ID() + " OR a.HR_Department_ID is NULL)";
            if (process.getHR_Job_ID() != 0) {
                // empty if block
            }
            sql = sql + " AND (a.HR_Job_ID = " + process.getHR_Job_ID() + " OR a.HR_Job_ID is NULL)";
            if (process.getHR_Department_ID() != 0) {
                // empty if block
            }
            sql = sql + " AND (a.HR_Employee_ID = " + process.getHR_Employee_ID() + " OR a.HR_Employee_ID is NULL)";
        }
        sql = sql + ") ORDER BY 2";
        return DB.getKeyNamePairs((String)sql, (boolean)true);
    }

    public int seekMovement(Timestamp dt) {
        if (this.conceptId <= 0) {
            return 0;
        }
        int HR_Movement_ID = 0;
        String date = DB.TO_DATE((Timestamp)dt);
        int Process_ID = this.payrollProcessId;
        int Employee_ID = this.partnerId;
        int Concept_ID = this.conceptId;
        if (Process_ID + Employee_ID + Concept_ID > 0) {
            HR_Movement_ID = DB.getSQLValue(null, (String)("SELECT HR_Movement_ID  FROM HR_Movement WHERE HR_Process_ID = " + Process_ID + " AND C_BPartner_ID =" + Employee_ID + " AND HR_Concept_ID = " + Concept_ID + " AND TRUNC(ValidFrom) = TRUNC(" + date + ")"));
        }
        return HR_Movement_ID;
    }

    public MLookup getColumnTypeLookup() {
        MLookupInfo columnTypeLookup = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)Env.getCtx()), (int)53243);
        return new MLookup(columnTypeLookup, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ValueNamePair> getConceptReference(int referenceId) {
        ArrayList<ValueNamePair> data = new ArrayList<ValueNamePair>();
        MLookupInfo infoLookup = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)Env.getCtx()), (int)referenceId);
        if (infoLookup == null) {
            return data;
        }
        String sql = infoLookup.Query;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            rs = pstmt.executeQuery();
            ValueNamePair vp = null;
            data.add(new ValueNamePair("", ""));
            while (rs.next()) {
                vp = new ValueNamePair(rs.getString(2), rs.getString(3));
                data.add(vp);
            }
        }
        catch (SQLException e) {
            try {
                log.log(Level.SEVERE, sql, (Throwable)e);
            }
            catch (Throwable throwable) {
                DB.close(rs);
                DB.close((Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs);
            DB.close((Statement)pstmt);
        }
        DB.close((ResultSet)rs);
        DB.close((Statement)pstmt);
        return data;
    }

    protected Integer getConceptId() {
        return this.conceptId;
    }

    protected Integer getPartnerId() {
        return this.partnerId;
    }

    protected I_HR_Process getPayrollProcess() {
        return this.payrollProcess;
    }

    protected BigDecimal getQuantity() {
        return this.quantity;
    }

    protected BigDecimal getAmount() {
        return this.amount;
    }

    protected String getText() {
        return this.text;
    }

    protected String getDescription() {
        return this.description;
    }

    protected Timestamp getValidFrom() {
        return this.validFrom;
    }

    protected Timestamp getValidTo() {
        return this.validTo;
    }

    protected Timestamp getServiceDate() {
        return this.serviceDate;
    }

    public MHRMovement saveMovement() {
        MHRConcept concept = MHRConcept.getById(Env.getCtx(), this.getConceptId(), null);
        MHRMovement movement = new MHRMovement(Env.getCtx(), this.movementId, null);
        MHRPeriod payrollPeriod = MHRPeriod.getById(Env.getCtx(), this.getPayrollProcess().getHR_Period_ID(), null);
        movement.setSeqNo(concept.getSeqNo());
        Optional.ofNullable(this.getDescription()).ifPresent(description -> movement.setDescription(description.toString()));
        movement.setHR_Process_ID(this.getPayrollProcess().getHR_Process_ID());
        Optional.ofNullable(payrollPeriod).ifPresent(period -> movement.setPeriodNo(period.getPeriodNo()));
        movement.setC_BPartner_ID(this.getPartnerId());
        movement.setHR_Concept_ID(this.getConceptId());
        movement.setHR_Concept_Category_ID(concept.getHR_Concept_Category_ID());
        if (concept.getColumnType().equals("Q")) {
            Optional.ofNullable(this.getQuantity()).ifPresent(qty -> movement.setQty((BigDecimal)qty));
        } else if (concept.getColumnType().equals("A")) {
            Optional.ofNullable(this.getAmount()).ifPresent(amount -> movement.setAmount((BigDecimal)amount));
        }
        movement.setTextMsg(this.getText());
        movement.setServiceDate(this.getServiceDate());
        movement.setValidFrom(this.getValidFrom());
        movement.setValidTo(this.getValidTo());
        MHREmployee employee = MHREmployee.getActiveEmployee(Env.getCtx(), movement.getC_BPartner_ID(), null);
        if (employee != null) {
            MHRPayroll payroll = MHRPayroll.getById(Env.getCtx(), this.payrollProcess.getHR_Payroll_ID(), null);
            movement.setAD_Org_ID(employee.getAD_Org_ID());
            movement.setHR_Department_ID(employee.getHR_Department_ID());
            movement.setHR_Job_ID(employee.getHR_Job_ID());
            movement.setHR_SkillType_ID(employee.getHR_SkillType_ID());
            movement.setC_Activity_ID(employee.getC_Activity_ID() > 0 ? employee.getC_Activity_ID() : MHRDepartment.getById(Env.getCtx(), employee.getHR_Department_ID(), null).getC_Activity_ID());
            movement.setHR_Payroll_ID(this.payrollProcess.getHR_Payroll_ID());
            movement.setHR_Contract_ID(payroll.getHR_Contract_ID());
            movement.setHR_Employee_ID(employee.getHR_Employee_ID());
            movement.setHR_EmployeeType_ID(employee.getHR_EmployeeType_ID());
        }
        movement.setIsManual(true);
        movement.saveEx();
        if (!(movement.getAmount() != null && !movement.getAmount().equals(Env.ZERO) || movement.getQty() != null && !movement.getQty().equals(Env.ZERO) || movement.getServiceDate() != null || movement.getTextMsg() != null && !Util.isEmpty((String)movement.getTextMsg()))) {
            movement.deleteEx(false);
        }
        this.movementId = movement.getHR_Movement_ID();
        return movement;
    }
}

