/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.services;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MPaymentBatch;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.ValueNamePair;
import org.eevolution.hr.model.MHRPaySelectionCheck;

public class HRPayPrint {
    public int m_WindowNo = 0;
    public int m_C_BankAccount_ID = -1;
    public String m_PaymentExportClass = null;
    public List<MHRPaySelectionCheck> m_checks = null;
    public MPaymentBatch m_batch = null;
    public static CLogger log = CLogger.getCLogger(HRPayPrint.class);
    public String bank;
    public String currency;
    public BigDecimal balance;
    public String noPayments;
    public Integer documentNo;

    public ArrayList<KeyNamePair> getPaySelectionData() {
        ArrayList<KeyNamePair> data = new ArrayList<KeyNamePair>();
        log.config("");
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        String sql = "SELECT HR_PaySelection_ID, Name || ' - ' || TotalAmt FROM HR_PaySelection WHERE AD_Client_ID=? AND Processed='Y' AND IsActive='Y'ORDER BY PayDate DESC";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                data.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return data;
    }

    public void loadPaySelectInfo(int HR_PaySelection_ID) {
        this.m_C_BankAccount_ID = -1;
        String sql = "SELECT ps.C_BankAccount_ID, b.Name || ' ' || ba.AccountNo, c.ISO_Code, CurrentBalance , ba.PaymentExportClass FROM HR_PaySelection ps INNER JOIN C_BankAccount ba ON (ps.C_BankAccount_ID=ba.C_BankAccount_ID) INNER JOIN C_Bank b ON (ba.C_Bank_ID=b.C_Bank_ID) INNER JOIN C_Currency c ON (ba.C_Currency_ID=c.C_Currency_ID) WHERE ps.HR_PaySelection_ID=? AND ps.Processed='Y' AND ba.IsActive='Y'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, HR_PaySelection_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_C_BankAccount_ID = rs.getInt(1);
                this.bank = rs.getString(2);
                this.currency = rs.getString(3);
                this.balance = rs.getBigDecimal(4);
                this.m_PaymentExportClass = rs.getString(5);
            } else {
                this.m_C_BankAccount_ID = -1;
                this.bank = "";
                this.currency = "";
                this.balance = Env.ZERO;
                this.m_PaymentExportClass = null;
                log.log(Level.SEVERE, "No active BankAccount for HR_PaySelection_ID=" + HR_PaySelection_ID);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public ArrayList<ValueNamePair> loadPaymentRule(int C_PaySelection_ID) {
        ArrayList<ValueNamePair> data = new ArrayList<ValueNamePair>();
        int AD_Reference_ID = 195;
        Language language = Language.getLanguage((String)Env.getAD_Language((Properties)Env.getCtx()));
        MLookupInfo info = MLookupFactory.getLookup_List((Language)language, (int)AD_Reference_ID);
        String sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM HR_PaySelectionCheck WHERE HR_PaySelection_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, C_PaySelection_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ValueNamePair pp = new ValueNamePair(rs.getString(2), rs.getString(3));
                data.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (data.size() == 0) {
            log.config("PaySel=" + C_PaySelection_ID + ", BAcct=" + this.m_C_BankAccount_ID + " - " + sql);
        }
        return data;
    }

    public String loadPaymentRuleInfo(int HR_PaySelection_ID, String PaymentRule) {
        ResultSet rs;
        CPreparedStatement pstmt;
        String msg = null;
        String sql = "SELECT COUNT(*) FROM HR_PaySelectionCheck WHERE HR_PaySelection_ID=?";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, HR_PaySelection_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.noPayments = String.valueOf(rs.getInt(1));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        sql = "SELECT CurrentNext FROM C_BankAccountDoc WHERE C_BankAccount_ID=? AND PaymentRule=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.m_C_BankAccount_ID);
            pstmt.setString(2, PaymentRule);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                this.documentNo = rs.getInt(1);
            } else {
                log.log(Level.SEVERE, "VPayPrint.loadPaymentRuleInfo - No active BankAccountDoc for C_BankAccount_ID=" + this.m_C_BankAccount_ID + " AND PaymentRule=" + PaymentRule);
                msg = "VPayPrintNoDoc";
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return msg;
    }
}

