/*
 * Decompiled with CFR 0.152.
 */
package org.spin.hr.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.X_HR_Leave;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHRLeave;
import org.eevolution.hr.model.MHRLeaveType;
import org.eevolution.hr.model.MHRWorkShift;

public class TNAUtil {
    public static double getIncidenceSum(Properties ctx, String conceptValue, String workShiftValue, int partnerId, Timestamp from, Timestamp to, String trxName) {
        MHRConcept concept = MHRConcept.getByValue(ctx, conceptValue, trxName);
        if (concept == null) {
            return 0.0;
        }
        int workShiftId = 0;
        if (!Util.isEmpty((String)workShiftValue)) {
            MHRWorkShift workShift = MHRWorkShift.getByValue(ctx, workShiftValue, trxName);
            workShiftId = workShift.getHR_WorkShift_ID();
        }
        return TNAUtil.getIncidenceSum(ctx, concept.getHR_Concept_ID(), workShiftId, partnerId, from, to, trxName);
    }

    public static double getIncidenceSum(Properties ctx, int conceptId, int workShiftId, int partnerId, Timestamp from, Timestamp to, String trxName) {
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Concept_ID=?");
        params.add(Integer.valueOf(conceptId));
        whereClause.append(" AND C_BPartner_ID =?");
        params.add(Integer.valueOf(partnerId));
        whereClause.append(" AND ").append("DateDoc BETWEEN ? AND ?");
        params.add(from);
        params.add(to);
        whereClause.append(" AND ").append("DocStatus IN('CO', 'CL')");
        if (workShiftId > 0) {
            whereClause.append(" AND EXISTS (SELECT 1 FROM HR_AttendanceBatch b WHERE HR_Incidence.HR_AttendanceBatch_ID = b.HR_AttendanceBatch_ID AND b.HR_WorkShift_ID=?)");
            params.add(Integer.valueOf(workShiftId));
        }
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(Qty), SUM(Amt), 0) FROM HR_Incidence").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx((String)trxName, (String)sql.toString(), params);
        return value.doubleValue();
    }

    public static long getLeaveTimeBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, boolean excludeOverlapedTime, String trxName) {
        List<MHRLeave> leaveList = TNAUtil.getLeaveListBetween(ctx, businessPartnerId, leaveTypeValue, from, to, trxName);
        AtomicLong timeBetween = new AtomicLong();
        AtomicLong overlapedTime = new AtomicLong();
        AtomicReference startDate = new AtomicReference();
        AtomicReference endDate = new AtomicReference();
        leaveList.stream().sorted(Comparator.comparing(X_HR_Leave::getStartDate)).forEach(leave -> {
            timeBetween.addAndGet(TimeUtil.getMillisecondsBetween((Timestamp)leave.getStartDate(), (Timestamp)leave.getEndDate()));
            Timestamp lastStartDate = startDate.getAndSet(leave.getStartDate());
            Timestamp lastEndDate = endDate.getAndSet(leave.getEndDate());
            if (lastStartDate != null && lastEndDate != null && TimeUtil.isValid((Timestamp)lastStartDate, (Timestamp)lastEndDate, (Timestamp)leave.getStartDate())) {
                Timestamp endDateForOverlap = lastEndDate;
                if (lastEndDate.getTime() > leave.getEndDate().getTime()) {
                    endDateForOverlap = leave.getEndDate();
                }
                overlapedTime.addAndGet(TimeUtil.getMillisecondsBetween((Timestamp)leave.getStartDate(), (Timestamp)endDateForOverlap));
            }
        });
        if (excludeOverlapedTime) {
            return timeBetween.get() - overlapedTime.get();
        }
        return timeBetween.get();
    }

    public static MHRLeave getFirstLeaveBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, String trxName) {
        Optional<MHRLeave> leave = TNAUtil.getLeaveListBetween(ctx, businessPartnerId, leaveTypeValue, from, to, trxName).stream().sorted(Comparator.comparing(X_HR_Leave::getStartDate)).findFirst();
        if (leave.isPresent()) {
            return leave.get();
        }
        return null;
    }

    public static MHRLeave getLastLeaveBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, String trxName) {
        Optional<MHRLeave> leave = TNAUtil.getLeaveListBetween(ctx, businessPartnerId, leaveTypeValue, from, to, trxName).stream().sorted(Comparator.comparing(X_HR_Leave::getEndDate).reversed()).findFirst();
        if (leave.isPresent()) {
            return leave.get();
        }
        return null;
    }

    public static Timestamp getLeaveStartDateBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, String trxName) {
        MHRLeave leave = TNAUtil.getFirstLeaveBetween(ctx, businessPartnerId, leaveTypeValue, from, to, trxName);
        if (leave != null) {
            return leave.getStartDate();
        }
        return null;
    }

    public static Timestamp getLeaveEndDateBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, String trxName) {
        MHRLeave leave = TNAUtil.getLastLeaveBetween(ctx, businessPartnerId, leaveTypeValue, from, to, trxName);
        if (leave != null) {
            return leave.getEndDate();
        }
        return null;
    }

    public static double getLeaveHoursBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, boolean excludeOverlapedTime, String trxName) {
        return TimeUtil.getHoursFromDuration((long)TNAUtil.getLeaveTimeBetween(ctx, businessPartnerId, leaveTypeValue, from, to, excludeOverlapedTime, trxName));
    }

    public static int getLeaveMinutesBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, boolean excludeOverlapedTime, String trxName) {
        return TimeUtil.getMinutesFromDuration((long)TNAUtil.getLeaveTimeBetween(ctx, businessPartnerId, leaveTypeValue, from, to, excludeOverlapedTime, trxName));
    }

    public static int getLeaveDaysBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, boolean excludeOverlapedTime, String trxName) {
        return TimeUtil.getDaysFromDuration((long)TNAUtil.getLeaveTimeBetween(ctx, businessPartnerId, leaveTypeValue, from, to, excludeOverlapedTime, trxName));
    }

    public static boolean isLeaveAllowedEncashment(Properties ctx, String leaveTypeValue, String trxName) {
        MHRLeaveType leaveType = MHRLeaveType.getByValue(ctx, leaveTypeValue, trxName);
        return leaveType != null && leaveType.isAllowedEncashment();
    }

    public static boolean isLeaveAllowedEncashment(String leaveTypeValue) {
        return TNAUtil.isLeaveAllowedEncashment(Env.getCtx(), leaveTypeValue, null);
    }

    public static List<MHRLeave> getLeaveListBetween(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp from, Timestamp to, String trxName) {
        MHRLeaveType leaveType;
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        parameters.add(Integer.valueOf(businessPartnerId));
        StringBuffer whereClause = new StringBuffer("DocStatus IN('CO') AND C_BPartner_ID = ?");
        if (from != null && to != null) {
            whereClause.append(" AND StartDate >= ? AND EndDate <= ?");
            parameters.add(from);
            parameters.add(to);
        } else if (from != null) {
            whereClause.append(" AND EndDate >= ?");
            parameters.add(from);
        } else {
            whereClause.append(" AND EndDate >= ?");
            parameters.add(to);
        }
        if (!Util.isEmpty((String)leaveTypeValue) && (leaveType = MHRLeaveType.getByValue(ctx, leaveTypeValue, trxName)) != null) {
            whereClause.append(" AND HR_LeaveType_ID = ?");
            parameters.add(Integer.valueOf(leaveType.getHR_LeaveType_ID()));
        }
        return new Query(ctx, "HR_Leave", whereClause.toString(), trxName).setParameters(parameters).setOnlyActiveRecords(true).setOrderBy("StartDate").list();
    }

    public static List<MHRLeave> getLeaveListAttendanceTime(Properties ctx, int businessPartnerId, String leaveTypeValue, Timestamp attendanceTime, String trxName) {
        MHRLeaveType leaveType;
        String optionalWhereClause = "";
        ArrayList<Comparable<Integer>> parameters = new ArrayList<Comparable<Integer>>();
        parameters.add(Integer.valueOf(businessPartnerId));
        parameters.add(attendanceTime);
        if (!Util.isEmpty((String)leaveTypeValue) && (leaveType = MHRLeaveType.getByValue(ctx, leaveTypeValue, trxName)) != null) {
            optionalWhereClause = " AND HR_LeaveType_ID = ?";
            parameters.add(Integer.valueOf(leaveType.getHR_LeaveType_ID()));
        }
        return new Query(ctx, "HR_Leave", "DocStatus IN('CO') AND C_BPartner_ID = ? AND ? BETWEEN StartDate AND EndDate" + optionalWhereClause, trxName).setParameters(parameters).setOnlyActiveRecords(true).setOrderBy("StartDate").list();
    }

    public static String getDurationUnitFromTimeUnit(String timeUnit) {
        if (Util.isEmpty((String)timeUnit)) {
            return null;
        }
        if (timeUnit.equals("I")) {
            return "m";
        }
        if (timeUnit.equals("H")) {
            return "h";
        }
        if (timeUnit.equals("D")) {
            return "D";
        }
        if (timeUnit.equals("W")) {
            return "W";
        }
        if (timeUnit.equals("M")) {
            return "M";
        }
        if (timeUnit.equals("Y")) {
            return "Y";
        }
        return null;
    }

    public static String getDurationUnitFromFrequencyType(String frequencyType) {
        if (Util.isEmpty((String)frequencyType)) {
            return null;
        }
        if (frequencyType.equals("M")) {
            return "m";
        }
        if (frequencyType.equals("H")) {
            return "h";
        }
        if (frequencyType.equals("D")) {
            return "D";
        }
        if (frequencyType.equals("N")) {
            return "M";
        }
        if (frequencyType.equals("Y")) {
            return "Y";
        }
        return null;
    }
}

