/*
 * Decompiled with CFR 0.152.
 */
package org.spin.pr.process;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.adempiere.core.domains.models.I_HR_Process;
import org.adempiere.core.domains.models.X_RV_HR_ProcessDetail;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MQuery;
import org.compiere.model.PrintInfo;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.util.Env;
import org.compiere.util.ExtensionFileFilter;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRProcess;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.hr.util.AbstractPayrollReportExport;
import org.spin.pr.model.MHRProcessReport;
import org.spin.pr.model.MHRProcessReportTemplate;
import org.spin.pr.process.PayrollProcessReportAbstract;

public class PayrollProcessReport
extends PayrollProcessReportAbstract {
    private int printFormatId = 0;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getHRProcessId() == 0 && this.getTable_ID() == I_HR_Process.Table_ID && this.getRecord_ID() > 0) {
            this.setHRProcessId(this.getRecord_ID());
        }
    }

    protected String doIt() throws Exception {
        MHRProcessReportTemplate template;
        MHRProcessReport processReport = MHRProcessReport.get(this.getCtx(), this.getProcessReportId());
        if (processReport.isCanExport()) {
            return this.exportToFile(processReport);
        }
        String name = processReport.getName();
        String printName = processReport.getPrintName();
        String textMsg = processReport.getTextMsg();
        String receiptFooterMsg = processReport.getReceiptFooterMsg();
        if (this.getProcessReportTemplateId() != 0 && (template = MHRProcessReportTemplate.get(this.getCtx(), this.getProcessReportTemplateId())) != null) {
            this.printFormatId = template.getAD_PrintFormat_ID();
            if (!Util.isEmpty((String)template.getName())) {
                name = template.getName();
            }
            if (!Util.isEmpty((String)template.getPrintName())) {
                printName = template.getPrintName();
            }
            if (!Util.isEmpty((String)template.getTextMsg())) {
                textMsg = template.getTextMsg();
            }
            if (!Util.isEmpty((String)template.getReceiptFooterMsg())) {
                receiptFooterMsg = template.getReceiptFooterMsg();
            }
        }
        if (this.printFormatId == 0) {
            this.printFormatId = processReport.getAD_PrintFormat_ID();
        }
        if (this.printFormatId == 0 && this.getPayrollId() != 0) {
            MHRPayroll payroll = MHRPayroll.getById(this.getCtx(), this.getPayrollId(), this.get_TrxName());
            this.printFormatId = payroll.getAD_PrintFormat_ID();
            this.log.info("Print Format from Payroll");
        }
        if (this.printFormatId == 0 && this.getHRProcessId() != 0) {
            MHRProcess process = new MHRProcess(this.getCtx(), this.getHRProcessId(), this.get_TrxName());
            MHRPayroll payroll = MHRPayroll.getById(this.getCtx(), process.getHR_Payroll_ID(), this.get_TrxName());
            this.printFormatId = payroll.getAD_PrintFormat_ID();
            this.log.info("Print Format from Process");
        }
        if (this.printFormatId == 0) {
            throw new AdempiereException("@AD_PrintFormat_ID@ @NotFound@");
        }
        MPrintFormat format = MPrintFormat.get((Properties)this.getCtx(), (int)this.printFormatId, (boolean)false);
        MQuery query = new MQuery("HR_ProcessReport");
        query.addRestriction("HR_ProcessReport_ID", "=", this.getProcessReportId());
        PrintInfo printInfo = new PrintInfo(Msg.translate((Properties)this.getCtx(), (String)"HR_ProcessReport_ID"), this.getTable_ID(), this.getProcessReportId());
        printInfo.setAD_Table_ID(this.getTable_ID());
        if (format != null && format.getJasperProcess_ID() > 0) {
            ProcessBuilder builder = ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(format.getJasperProcess_ID())).withTitle(this.getProcessInfo().getTitle()).withRecordId(Integer.valueOf(I_HR_Process.Table_ID), Integer.valueOf(this.getProcessReportId())).withParameter("ProcessReportName", (Object)name).withParameter("ProcessReportPrintName", (Object)printName).withParameter("ProcessReportTextMsg", (Object)textMsg).withParameter("ProcessReportReceiptFooterMsg", (Object)receiptFooterMsg);
            if (this.getRecord_ID() != 0) {
                builder.withParameter("HR_Process_ID", (Object)new BigDecimal(this.getHRProcessId()));
            }
            Arrays.asList(this.getParameter()).forEach(parameter -> builder.withParameter(parameter.getParameterName(), parameter.getParameter(), parameter.getParameter_To()));
            builder.withPrintPreview();
            ProcessInfo processInfo = builder.execute(this.get_TrxName());
            this.getProcessInfo().setPDFReport(processInfo.getPDFReport());
            this.getProcessInfo().setReportAsFile(processInfo.getPDFReport());
        }
        return "Ok";
    }

    public List<X_RV_HR_ProcessDetail> loadDetail(MHRProcessReport payrollReport) throws Exception {
        if (payrollReport.getFileExportClass() == null || payrollReport.getFileExportClass().length() == 0) {
            throw new AdempiereException("@FileExportClass@ @NotFound@");
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        for (ProcessInfoParameter parameter : this.getParameter()) {
            if (parameter.getParameter() == null && parameter.getParameter_To() == null || parameter.getParameterName().equals("HR_ProcessReportTemplate_ID")) continue;
            if (parameter.getParameter_To() == null) {
                if (parameter.getParameter() == null) continue;
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append(parameter.getParameterName()).append("=?");
                parameters.add(parameter.getParameter());
                continue;
            }
            if (parameter.getParameter() != null) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append(parameter.getParameterName()).append(">=?");
                parameters.add(parameter.getParameter());
            }
            if (parameter.getParameter_To() == null) continue;
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append(parameter.getParameterName()).append("<=?");
            parameters.add(parameter.getParameter_To());
        }
        return new Query(this.getCtx(), "RV_HR_ProcessDetail", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(parameters).setOnlyActiveRecords(true).list();
    }

    public String exportToFile(MHRProcessReport payrollReport) throws Exception {
        List<X_RV_HR_ProcessDetail> detail = this.loadDetail(payrollReport);
        if (!Ini.isClient()) {
            return "Ok";
        }
        if (detail == null || detail.size() == 0) {
            return "Ok";
        }
        AbstractPayrollReportExport reportExport = payrollReport.getPayrollReportExport();
        if (reportExport == null) {
            return "Ok";
        }
        File exportFile = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogType(1);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(Msg.getMsg((Properties)this.getCtx(), (String)"Export") + ": " + payrollReport.getName());
        if (!Util.isEmpty((String)reportExport.getExtension())) {
            chooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter(reportExport.getExtension(), payrollReport.getName()));
        }
        if (chooser.showSaveDialog(Env.getWindow((int)this.getProcessInfo().getWindowNo())) != 0) {
            return "Ok";
        }
        exportFile = ExtensionFileFilter.getFile((File)chooser.getSelectedFile(), (FileFilter)chooser.getFileFilter());
        String ext = exportFile.getPath();
        if (ext.lastIndexOf(46) == -1) {
            if (Util.isEmpty((String)reportExport.getCompleteFileName())) {
                return "@Error@: @FileInvalidExtension@";
            }
            exportFile = new File(exportFile.getParentFile(), reportExport.getCompleteFileName());
        }
        ext = ext.substring(ext.lastIndexOf(46) + 1).toLowerCase();
        this.log.config("File=" + exportFile.getPath() + "; Type=" + ext);
        exportFile.createNewFile();
        boolean isExported = payrollReport.exportToFile(exportFile, detail);
        if (isExported && Ini.isClient()) {
            Env.startBrowser((String)exportFile.toURI().toString());
        }
        return "@Exported@ : " + exportFile.getPath();
    }
}

