/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Contract;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRContract
extends X_HR_Contract {
    private static final long serialVersionUID = -389190817785883946L;
    private static CCache<Integer, MHRContract> contractCacheIds = new CCache("HR_Contract", 30);
    private static CCache<String, MHRContract> contractCacheValues = new CCache("HR_Contract", 30);

    public MHRContract(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRContract(Properties ctx, int HR_Degree_ID, String trxName) {
        super(ctx, HR_Degree_ID, trxName);
    }

    public MHRContract(Properties ctx, String degreeValue, String degreeName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(degreeValue);
        this.setName(degreeName);
    }

    public static MHRContract getById(Properties ctx, int degreeId, String trxName) {
        if (degreeId <= 0) {
            return null;
        }
        MHRContract degree = (MHRContract)((Object)contractCacheIds.get((Object)degreeId));
        if (degree != null && degree.get_ID() > 0) {
            return degree;
        }
        degree = (MHRContract)new Query(ctx, "HR_Contract", "HR_Contract_ID=?", trxName).setClient_ID().setParameters(new Object[]{degreeId}).first();
        if (degree != null && degree.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + degree.getValue();
            contractCacheValues.put((Object)key, (Object)degree);
            contractCacheIds.put((Object)degree.get_ID(), (Object)degree);
        }
        return degree;
    }

    public static MHRContract getByValue(Properties ctx, String degreeValue) {
        int clientId;
        String key;
        MHRContract degree;
        if (degreeValue == null) {
            return null;
        }
        if (contractCacheValues.size() == 0) {
            MHRContract.getAll(ctx, true);
        }
        if ((degree = (MHRContract)((Object)contractCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + degreeValue)))) != null && degree.get_ID() > 0) {
            return degree;
        }
        degree = (MHRContract)new Query(ctx, "HR_Contract", "Value=?", null).setClient_ID().setParameters(new Object[]{degreeValue}).first();
        if (degree != null && degree.get_ID() > 0) {
            contractCacheValues.put((Object)key, (Object)degree);
            contractCacheIds.put((Object)degree.get_ID(), (Object)degree);
        }
        return degree;
    }

    public static List<MHRContract> getAll(Properties ctx, boolean resetCache) {
        if (resetCache || contractCacheIds.size() > 0) {
            List degreeList = new Query(Env.getCtx(), "HR_Contract", null, null).setClient_ID().setOrderBy("Name").list();
            degreeList.stream().forEach(degree -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + degree.getValue();
                contractCacheIds.put((Object)degree.getHR_Contract_ID(), (Object)degree);
                contractCacheValues.put((Object)key, (Object)degree);
            });
            return degreeList;
        }
        List<MHRContract> degreeList = contractCacheIds.entrySet().stream().map(degree -> (MHRContract)((Object)((Object)degree.getValue()))).collect(Collectors.toList());
        return degreeList;
    }
}

