/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Degree;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRDegree
extends X_HR_Degree {
    private static final long serialVersionUID = -389190817785883946L;
    private static CCache<Integer, MHRDegree> degreeCacheIds = new CCache("HR_Degree", 30);
    private static CCache<String, MHRDegree> degreeCacheValues = new CCache("HR_Degree", 30);

    public MHRDegree(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRDegree(Properties ctx, int HR_Degree_ID, String trxName) {
        super(ctx, HR_Degree_ID, trxName);
    }

    public MHRDegree(Properties ctx, String degreeValue, String degreeName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(degreeValue);
        this.setName(degreeName);
    }

    public static MHRDegree getById(Properties ctx, int degreeId, String trxName) {
        if (degreeId <= 0) {
            return null;
        }
        MHRDegree degree = (MHRDegree)((Object)degreeCacheIds.get((Object)degreeId));
        if (degree != null && degree.get_ID() > 0) {
            return degree;
        }
        degree = (MHRDegree)new Query(ctx, "HR_Degree", "HR_Degree_ID=?", trxName).setClient_ID().setParameters(new Object[]{degreeId}).first();
        if (degree != null && degree.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + degree.getValue();
            degreeCacheValues.put((Object)key, (Object)degree);
            degreeCacheIds.put((Object)degree.get_ID(), (Object)degree);
        }
        return degree;
    }

    public static MHRDegree getByValue(Properties ctx, String degreeValue, String trxName) {
        int clientId;
        String key;
        MHRDegree degree;
        if (degreeValue == null) {
            return null;
        }
        if (degreeCacheValues.size() == 0) {
            MHRDegree.getAll(ctx, true, trxName);
        }
        if ((degree = (MHRDegree)((Object)degreeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + degreeValue)))) != null && degree.get_ID() > 0) {
            return degree;
        }
        degree = (MHRDegree)new Query(ctx, "HR_Degree", "Value=?", trxName).setClient_ID().setParameters(new Object[]{degreeValue}).first();
        if (degree != null && degree.get_ID() > 0) {
            degreeCacheValues.put((Object)key, (Object)degree);
            degreeCacheIds.put((Object)degree.get_ID(), (Object)degree);
        }
        return degree;
    }

    public static List<MHRDegree> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || degreeCacheIds.size() > 0) {
            List degreeList = new Query(Env.getCtx(), "HR_Degree", null, trxName).setClient_ID().setOrderBy("Name").list();
            degreeList.stream().forEach(degree -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + degree.getValue();
                degreeCacheIds.put((Object)degree.getHR_Degree_ID(), (Object)degree);
                degreeCacheValues.put((Object)key, (Object)degree);
            });
            return degreeList;
        }
        List<MHRDegree> degreeList = degreeCacheIds.entrySet().stream().map(degree -> (MHRDegree)((Object)((Object)degree.getValue()))).collect(Collectors.toList());
        return degreeList;
    }
}

