/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Department;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRDepartment
extends X_HR_Department {
    private static final long serialVersionUID = 83878114891519775L;
    private static CCache<Integer, MHRDepartment> departmentCacheIds = new CCache("HR_Department", 100, 0);
    private static CCache<String, MHRDepartment> departmentCacheValues = new CCache("HR_Department", 100, 0);

    public static MHRDepartment getById(Properties ctx, Integer departmentId, String trxName) {
        MHRDepartment department;
        if (departmentId <= 0) {
            return null;
        }
        if (departmentCacheIds.size() == 0) {
            MHRDepartment.getAll(ctx, true, trxName);
        }
        if ((department = (MHRDepartment)((Object)departmentCacheIds.get((Object)departmentId))) != null) {
            return department;
        }
        department = (MHRDepartment)new Query(ctx, "HR_Department", "HR_Department_ID=?", trxName).setClient_ID().setParameters(new Object[]{departmentId}).first();
        if (department != null && department.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + department.getValue();
            departmentCacheIds.put((Object)department.get_ID(), (Object)department);
            departmentCacheValues.put((Object)key, (Object)department);
        }
        return department;
    }

    public static MHRDepartment getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRDepartment department;
        if (value == null) {
            return null;
        }
        if (departmentCacheValues.size() == 0) {
            MHRDepartment.getAll(ctx, true, trxName);
        }
        if ((department = (MHRDepartment)((Object)departmentCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && department.get_ID() > 0) {
            return department;
        }
        department = (MHRDepartment)new Query(ctx, "HR_Department", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (department != null && department.get_ID() > 0) {
            departmentCacheValues.put((Object)key, (Object)department);
            departmentCacheIds.put((Object)department.get_ID(), (Object)department);
        }
        return department;
    }

    public static List<MHRDepartment> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || departmentCacheIds.size() > 0) {
            List departmentList = new Query(Env.getCtx(), "HR_Department", null, trxName).setClient_ID().setOrderBy("Name").list();
            departmentList.stream().forEach(department -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + department.getValue();
                departmentCacheIds.put((Object)department.getHR_Department_ID(), (Object)department);
                departmentCacheValues.put((Object)key, (Object)department);
            });
            return departmentList;
        }
        List<MHRDepartment> departmentList = departmentCacheIds.entrySet().stream().map(departament -> (MHRDepartment)((Object)((Object)departament.getValue()))).collect(Collectors.toList());
        return departmentList;
    }

    public MHRDepartment(Properties ctx, String departmentValue, String departmentName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(departmentValue);
        this.setName(departmentName);
    }

    public MHRDepartment(Properties ctx, int departmentId, String trxName) {
        super(ctx, departmentId, trxName);
    }

    public MHRDepartment(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

