/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Designation;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRDesignation
extends X_HR_Designation {
    private static final long serialVersionUID = 8486805848270844798L;
    private static CCache<Integer, MHRDesignation> designationCacheIds = new CCache("HR_Designation", 50, 0);
    private static CCache<String, MHRDesignation> designationCacheValues = new CCache("HR_Designation", 50, 0);

    public static MHRDesignation getById(Properties ctx, int designationId, String trxName) {
        MHRDesignation designation;
        if (designationId <= 0) {
            return null;
        }
        if (designationCacheIds.size() == 0) {
            MHRDesignation.getAll(ctx, true, trxName);
        }
        if ((designation = (MHRDesignation)((Object)designationCacheIds.get((Object)designationId))) != null) {
            return designation;
        }
        designation = (MHRDesignation)new Query(ctx, "HR_Designation", "HR_Designation_ID=? ", trxName).setClient_ID().setParameters(new Object[]{designationId}).first();
        if (designation != null && designation.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + designation.getValue();
            designationCacheIds.put((Object)designationId, (Object)designation);
            designationCacheValues.put((Object)key, (Object)designation);
        }
        return designation;
    }

    public static MHRDesignation getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRDesignation designation;
        if (value == null) {
            return null;
        }
        if (designationCacheValues.size() == 0) {
            MHRDesignation.getAll(ctx, true, trxName);
        }
        if ((designation = (MHRDesignation)((Object)designationCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && designation.get_ID() > 0) {
            return designation;
        }
        designation = (MHRDesignation)new Query(ctx, "HR_Designation", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (designation != null && designation.get_ID() > 0) {
            designationCacheValues.put((Object)key, (Object)designation);
            designationCacheIds.put((Object)designation.get_ID(), (Object)designation);
        }
        return designation;
    }

    public static List<MHRDesignation> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || designationCacheIds.size() > 0) {
            List designationList = new Query(Env.getCtx(), "HR_Designation", null, trxName).setClient_ID().setOrderBy("Name").list();
            designationList.stream().forEach(Education -> {
                designationCacheIds.put((Object)Education.getHR_Designation_ID(), (Object)Education);
                designationCacheValues.put((Object)Education.getValue(), (Object)Education);
            });
            return designationList;
        }
        List<MHRDesignation> designationList = designationCacheIds.entrySet().stream().map(Designation -> (MHRDesignation)((Object)((Object)Designation.getValue()))).collect(Collectors.toList());
        return designationList;
    }

    public MHRDesignation(Properties ctx, int designationId, String trxName) {
        super(ctx, designationId, trxName);
    }

    public MHRDesignation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

