/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_Employee;
import org.adempiere.core.domains.models.X_I_HR_Employee;
import org.compiere.model.MBPartner;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRPeriod;
import org.eevolution.hr.model.MHRProcess;

public class MHREmployee
extends X_HR_Employee {
    private static final long serialVersionUID = -7083160315471023587L;
    private static CCache<Integer, MHREmployee> employeeCache = new CCache("HR_Employee", 1000);

    public static MHREmployee getByPartnerIdAndStartDate(Properties ctx, Integer partnerId, Timestamp dateStart, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_BPartner_ID").append("=? AND ");
        whereClause.append("StartDate").append("=? ");
        return (MHREmployee)new Query(ctx, "HR_Employee", whereClause.toString(), trxName).setClient_ID().setParameters(new Object[]{partnerId, dateStart}).first();
    }

    public static MHREmployee getById(Properties ctx, int employeeId) {
        if (employeeId <= 0) {
            return null;
        }
        MHREmployee employee = (MHREmployee)((Object)employeeCache.get((Object)employeeId));
        if (employee != null) {
            return employee;
        }
        employee = new MHREmployee(ctx, employeeId, null);
        if (employee.get_ID() == employeeId) {
            employeeCache.put((Object)employeeId, (Object)employee);
        } else {
            employee = null;
        }
        return employee;
    }

    @Deprecated
    public static MHREmployee get(Properties ctx, int employeeId) {
        return MHREmployee.getById(ctx, employeeId);
    }

    public static MBPartner[] getEmployees(MHRProcess process) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("EXISTS(SELECT 1 FROM HR_Employee e WHERE e.C_BPartner_ID = C_BPartner.C_BPartner_ID AND (e.EmployeeStatus = ? OR EmployeeStatus IS NULL) ");
        params.add("13");
        MHRPayroll payroll = MHRPayroll.getById(process.getCtx(), process.getHR_Payroll_ID(), process.get_TrxName());
        if (process.getHR_Payroll_ID() != 0 && process.getHR_Period_ID() != 0 && !payroll.isIgnoreDefaultPayroll()) {
            whereClause.append(" AND (e.HR_Payroll_ID IS NULL OR e.HR_Payroll_ID=?) ");
            params.add(process.getHR_Payroll_ID());
        }
        if (process.getAD_OrgTrx_ID() != 0) {
            whereClause.append(" AND e.AD_OrgTrx_ID=? ");
            params.add(process.getAD_OrgTrx_ID());
        }
        if (process.getC_Project_ID() != 0) {
            whereClause.append(" AND e.C_Project_ID=? ");
            params.add(process.getC_Project_ID());
        }
        if (process.getC_Activity_ID() != 0) {
            whereClause.append(" AND e.C_Activity_ID=? ");
            params.add(process.getC_Activity_ID());
        }
        if (process.getC_Campaign_ID() != 0) {
            whereClause.append(" AND e.C_Campaign_ID=? ");
            params.add(process.getC_Campaign_ID());
        }
        if (process.getC_SalesRegion_ID() != 0) {
            whereClause.append(" AND e.C_SalesRegion_ID=? ");
            params.add(process.getC_SalesRegion_ID());
        }
        whereClause.append(" AND e.IsActive = 'Y' ");
        if (process.getHR_Period_ID() == 0) {
            whereClause.append(" AND e.StartDate <=? ");
            params.add(process.getDateAcct());
        } else {
            MHRPeriod period = new MHRPeriod(process.getCtx(), process.getHR_Period_ID(), process.get_TrxName());
            whereClause.append(" AND e.StartDate <=? ");
            params.add(period.getEndDate());
            whereClause.append(" AND (e.EndDate IS NULL OR e.EndDate >=?) ");
            params.add(period.getStartDate());
        }
        if (process.getHR_Department_ID() != 0) {
            whereClause.append(" AND e.HR_Department_ID =? ");
            params.add(process.getHR_Department_ID());
        }
        if (process.getHR_Job_ID() != 0) {
            whereClause.append(" AND e.HR_Job_ID =? ");
            params.add(process.getHR_Job_ID());
        }
        whereClause.append(" ) ");
        if (process.getC_BPartner_ID() != 0) {
            whereClause.append(" AND C_BPartner_ID =? ");
            params.add(process.getC_BPartner_ID());
        }
        whereClause.append(" AND AD_Client_ID =? ");
        params.add(process.getAD_Client_ID());
        List list = new Query(process.getCtx(), "C_BPartner", whereClause.toString(), process.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("Name").list();
        return list.toArray(new MBPartner[list.size()]);
    }

    public static MHREmployee getActiveEmployee(Properties ctx, int partnerId, String trxName) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(partnerId);
        params.add("13");
        return (MHREmployee)new Query(ctx, "HR_Employee", "C_BPartner_ID=? AND (EmployeeStatus = ? OR EmployeeStatus IS NULL)", trxName).setOnlyActiveRecords(true).setParameters(params).setOrderBy("StartDate DESC").first();
    }

    public MHREmployee(Properties ctx, int employeeId, String trxName) {
        super(ctx, employeeId, trxName);
        if (employeeId == 0) {
            this.setClientOrg(Env.getAD_Client_ID((Properties)Env.getCtx()), Env.getAD_Org_ID((Properties)Env.getCtx()));
        }
    }

    public MHREmployee(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHREmployee(X_I_HR_Employee importEmployee) {
        super(importEmployee.getCtx(), 0, importEmployee.get_TrxName());
        this.updateEmployeeData(importEmployee);
    }

    public MHREmployee updateEmployeeData(X_I_HR_Employee importEmployee) {
        this.setC_BPartner_ID(importEmployee.getC_BPartner_ID());
        this.setAD_Org_ID(importEmployee.getAD_Org_ID());
        this.setAD_User_ID(importEmployee.getAD_User_ID());
        this.setName(importEmployee.getName());
        this.setName2(importEmployee.getName2());
        this.setNationalCode(importEmployee.getNationalCode());
        this.setSSCode(importEmployee.getSSCode());
        this.setNationality_ID(importEmployee.getNationality_ID());
        this.setHR_Race_ID(importEmployee.getHR_Race_ID());
        this.setIdentificationMark(importEmployee.getIdentificationMark());
        this.setMaritalStatus(importEmployee.getMaritalStatus());
        this.setMarriageAnniversaryDate(importEmployee.getMarriageAnniversaryDate());
        this.setPartnersBirthDate(importEmployee.getPartnersBirthDate());
        this.setCode(importEmployee.getCode());
        this.setIsManager(importEmployee.isManager());
        this.setHR_Payroll_ID(importEmployee.getHR_Payroll_ID());
        this.setPaymentRule(importEmployee.getPaymentRule());
        this.setHR_Department_ID(importEmployee.getHR_Department_ID());
        this.setC_Activity_ID(importEmployee.getC_Activity_ID());
        this.setC_Project_ID(importEmployee.getC_Project_ID());
        this.setC_Campaign_ID(importEmployee.getC_Campaign_ID());
        this.setC_SalesRegion_ID(importEmployee.getC_SalesRegion_ID());
        this.setHR_Job_ID(importEmployee.getHR_Job_ID());
        this.setHR_WorkGroup_ID(importEmployee.getHR_WorkGroup_ID());
        this.setHR_ShiftGroup_ID(importEmployee.getHR_ShiftGroup_ID());
        this.setHR_Degree_ID(importEmployee.getHR_Degree_ID());
        this.setHR_Grade_ID(importEmployee.getHR_Grade_ID());
        this.setHR_JobType_ID(importEmployee.getHR_JobType_ID());
        this.setHR_JobEducation_ID(importEmployee.getHR_JobEducation_ID());
        this.setHR_CareerLevel_ID(importEmployee.getHR_CareerLevel_ID());
        this.setHR_Designation_ID(importEmployee.getHR_Designation_ID());
        this.setHR_SalaryStructure_ID(importEmployee.getHR_SalaryStructure_ID());
        this.setHR_SalaryRange_ID(importEmployee.getHR_SalaryRange_ID());
        this.setMonthlySalary(importEmployee.getMonthlySalary());
        this.setDailySalary(importEmployee.getDailySalary());
        this.setStartDate(importEmployee.getStartDate());
        this.setEndDate(importEmployee.getEndDate());
        this.setHR_EmployeeType_ID(importEmployee.getHR_EmployeeType_ID());
        this.setHR_SkillType_ID(importEmployee.getHR_SkillType_ID());
        this.setEmployeeStatus(importEmployee.getEmployeeStatus());
        this.setEmployeeImage_ID(importEmployee.getEmployeeImage_ID());
        this.setLogo_ID(importEmployee.getLogo_ID());
        this.setThumbImage_ID(importEmployee.getThumbImage_ID());
        this.setImageURL(importEmployee.getImageURL());
        return this;
    }
}

