/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_EmployeeType;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHREmployeeType
extends X_HR_EmployeeType {
    private static final long serialVersionUID = -5401875586397002431L;
    private static CCache<Integer, MHREmployeeType> employeeTypeCacheIds = new CCache("HR_EmployeeType", 50, 0);
    private static CCache<String, MHREmployeeType> employeeTypeCacheValues = new CCache("HR_EmployeeType", 50, 0);

    public static List<MHREmployeeType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || employeeTypeCacheIds.size() > 0) {
            List employeeTypeList = new Query(Env.getCtx(), "HR_EmployeeType", null, trxName).setClient_ID().setOrderBy("Name").list();
            employeeTypeList.stream().forEach(employeeType -> {
                int client = Env.getAD_Client_ID((Properties)ctx);
                String key = client + "#" + employeeType.getValue();
                employeeTypeCacheIds.put((Object)employeeType.getHR_EmployeeType_ID(), (Object)employeeType);
                employeeTypeCacheValues.put((Object)key, (Object)employeeType);
            });
            return employeeTypeList;
        }
        List<MHREmployeeType> employeeTypeList = employeeTypeCacheIds.entrySet().stream().map(employeeType -> (MHREmployeeType)((Object)((Object)employeeType.getValue()))).collect(Collectors.toList());
        return employeeTypeList;
    }

    public static MHREmployeeType getById(Properties ctx, int employeeTypeId, String trxName) {
        MHREmployeeType employeeType;
        if (employeeTypeId <= 0) {
            return null;
        }
        if (employeeTypeCacheIds.size() == 0) {
            MHREmployeeType.getAll(ctx, true, trxName);
        }
        if ((employeeType = (MHREmployeeType)((Object)employeeTypeCacheIds.get((Object)employeeTypeId))) != null) {
            return employeeType;
        }
        employeeType = new MHREmployeeType(ctx, employeeTypeId, trxName);
        if (employeeType != null && employeeType.get_ID() == employeeTypeId) {
            int client = Env.getAD_Client_ID((Properties)ctx);
            String key = client + "#" + employeeType.getValue();
            employeeTypeCacheIds.put((Object)employeeTypeId, (Object)employeeType);
            employeeTypeCacheValues.put((Object)key, (Object)employeeType);
        }
        return employeeType;
    }

    public static MHREmployeeType getByValue(Properties ctx, String value, String trxName) {
        int client;
        String key;
        MHREmployeeType employeeType;
        if (value == null) {
            return null;
        }
        if (employeeTypeCacheValues.size() == 0) {
            MHREmployeeType.getAll(ctx, true, trxName);
        }
        if ((employeeType = (MHREmployeeType)((Object)employeeTypeCacheValues.get((Object)(key = (client = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && employeeType.get_ID() > 0) {
            return employeeType;
        }
        employeeType = (MHREmployeeType)new Query(ctx, "HR_EmployeeType", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (employeeType != null && employeeType.getHR_EmployeeType_ID() > 0) {
            employeeTypeCacheValues.put((Object)key, (Object)employeeType);
            employeeTypeCacheIds.put((Object)employeeType.get_ID(), (Object)employeeType);
        }
        return employeeType;
    }

    public MHREmployeeType(Properties ctx, int HR_Employee_ID, String trxName) {
        super(ctx, HR_Employee_ID, trxName);
    }

    public MHREmployeeType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHREmployeeType(Properties ctx, String employeeTypeValue, String employeeTypeName, String wageLevel, Integer payrollId, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(employeeTypeValue);
        this.setName(employeeTypeName);
        this.setWageLevel(wageLevel);
        this.setHR_Payroll_ID(payrollId);
    }
}

