/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Grade;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRGrade
extends X_HR_Grade {
    private static final long serialVersionUID = 35499589044459660L;
    private static CCache<Integer, MHRGrade> gradeCacheIds = new CCache("HR_Grade", 30);
    private static CCache<String, MHRGrade> gradeCacheValues = new CCache("HR_Grade", 30);

    public MHRGrade(Properties ctx, int HR_Grade_ID, String trxName) {
        super(ctx, HR_Grade_ID, trxName);
    }

    public MHRGrade(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRGrade(Properties ctx, String gradeValue, String gradeName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(gradeValue);
        this.setName(gradeName);
    }

    public static MHRGrade getById(Properties ctx, int gradeId, String trxName) {
        if (gradeId <= 0) {
            return null;
        }
        MHRGrade grade = (MHRGrade)((Object)gradeCacheIds.get((Object)gradeId));
        if (grade != null && grade.get_ID() > 0) {
            return grade;
        }
        grade = (MHRGrade)new Query(ctx, "HR_Grade", "HR_Grade_ID=?", trxName).setClient_ID().setParameters(new Object[]{gradeId}).first();
        if (grade != null && grade.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + grade.getValue();
            gradeCacheValues.put((Object)key, (Object)grade);
            gradeCacheIds.put((Object)grade.get_ID(), (Object)grade);
        }
        return grade;
    }

    public static MHRGrade getByValue(Properties ctx, String gradeValue, String trxName) {
        int clientId;
        String key;
        MHRGrade grade;
        if (gradeValue == null) {
            return null;
        }
        if (gradeCacheValues.size() == 0) {
            MHRGrade.getAll(ctx, true, trxName);
        }
        if ((grade = (MHRGrade)((Object)gradeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + gradeValue)))) != null && grade.get_ID() > 0) {
            return grade;
        }
        grade = (MHRGrade)new Query(ctx, "HR_Grade", "Value=?", trxName).setClient_ID().setParameters(new Object[]{gradeValue}).first();
        if (grade != null && grade.get_ID() > 0) {
            gradeCacheValues.put((Object)key, (Object)grade);
            gradeCacheIds.put((Object)grade.get_ID(), (Object)grade);
        }
        return grade;
    }

    public static List<MHRGrade> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || gradeCacheIds.size() > 0) {
            List gradeList = new Query(Env.getCtx(), "HR_Grade", null, trxName).setClient_ID().setOrderBy("Name").list();
            gradeList.stream().forEach(grade -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + grade.getValue();
                gradeCacheIds.put((Object)grade.getHR_Grade_ID(), (Object)grade);
                gradeCacheValues.put((Object)key, (Object)grade);
            });
            return gradeList;
        }
        List<MHRGrade> gradeList = gradeCacheIds.entrySet().stream().map(grade -> (MHRGrade)((Object)((Object)grade.getValue()))).collect(Collectors.toList());
        return gradeList;
    }
}

