/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Job;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRJob
extends X_HR_Job {
    private static final long serialVersionUID = 7130732658556820555L;
    private static CCache<Integer, MHRJob> jobCacheIds = new CCache("HR_Job", 100, 0);
    private static CCache<String, MHRJob> jobCacheValues = new CCache("HR_Job", 100, 0);

    public MHRJob(Properties ctx, int HR_Job_ID, String trxName) {
        super(ctx, HR_Job_ID, trxName);
    }

    public MHRJob(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRJob(Properties ctx, String jobValue, String jobName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(jobValue);
        this.setName(jobName);
    }

    public static MHRJob getById(Properties ctx, int jobId, String trxName) {
        MHRJob job;
        if (jobId <= 0) {
            return null;
        }
        if (jobCacheIds.size() == 0) {
            MHRJob.getAll(ctx, true);
        }
        if ((job = (MHRJob)((Object)jobCacheIds.get((Object)jobId))) != null && job.getHR_Job_ID() > 0) {
            return job;
        }
        job = (MHRJob)new Query(ctx, "HR_Job", "HR_Job_ID=?", trxName).setClient_ID().setParameters(new Object[]{jobId}).first();
        if (job != null && job.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + job.getValue();
            jobCacheIds.put((Object)job.get_ID(), (Object)job);
            jobCacheValues.put((Object)key, (Object)job);
        }
        return job;
    }

    public static MHRJob getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRJob job;
        if (value == null) {
            return null;
        }
        if (jobCacheValues.size() == 0) {
            MHRJob.getAll(ctx, true);
        }
        if ((job = (MHRJob)((Object)jobCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && job.get_ID() > 0) {
            return job;
        }
        job = (MHRJob)new Query(ctx, "HR_Job", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (job != null && job.get_ID() > 0) {
            jobCacheValues.put((Object)key, (Object)job);
            jobCacheIds.put((Object)job.get_ID(), (Object)job);
        }
        return job;
    }

    public static List<MHRJob> getAll(Properties ctx, boolean resetCache) {
        if (resetCache || jobCacheIds.size() > 0) {
            List jobList = new Query(Env.getCtx(), "HR_Job", null, null).setClient_ID().setOrderBy("Name").list();
            jobList.stream().forEach(job -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + job.getValue();
                jobCacheIds.put((Object)job.getHR_Job_ID(), (Object)job);
                jobCacheValues.put((Object)key, (Object)job);
            });
            return jobList;
        }
        List<MHRJob> jobList = jobCacheIds.entrySet().stream().map(job -> (MHRJob)((Object)((Object)job.getValue()))).collect(Collectors.toList());
        return jobList;
    }
}

