/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_JobEducation;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRJobEducation
extends X_HR_JobEducation {
    private static final long serialVersionUID = 8716812432971004170L;
    private static CCache<Integer, MHRJobEducation> jobEducationCacheIds = new CCache("HR_JobEducation", 50, 0);
    private static CCache<String, MHRJobEducation> jobEducationCacheValues = new CCache("HR_JobEducation", 50, 0);

    public static MHRJobEducation getById(Properties ctx, int jobEducationId, String trxName) {
        MHRJobEducation jobEducation;
        if (jobEducationId <= 0) {
            return null;
        }
        if (jobEducationCacheIds.size() == 0) {
            MHRJobEducation.getAll(ctx, true, trxName);
        }
        if ((jobEducation = (MHRJobEducation)((Object)jobEducationCacheIds.get((Object)jobEducationId))) != null && jobEducation.get_ID() > 0) {
            return jobEducation;
        }
        jobEducation = (MHRJobEducation)new Query(ctx, "HR_JobEducation", "HR_JobEducation_ID=?", trxName).setClient_ID().setParameters(new Object[]{jobEducationId}).first();
        if (jobEducation != null && jobEducation.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + jobEducation.getValue();
            jobEducationCacheIds.put((Object)jobEducation.get_ID(), (Object)jobEducation);
            jobEducationCacheValues.put((Object)key, (Object)jobEducation);
        }
        return jobEducation;
    }

    public static MHRJobEducation getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRJobEducation jobEducation;
        if (value == null) {
            return null;
        }
        if (jobEducationCacheValues.size() == 0) {
            MHRJobEducation.getAll(ctx, true, trxName);
        }
        if ((jobEducation = (MHRJobEducation)((Object)jobEducationCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && jobEducation.get_ID() > 0) {
            return jobEducation;
        }
        jobEducation = (MHRJobEducation)new Query(ctx, "HR_JobEducation", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (jobEducation != null && jobEducation.get_ID() > 0) {
            jobEducationCacheValues.put((Object)key, (Object)jobEducation);
            jobEducationCacheIds.put((Object)jobEducation.get_ID(), (Object)jobEducation);
        }
        return jobEducation;
    }

    public static List<MHRJobEducation> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || jobEducationCacheIds.size() > 0) {
            List jobEducationList = new Query(Env.getCtx(), "HR_JobEducation", null, trxName).setClient_ID().setOrderBy("Name").list();
            jobEducationList.stream().forEach(jobEducation -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + jobEducation.getValue();
                jobEducationCacheIds.put((Object)jobEducation.getHR_JobEducation_ID(), (Object)jobEducation);
                jobEducationCacheValues.put((Object)jobEducation.getValue(), (Object)jobEducation);
            });
            return jobEducationList;
        }
        List<MHRJobEducation> jobEducationList = jobEducationCacheIds.entrySet().stream().map(jobEducation -> (MHRJobEducation)((Object)((Object)jobEducation.getValue()))).collect(Collectors.toList());
        return jobEducationList;
    }

    public MHRJobEducation(Properties ctx, String jobEducationValue, String jobEducationName, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(jobEducationValue);
        this.setName(jobEducationName);
    }

    public MHRJobEducation(Properties ctx, int HR_JobEducation_ID, String trxName) {
        super(ctx, HR_JobEducation_ID, trxName);
    }

    public MHRJobEducation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }
}

