/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_PaySelectionLine;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRPaySelection;

public class MHRPaySelectionLine
extends X_HR_PaySelectionLine {
    private static final long serialVersionUID = -3486055138810301789L;

    public MHRPaySelectionLine(Properties ctx, int HR_PaySelectionLine_ID, String trxName) {
        super(ctx, HR_PaySelectionLine_ID, trxName);
        if (HR_PaySelectionLine_ID == 0) {
            this.setIsSOTrx(false);
            this.setOpenAmt(Env.ZERO);
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setDifferenceAmt(Env.ZERO);
            this.setIsManual(false);
        }
    }

    public MHRPaySelectionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRPaySelectionLine(MHRPaySelection ps, int Line, String PaymentRule) {
        this(ps.getCtx(), 0, ps.get_TrxName());
        this.setClientOrg((PO)ps);
        this.setHR_PaySelection_ID(ps.getHR_PaySelection_ID());
        this.setLine(Line);
        this.setPaymentRule(PaymentRule);
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setDifferenceAmt(this.getOpenAmt().subtract(this.getPayAmt()).subtract(this.getDiscountAmt()));
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.setHeader();
        return success;
    }

    protected boolean afterDelete(boolean success) {
        this.setHeader();
        return success;
    }

    private void setHeader() {
        String sql = "UPDATE HR_PaySelection ps SET TotalAmt = (SELECT COALESCE(SUM(psl.PayAmt),0) FROM HR_PaySelectionLine psl WHERE ps.HR_PaySelection_ID=psl.HR_PaySelection_ID AND psl.IsActive='Y') WHERE HR_PaySelection_ID=" + this.getHR_PaySelection_ID();
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }
}

