/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_Payroll;
import org.compiere.model.MCalendar;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.hr.model.MHRPeriod;

public class MHRPayroll
extends X_HR_Payroll {
    private static final long serialVersionUID = -1407037967021019961L;
    private static CCache<Integer, MHRPayroll> payrollCacheIds = new CCache("HR_Payroll", 10);
    private static CCache<String, MHRPayroll> payrollCacheValues = new CCache("HR_Payroll_Value", 10);

    public MHRPayroll(Properties ctx, int HR_Payroll_ID, String trxName) {
        super(ctx, HR_Payroll_ID, trxName);
        if (HR_Payroll_ID == 0) {
            this.setProcessing(false);
        }
    }

    public MHRPayroll(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRPayroll(MCalendar calendar) {
        this(calendar.getCtx(), 0, calendar.get_TrxName());
        this.setClientOrg((PO)calendar);
    }

    @Deprecated
    public static MHRPayroll forValue(Properties ctx, String payrollValue) {
        return MHRPayroll.getByValue(ctx, payrollValue, null);
    }

    public static MHRPayroll getByValue(Properties ctx, String payrollValue, String trxName) {
        if (Util.isEmpty((String)payrollValue, (boolean)true)) {
            return null;
        }
        int clientId = Env.getAD_Client_ID((Properties)ctx);
        String key = clientId + "#" + payrollValue;
        MHRPayroll payroll = (MHRPayroll)((Object)payrollCacheValues.get((Object)key));
        if (payroll != null && payroll.get_ID() > 0) {
            return payroll;
        }
        payroll = (MHRPayroll)new Query(ctx, "HR_Payroll", "Value=?", trxName).setClient_ID().setParameters(new Object[]{payrollValue}).setOnlyActiveRecords(true).first();
        if (payroll != null && payroll.get_ID() > 0) {
            payrollCacheValues.put((Object)key, (Object)payroll);
            payrollCacheIds.put((Object)payroll.get_ID(), (Object)payroll);
        }
        return payroll;
    }

    @Deprecated
    public static MHRPayroll get(Properties ctx, int payrollId) {
        return MHRPayroll.getById(ctx, payrollId, null);
    }

    public static MHRPayroll getById(Properties ctx, int payrollId, String trxName) {
        if (payrollId <= 0) {
            return null;
        }
        MHRPayroll payroll = (MHRPayroll)((Object)payrollCacheIds.get((Object)payrollId));
        if (payroll != null && payroll.get_ID() > 0) {
            return payroll;
        }
        payroll = (MHRPayroll)new Query(ctx, "HR_Payroll", "HR_Payroll_ID=?", trxName).setClient_ID().setParameters(new Object[]{payrollId}).first();
        if (payroll != null && payroll.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + payroll.getValue();
            payrollCacheIds.put((Object)payroll.get_ID(), (Object)payroll);
            payrollCacheValues.put((Object)key, (Object)payroll);
        }
        return payroll;
    }

    public int countPeriods() {
        StringBuilder where = new StringBuilder();
        where.append("HR_Payroll_ID").append("=?");
        return new Query(this.getCtx(), "HR_Period", where.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getHR_Payroll_ID()}).count();
    }

    public MHRPeriod getPeriodByDate(Timestamp date) {
        StringBuilder where = new StringBuilder();
        where.append("HR_Payroll_ID").append("=? AND ");
        where.append("?").append(" BETWEEN ").append("StartDate").append(" AND ").append("EndDate");
        return (MHRPeriod)new Query(this.getCtx(), "HR_Period", where.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getHR_Payroll_ID(), date}).firstOnly();
    }

    public List<MHRPeriod> getPeriods(Timestamp from, Timestamp to) {
        StringBuilder where = new StringBuilder();
        where.append("HR_Payroll_ID").append("=? AND ");
        where.append("StartDate").append(">=?  AND  ");
        where.append("EndDate").append("<=?");
        return new Query(this.getCtx(), "HR_Period", where.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getHR_Payroll_ID(), from, to}).list();
    }

    public MHRPeriod[] getPeriodsAsArray(Timestamp from, Timestamp to) {
        List<MHRPeriod> periods = this.getPeriods(from, to);
        MHRPeriod[] arrayPeriods = new MHRPeriod[periods.size()];
        periods.toArray(arrayPeriods);
        return arrayPeriods;
    }

    public MHRPeriod getPeriodByPeriodNo(String year, int periodNo) {
        StringBuilder where = new StringBuilder();
        where.append("HR_Payroll_ID").append("=? AND ").append("PeriodNo").append("=? AND ").append("EXISTS (SELECT 1 FROM ").append("C_Period").append(" period ").append(" INNER JOIN ").append("C_Year").append(" year ON (period.").append("C_Year_ID").append("=").append("year.").append("C_Year_ID").append(") WHERE period.").append("C_Period_ID").append("=").append("HR_Period").append(".").append("C_Period_ID").append(" AND year.").append("FiscalYear").append("=?)");
        return (MHRPeriod)new Query(this.getCtx(), "HR_Period", where.toString(), this.get_TrxName()).setClient_ID().setParameters(new Object[]{this.getHR_Payroll_ID(), periodNo, year}).firstOnly();
    }
}

