/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Race;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRRace
extends X_HR_Race {
    private static final long serialVersionUID = -3538768176497234268L;
    private static CCache<Integer, MHRRace> raceCacheIds = new CCache("HR_Race", 10, 0);
    private static CCache<String, MHRRace> raceCacheValues = new CCache("HR_Race", 10, 0);

    public MHRRace(Properties ctx, int raceId, String trxName) {
        super(ctx, raceId, trxName);
    }

    public MHRRace(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRRace(Properties ctx, String value, String name, String trxName) {
        super(ctx, 0, trxName);
        this.setAD_Org_ID(0);
        this.setValue(value);
        this.setName(name);
    }

    public static MHRRace getById(Properties ctx, int raceId, String trxName) {
        MHRRace race;
        if (raceId <= 0) {
            return null;
        }
        if (raceCacheIds.size() == 0) {
            MHRRace.getAll(ctx, true, trxName);
        }
        if ((race = (MHRRace)((Object)raceCacheIds.get((Object)raceId))) != null) {
            return race;
        }
        race = (MHRRace)new Query(ctx, "HR_Race", "HR_Race_ID=?", trxName).setClient_ID().setParameters(new Object[]{raceId}).first();
        if (race != null && race.getHR_Race_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + race.getValue();
            raceCacheIds.put((Object)race.get_ID(), (Object)race);
            raceCacheValues.put((Object)key, (Object)race);
        }
        return race;
    }

    public static MHRRace getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRRace race;
        if (value == null) {
            return null;
        }
        if (raceCacheValues.size() == 0) {
            MHRRace.getAll(ctx, true, trxName);
        }
        if ((race = (MHRRace)((Object)raceCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && race.get_ID() > 0) {
            return race;
        }
        race = (MHRRace)new Query(ctx, "HR_Race", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (race != null && race.getHR_Race_ID() > 0) {
            raceCacheValues.put((Object)key, (Object)race);
            raceCacheIds.put((Object)race.get_ID(), (Object)race);
        }
        return race;
    }

    public static List<MHRRace> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || raceCacheIds.size() > 0) {
            List raceList = new Query(ctx, "HR_Race", null, trxName).setClient_ID().setOrderBy("Name").list();
            raceList.stream().forEach(race -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + race.getValue();
                raceCacheIds.put((Object)race.getHR_Race_ID(), (Object)race);
                raceCacheValues.put((Object)key, (Object)race);
            });
            return raceList;
        }
        List<MHRRace> raceList = raceCacheIds.entrySet().stream().map(departament -> (MHRRace)((Object)((Object)departament.getValue()))).collect(Collectors.toList());
        return raceList;
    }
}

