/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_Relationship;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MHRRelationship
extends X_HR_Relationship {
    private static final long serialVersionUID = -2360647159210490316L;
    private static CCache<Integer, MHRRelationship> relationshipCacheIds = new CCache("HR_Relationship", 10, 0);
    private static CCache<String, MHRRelationship> relationshipCacheValues = new CCache("HR_Relationship", 10, 0);

    public MHRRelationship(Properties ctx, int HR_Relationship_ID, String trxName) {
        super(ctx, HR_Relationship_ID, trxName);
    }

    public MHRRelationship(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MHRRelationship getById(Properties ctx, int raceId, String trxName) {
        MHRRelationship relationship;
        if (raceId <= 0) {
            return null;
        }
        if (relationshipCacheIds.size() == 0) {
            MHRRelationship.getAll(ctx, true, trxName);
        }
        if ((relationship = (MHRRelationship)((Object)relationshipCacheIds.get((Object)raceId))) != null) {
            return relationship;
        }
        relationship = (MHRRelationship)new Query(ctx, "HR_Relationship", "HR_Relationship_ID=?", trxName).setClient_ID().setParameters(new Object[]{raceId}).first();
        if (relationship != null && relationship.getHR_Relationship_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + relationship.getValue();
            relationshipCacheIds.put((Object)relationship.get_ID(), (Object)relationship);
            relationshipCacheValues.put((Object)key, (Object)relationship);
        }
        return relationship;
    }

    public static MHRRelationship getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MHRRelationship relationship;
        if (value == null) {
            return null;
        }
        if (relationshipCacheValues.size() == 0) {
            MHRRelationship.getAll(ctx, true, trxName);
        }
        if ((relationship = (MHRRelationship)((Object)relationshipCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + value)))) != null && relationship.get_ID() > 0) {
            return relationship;
        }
        relationship = (MHRRelationship)new Query(ctx, "HR_Relationship", "Value=?", trxName).setClient_ID().setParameters(new Object[]{value}).first();
        if (relationship != null && relationship.getHR_Relationship_ID() > 0) {
            relationshipCacheValues.put((Object)key, (Object)relationship);
            relationshipCacheIds.put((Object)relationship.get_ID(), (Object)relationship);
        }
        return relationship;
    }

    public static List<MHRRelationship> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || relationshipCacheIds.size() > 0) {
            List raceList = new Query(ctx, "HR_Relationship", null, trxName).setClient_ID().setOrderBy("Name").list();
            raceList.stream().forEach(relationship -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + relationship.getValue();
                relationshipCacheIds.put((Object)relationship.getHR_Relationship_ID(), (Object)relationship);
                relationshipCacheValues.put((Object)key, (Object)relationship);
            });
            return raceList;
        }
        List<MHRRelationship> raceList = relationshipCacheIds.entrySet().stream().map(departament -> (MHRRelationship)((Object)((Object)departament.getValue()))).collect(Collectors.toList());
        return raceList;
    }
}

