/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_HR_ShiftGroup;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.eevolution.hr.model.MHRWorkShift;

public class MHRShiftGroup
extends X_HR_ShiftGroup {
    private static final long serialVersionUID = -1755954371112844248L;
    private static CCache<Integer, MHRShiftGroup> shiftGroupCacheIds = new CCache("HR_ShiftGroup", 30);
    private static CCache<String, MHRShiftGroup> shiftGroupCacheValues = new CCache("HR_ShiftGroup", 30);
    private List<MHRWorkShift> workShiftList = null;

    public MHRShiftGroup(Properties ctx, int HR_ShiftGroup_ID, String trxName) {
        super(ctx, HR_ShiftGroup_ID, trxName);
    }

    public MHRShiftGroup(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MHRShiftGroup getById(Properties ctx, int shiftGroupId, String trxName) {
        if (shiftGroupId <= 0) {
            return null;
        }
        MHRShiftGroup shiftGroup = (MHRShiftGroup)((Object)shiftGroupCacheIds.get((Object)shiftGroupId));
        if (shiftGroup != null && shiftGroup.get_ID() > 0) {
            return shiftGroup;
        }
        shiftGroup = (MHRShiftGroup)new Query(ctx, "HR_ShiftGroup", "HR_ShiftGroup_ID=?", trxName).setClient_ID().setParameters(new Object[]{shiftGroupId}).first();
        if (shiftGroup != null && shiftGroup.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + shiftGroup.getValue();
            shiftGroupCacheValues.put((Object)key, (Object)shiftGroup);
            shiftGroupCacheIds.put((Object)shiftGroup.get_ID(), (Object)shiftGroup);
        }
        return shiftGroup;
    }

    public static MHRShiftGroup getByValue(Properties ctx, String shiftGroupValue, String trxName) {
        int clientId;
        String key;
        MHRShiftGroup shiftGroup;
        if (shiftGroupValue == null) {
            return null;
        }
        if (shiftGroupCacheValues.size() == 0) {
            MHRShiftGroup.getAll(ctx, true, trxName);
        }
        if ((shiftGroup = (MHRShiftGroup)((Object)shiftGroupCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + shiftGroupValue)))) != null && shiftGroup.get_ID() > 0) {
            return shiftGroup;
        }
        shiftGroup = (MHRShiftGroup)new Query(ctx, "HR_ShiftGroup", "Value=?", trxName).setClient_ID().setParameters(new Object[]{shiftGroupValue}).first();
        if (shiftGroup != null && shiftGroup.get_ID() > 0) {
            shiftGroupCacheValues.put((Object)key, (Object)shiftGroup);
            shiftGroupCacheIds.put((Object)shiftGroup.get_ID(), (Object)shiftGroup);
        }
        return shiftGroup;
    }

    public static List<MHRShiftGroup> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || shiftGroupCacheIds.size() > 0) {
            List shiftGroupList = new Query(Env.getCtx(), "HR_ShiftGroup", null, trxName).setClient_ID().setOrderBy("Name").list();
            shiftGroupList.stream().forEach(shiftGroup -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + shiftGroup.getValue();
                shiftGroupCacheIds.put((Object)shiftGroup.getHR_ShiftGroup_ID(), (Object)shiftGroup);
                shiftGroupCacheValues.put((Object)key, (Object)shiftGroup);
            });
            return shiftGroupList;
        }
        List<MHRShiftGroup> shiftGroupList = shiftGroupCacheIds.entrySet().stream().map(shiftGroup -> (MHRShiftGroup)((Object)((Object)shiftGroup.getValue()))).collect(Collectors.toList());
        return shiftGroupList;
    }

    public List<MHRWorkShift> getWorkShiftList(boolean reQuery) {
        if (reQuery || this.workShiftList == null) {
            this.workShiftList = MHRWorkShift.getFromGroup(this.getCtx(), this.getHR_ShiftGroup_ID(), this.get_TrxName());
        }
        return this.workShiftList;
    }
}

