/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_HR_Year;
import org.compiere.model.MCalendar;
import org.compiere.model.MPeriod;
import org.compiere.model.PO;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.hr.model.MHRPayroll;
import org.eevolution.hr.model.MHRPeriod;

public class MHRYear
extends X_HR_Year {
    private static final long serialVersionUID = -7789699154024839462L;

    public MHRYear(Properties ctx, int HR_Year_ID, String trxName) {
        super(ctx, HR_Year_ID, trxName);
        if (HR_Year_ID == 0) {
            this.setProcessing(false);
        }
    }

    public MHRYear(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MHRYear(MCalendar calendar) {
        this(calendar.getCtx(), 0, calendar.get_TrxName());
        this.setClientOrg((PO)calendar);
    }

    public boolean createPeriods() {
        int sumDays = 0;
        int calendarId = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT C_Calendar_ID FROM C_Year WHERE C_Year_ID = ?", (Object[])new Object[]{this.getC_Year_ID()});
        if (calendarId <= 0) {
            return false;
        }
        Timestamp startDate = null;
        Timestamp endDate = null;
        for (int period = 1; period <= this.getQty(); ++period) {
            if (12 == this.getQty() && (28 == this.getNetDays() || 29 == this.getNetDays() || 30 == this.getNetDays() || 31 == this.getNetDays())) {
                startDate = period > 1 ? TimeUtil.addDays(endDate, (int)1) : TimeUtil.addDays((Timestamp)this.getStartDate(), (int)0);
                endDate = TimeUtil.getMonthLastDay((Timestamp)startDate);
            } else if (24 == this.getQty() && (15 == this.getNetDays() || 16 == this.getNetDays())) {
                boolean par;
                startDate = period > 1 ? TimeUtil.addDays(endDate, (int)1) : TimeUtil.addDays((Timestamp)this.getStartDate(), (int)0);
                boolean bl = par = period % 2 == 0;
                endDate = !par ? TimeUtil.addDays((Timestamp)startDate, (int)(this.getNetDays() - 1)) : TimeUtil.getMonthLastDay((Timestamp)startDate);
            } else {
                sumDays = period == 1 ? 0 : (period - 1) * this.getNetDays();
                startDate = TimeUtil.addDays((Timestamp)this.getStartDate(), (int)sumDays);
                endDate = TimeUtil.addDays((Timestamp)startDate, (int)(this.getNetDays() - 1));
            }
            int periodId = DB.getSQLValueEx((String)this.get_TrxName(), (String)"SELECT C_Period_ID FROM C_Period p  INNER JOIN C_Year y ON (p.C_Year_ID=y.C_Year_ID)  WHERE  ? BETWEEN p.startdate AND p.endDate AND y.C_Calendar_ID=?", (Object[])new Object[]{endDate, calendarId});
            if (periodId <= 0) {
                return false;
            }
            String fromAndTo = DisplayType.getDateFormat((int)15).format(startDate) + " " + Msg.translate((Properties)this.getCtx(), (String)"To") + " " + DisplayType.getDateFormat((int)15).format(endDate);
            StringBuffer message = new StringBuffer();
            if (this.getHR_Payroll_ID() > 0) {
                MHRPayroll payroll = new MHRPayroll(this.getCtx(), this.getHR_Payroll_ID(), this.get_TrxName());
                message.append(Msg.translate((Properties)this.getCtx(), (String)"HR_Payroll_ID")).append(" ").append(payroll.getName().trim()).append(" ");
            }
            message.append(Msg.translate((Properties)this.getCtx(), (String)"HR_Period_ID")).append(" ").append(period).append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"From")).append(" ").append(fromAndTo);
            MPeriod standardPeriod = MPeriod.get((Properties)this.getCtx(), (int)periodId);
            MHRPeriod payrollPeriod = new MHRPeriod(this.getCtx(), 0, this.get_TrxName());
            payrollPeriod.setAD_Org_ID(this.getAD_Org_ID());
            payrollPeriod.setHR_Year_ID(this.getHR_Year_ID());
            payrollPeriod.setHR_Payroll_ID(this.getHR_Payroll_ID());
            payrollPeriod.setName(fromAndTo);
            payrollPeriod.setDescription(message.toString());
            payrollPeriod.setPeriodNo(period);
            payrollPeriod.setC_Period_ID(periodId);
            payrollPeriod.setC_Year_ID(standardPeriod.getC_Year_ID());
            payrollPeriod.setStartDate(startDate);
            payrollPeriod.setEndDate(endDate);
            payrollPeriod.setDateAcct(endDate);
            payrollPeriod.setIsActive(true);
            payrollPeriod.saveEx();
        }
        return true;
    }
}

