/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.hr.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.hr.model.MHRAttribute;
import org.eevolution.hr.model.MHRConcept;
import org.eevolution.hr.model.MHREmployee;
import org.eevolution.hr.model.MHRMovement;
import org.eevolution.hr.model.MHRPeriod;
import org.eevolution.hr.model.MHRProcess;
import org.eevolution.hr.process.HRCreateInvoiceAbstract;

public class HRCreateInvoice
extends HRCreateInvoiceAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        MHRProcess process = new MHRProcess(this.getCtx(), this.getHRProcessId(), this.get_TrxName());
        AtomicReference<Timestamp> dateInvoice = new AtomicReference<Timestamp>(this.getDateInvoiced());
        if (dateInvoice.get() == null && process.getHR_Period_ID() > 0) {
            MHRPeriod period = MHRPeriod.getById(this.getCtx(), process.getHR_Period_ID(), this.get_TrxName());
            dateInvoice.set(period.getStartDate());
        }
        if (dateInvoice.get() == null) {
            dateInvoice.set(process.getDateAcct());
        }
        Arrays.stream(this.getEmployeeIds(process)).filter(partnerId -> partnerId > 0).forEach(partnerId -> Trx.run(trxName -> {
            int lastPartnerId = 0;
            MHREmployee employee = null;
            MInvoice invoice = null;
            for (MHRMovement movement : this.getPayrollMovement(this.getHRProcessId(), partnerId, trxName)) {
                MHRConcept concept;
                MBPartner partner = new MBPartner(this.getCtx(), partnerId, trxName);
                MHRAttribute attribute = MHRAttribute.getByConceptIdAndPartnerId(movement.getCtx(), movement.getHR_Concept_ID(), movement.getC_BPartner_ID(), movement.getValidFrom(), trxName);
                if (attribute != null && attribute.getC_DocType_ID() == 0) {
                    concept = MHRConcept.getById(this.getCtx(), movement.getHR_Concept_ID(), trxName);
                    this.log.log(Level.SEVERE, "@HR_Employee_ID@ " + partner.getName() + "  @HR_Concept_ID@  " + concept.getName() + " @C_DocType_ID@ @NotFound@ : ");
                    this.addLog(0, null, null, "@HR_Employee_ID@ " + partner.getName() + "  @HR_Concept_ID@  " + concept.getName() + " @C_DocType_ID@ @NotFound@ : ");
                    continue;
                }
                if (attribute != null && attribute.getC_Charge_ID() == 0) {
                    concept = MHRConcept.getById(this.getCtx(), movement.getHR_Concept_ID(), trxName);
                    this.log.log(Level.SEVERE, "@HR_Employee_ID@ " + partner.getName() + "  @HR_Concept_ID@  " + concept.getName() + " @C_Charge_ID@ @NotFound@ : ");
                    this.addLog(0, null, null, "@HR_Employee_ID@ " + partner.getName() + "  @HR_Concept_ID@  " + concept.getName() + " @C_Charge_ID@ @NotFound@ : ");
                    continue;
                }
                if (movement.getC_BPartner_ID() != lastPartnerId) {
                    lastPartnerId = movement.getC_BPartner_ID();
                    employee = MHREmployee.getActiveEmployee(this.getCtx(), partner.getC_BPartner_ID(), trxName);
                    invoice = this.createInvoice(process, partner, employee, attribute.getC_DocType_ID(), (Timestamp)dateInvoice.get());
                    if (invoice == null) continue;
                }
                if (invoice == null) continue;
                this.createInvoiceLine(invoice, employee, movement, attribute.getC_Charge_ID());
            }
        }));
        return "@OK@";
    }

    private List<MHRMovement> getPayrollMovement(int processId, int partnerId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("HR_Movement.HR_Process_ID = ? AND HR_Movement.C_BPartner_ID=? AND ").append("EXISTS (SELECT 1 FROM HR_Concept c INNER JOIN HR_Attribute a ON (c.HR_Concept_ID = a.HR_Concept_ID) ").append("WHERE HR_Movement.C_InvoiceLine_ID IS NULL AND c.HR_Concept_ID=HR_Movement.HR_Concept_ID AND  a.IsActive = ? AND c.IsInvoiced=? AND a.C_DocType_ID > 0 AND a.C_Charge_ID > 0)");
        return new Query(this.getCtx(), "HR_Movement", whereClause.toString(), trxName).setClient_ID().setParameters(new Object[]{processId, partnerId, true, true}).list();
    }

    private MBPartnerLocation getLocationBill(MBPartner partner) {
        String whereClause = "C_BPartner_ID=? AND IsBillTo=? AND IsActive=?";
        return (MBPartnerLocation)new Query(partner.getCtx(), "C_BPartner_Location", whereClause, partner.get_TrxName()).setClient_ID().setParameters(new Object[]{partner.getC_BPartner_ID(), true, true}).first();
    }

    public int[] getEmployeeIds(MHRProcess process) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EXISTS ( SELECT 1 FROM HR_Attribute a ").append("INNER JOIN HR_Concept c ON c.HR_Concept_ID=a.HR_Concept_ID ").append("WHERE a.IsActive = 'Y' AND a.C_Charge_ID > 0 AND c.IsInvoiced='Y' ").append("AND a.C_DocType_ID > 0 AND EXISTS (SELECT 1 FROM HR_Movement m WHERE m.HR_Process_ID=? ").append("AND m.C_BPartner_ID=C_BPartner.C_BPartner_ID AND m.HR_Concept_ID = c.HR_Concept_ID AND m.C_InvoiceLine_ID IS NULL))");
        return new Query(this.getCtx(), "C_BPartner", whereClause.toString(), this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(new Object[]{process.getHR_Process_ID()}).setOrderBy("Value").getIDs();
    }

    private MInvoice createInvoice(MHRProcess process, MBPartner partner, MHREmployee employee, int docTypeId, Timestamp dateInvoice) {
        MBPartnerLocation partnerLocation = this.getLocationBill(partner);
        if (partnerLocation == null) {
            this.log.log(Level.SEVERE, " @C_BPartner_Location_ID@ @NotFound@ : " + partner.getName());
            this.addLog(0, process.getDateAcct(), null, "@Bill_Location_ID@ @NotFound@ " + process.getDocumentNo() + " " + partner.getName());
            return null;
        }
        String paymentRule = employee.getPaymentRule();
        if (paymentRule == null || paymentRule.isEmpty()) {
            paymentRule = partner.getPaymentRule();
        }
        if (paymentRule == null) {
            this.log.log(Level.SEVERE, " @PaymentRule@ @NotFound@ : " + partner.getName());
            this.addLog(0, process.getDateAcct(), null, "@PaymentRule@ @NotFound@ " + process.getDocumentNo() + " " + process.getName() + " " + partner.getValue() + " " + partner.getName());
            return null;
        }
        this.log.info("New Invoice for ");
        MInvoice invoice = new MInvoice(process.getCtx(), 0, partner.get_TrxName());
        invoice.setAD_Org_ID(process.getAD_Org_ID());
        invoice.setIsSOTrx(false);
        invoice.setPaymentRule(paymentRule);
        invoice.setC_DocTypeTarget_ID(docTypeId);
        invoice.setC_DocType_ID(docTypeId);
        invoice.setDescription(Msg.parseTranslation((Properties)process.getCtx(), (String)("@HR_Process_ID@ " + process.getName() + " @DocumentNo@ " + process.getDocumentNo())));
        invoice.setDateOrdered(dateInvoice);
        invoice.setDateInvoiced(dateInvoice);
        invoice.setDateAcct(dateInvoice);
        invoice.setBPartner(partner);
        MPaymentTerm paymentTerm = MPaymentTerm.getPaymentTermByDefault((Properties)this.getCtx(), (String)partner.get_TrxName());
        if (paymentTerm != null) {
            invoice.setC_PaymentTerm_ID(paymentTerm.getC_PaymentTerm_ID());
        }
        if (employee.getC_Activity_ID() != 0) {
            invoice.setC_Activity_ID(employee.getC_Activity_ID());
        }
        invoice.setDocStatus("DR");
        invoice.setDocAction("--");
        invoice.setSalesRep_ID(Env.getAD_User_ID((Properties)process.getCtx()));
        invoice.saveEx();
        this.addLog(0, invoice.getDateInvoiced(), invoice.getGrandTotal(), "@C_Invoice_ID@ " + invoice.getDocumentNo() + " @C_BPartner_ID@  @TaxId@ " + invoice.getC_BPartner().getValue() + " @Name@ " + invoice.getC_BPartner().getName());
        return invoice;
    }

    private MInvoiceLine createInvoiceLine(MInvoice invoice, MHREmployee employee, MHRMovement movement, int chargeId) {
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        MHRConcept concept = MHRConcept.getById(this.getCtx(), movement.getHR_Concept_ID(), movement.get_TrxName());
        invoiceLine.setC_Charge_ID(chargeId);
        invoiceLine.setQty(BigDecimal.ONE);
        invoiceLine.setDescription(concept.getName());
        invoiceLine.setC_Activity_ID(employee.getC_Activity_ID());
        invoiceLine.setPrice(movement.getAmount());
        invoiceLine.setTax();
        invoiceLine.saveEx();
        this.addLog(invoiceLine.getLine(), invoice.getDateInvoiced(), invoiceLine.getLineNetAmt(), concept.getName());
        movement.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
        movement.saveEx();
        return invoiceLine;
    }
}

